<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
/**
 * Get Route
 */
// Home page
$routes->get('/', 'HomeController::index');
//Contact Page
$routes->get('contact', 'HomeController::contact');
// Login Page
$routes->get('admin', 'AuthController::login');
$routes->get('login', 'AuthController::login');
$routes->post('verify-otp', 'AuthController::verify_otp');
$routes->get('verify_otp_test', 'AuthController::verify_otp_test');
//logout
$routes->get('logout', 'AuthController::logout');
// registration page
$routes->get('registration', 'AuthController::registration');
// Google Login
$routes->get('google-login', 'GoogleAuthController::login');
$routes->get('google-callback', 'GoogleAuthController::callback');
//tranck order
$routes->get('track-order', 'HomeController::track_order');
// cart page
$routes->get('cart', 'HomeController::cart_page');
// checkout page
$routes->get('checkout', 'HomeController::checkout_page');
//get cart total
$routes->get('cart_total', 'HomeController::cart_total');
// Address fetch
$routes->get('get_country', 'HomeController::get_country');
$routes->get('get_state', 'HomeController::get_state');
$routes->get('get_city', 'HomeController::get_city');
//order complete page
$routes->get('order_success', 'HomeController::order_success');
//track Order
$routes->get('track-order', 'HomeController::track_order');
// all blogs
$routes->get('blog', 'HomeController::all_blog');
// About Us
$routes->get('general-information', 'HomeController::general_information');
$routes->get('our-team', 'HomeController::our_team');
//Event
$routes->get('event', 'HomeController::all_event');
//media
$routes->get('media', 'HomeController::all_media');
// print cost calculator
$routes->get('print-cost-calculator', 'HomeController::print_cost_calculator');
//register as author
$routes->get('register-as-author', 'HomeController::register_as_author');
//help for author
$routes->get('help-for-author', 'HomeController::help_for_author');
// print your book
$routes->get('print-your-book', 'HomeController::print_your_book');
// publish your book
$routes->get('publish-your-book', 'HomeController::publish_your_book');
//magazine
$routes->get('magazine', 'HomeController::all_magazine');
$routes->get('magazine/(:any)/(:num)', 'HomeController::magazine_edition/$1/$2');

/**
 * User Dashboard Start
 */
// my account

$routes->get('my-account', 'HomeController::my_account');
/**
 * User Dashboard End
 */

/**
 * Post Route
 */
//login post
$routes->post('login', 'AuthController::login');
// pin code data
$routes->post('get_delivery_details_by_pin_code', 'HomeController::get_delivery_details_by_pin_code');
// add to cart
$routes->post('add_to_cart', 'HomeController::add_to_cart');
//product delete from cart
$routes->post('remove_cart', 'HomeController::remove_cart');
//update cart
$routes->post('update_cart', 'HomeController::update_cart');
//remove cart
$routes->post('remove_cart', 'HomeController::remove_cart');
//remove cart
$routes->post('submit_order', 'HomeController::submit_order');
//track Order
$routes->post('track-order', 'HomeController::track_order');
// check mobile exists or not
$routes->post('check_mobile_avaliblity', 'HomeController::check_mobile_avaliblity');
// check email exists or not
$routes->post('check_email_avaliblity', 'HomeController::check_email_avaliblity');
// author registartion
$routes->post('author_registartion', 'HomeController::author_registartion');


/**
 * Admin Router
 */
$routes->group('admin', ['filter' => 'auth'], function ($routes) {
    //dashboard
    $routes->get('/', 'Admin\AdminController::index');
    $routes->get('dashboard', 'Admin\AdminController::index');
    //profile
    $routes->get('my_profile', 'Admin\AdminController::my_profile');
    //update profile
    $routes->post('update_my_profile', 'Admin\AdminController::update_my_profile');
    //update password page
    $routes->get('update_password', 'Admin\AdminController::update_password');
    //update password
    $routes->post('update_password_data', 'Admin\AdminController::update_password_data');
    //logout
    $routes->get('logout', 'Admin\AdminController::logout');
    //erorr 404
    $routes->get('404', 'Admin\AdminController::invalid_page');
    //change account status
    $routes->get('change_account_status/(:num)/(:num)', 'Admin\AdminController::change_account_status/$1/$2');
    
    

    /**
     * Product & Product category
     */
    $routes->group('product', function ($routes) {
        // product category section start
        $routes->get('all_category', 'Admin\ProductController::all_category');
        $routes->get('add_new_category', 'Admin\ProductController::add_new_category');
        $routes->post('add_category', 'Admin\ProductController::add_category');
        $routes->get('delete_category/(:num)', 'Admin\ProductController::delete_category/$1');
        $routes->get('deactive_category/(:num)', 'Admin\ProductController::deactive_category/$1');
        $routes->get('active_category/(:num)', 'Admin\ProductController::active_category/$1');
        $routes->get('edit_category/(:num)', 'Admin\ProductController::edit_category/$1');
        $routes->post('update_category/(:num)', 'Admin\ProductController::update_category/$1');
        $routes->post('fetch_all_sub_category', 'Admin\ProductController::fetch_all_sub_category');
        // product category section End
        
         // product Author section start
         $routes->get('all_author', 'Admin\ProductController::all_author');
         $routes->post('add_author', 'Admin\ProductController::add_author');
         $routes->get('edit_author/(:num)', 'Admin\ProductController::edit_author/$1');
         $routes->post('update_author/(:num)', 'Admin\ProductController::update_author/$1');
         $routes->get('delete_author/(:num)', 'Admin\ProductController::delete_author/$1');
         // product Author section End

        // product section start
        $routes->get('all_product', 'Admin\ProductController::view_all_product');
        $routes->get('add_new_product', 'Admin\ProductController::add_new_product');
        $routes->post('add_product', 'Admin\ProductController::new_product_add');
        $routes->get('edit_product/(:num)', 'Admin\ProductController::edit_product/$1');
        $routes->get('delete_product/(:num)', 'Admin\ProductController::delete_product/$1');
        $routes->post('update_product/(:num)', 'Admin\ProductController::update_product/$1');
        $routes->get('delete_product_video/(:num)/(:num)', 'Admin\ProductController::delete_product_video/$1/$2');
        $routes->post('change_product_status', 'Admin\ProductController::change_product_status');
        $routes->post('update_specials_status', 'Admin\ProductController::update_specials_status');
        $routes->post('update_featured_status', 'Admin\ProductController::update_featured_status');
        $routes->post('retrieve_product_data', 'Admin\ProductController::retrieve_product_data');
        $routes->post('product_avaliblity_check_with_price', 'Admin\ProductController::product_avaliblity_check_with_price');  
        $routes->post('product_avaliblity_check_with_price_for_admin_prd_add', 'Admin\ProductController::product_avaliblity_check_with_price_for_admin_prd_add');  
        $routes->get('product_reviews', 'Admin\ProductController::product_reviews');
        $routes->get('approve_review/(:num)', 'Admin\ProductController::approve_review/$1');
        $routes->get('disapprove_review/(:num)', 'Admin\ProductController::disapprove_review/$1');
        // product section Emd
        $routes->get('getAmazoneAccessToken', 'Admin\ProductController::getAmazoneAccessToken');
    });

    // Order
    $routes->group('order', function ($routes) {
        $routes->get('all_order', 'Admin\OrderController::all_order');
        $routes->get('track_order/(:any)', 'Admin\OrderController::track_order/$1');
        $routes->post('change_order_status', 'Admin\OrderController::change_order_status');
        
    });

    //coupon
    $routes->group('coupon', function ($routes) {
        $routes->get('all_coupon', 'Admin\SettingController::all_coupon');
        $routes->get('add_new_coupon', 'Admin\SettingController::add_new_coupon');
        $routes->post('add_coupon', 'Admin\SettingController::add_coupon');
        $routes->get('edit_coupon/(:num)', 'Admin\SettingController::edit_coupon/$1');
        $routes->post('update_coupon/(:num)', 'Admin\SettingController::update_coupon/$1');
    });

    //blog
    $routes->group('blog', function ($routes) {
        $routes->get('blog_category', 'Admin\BlogController::blog_category');
        $routes->post('add_new_category', 'Admin\BlogController::add_new_category');
        $routes->post('update_blog_category/(:num)', 'Admin\BlogController::update_blog_category/$1');
        $routes->get('delete_category/(:num)', 'Admin\BlogController::delete_category/$1');
        $routes->get('add_new_blog', 'Admin\BlogController::add_new_blog');
        $routes->post('new_blog_add', 'Admin\BlogController::new_blog_add');
        $routes->get('view_all_post', 'Admin\BlogController::view_all_blog');
        $routes->get('update_blog/(:num)', 'Admin\BlogController::update_blog/$1');
        $routes->add('update_blog_new/(:num)', 'Admin\BlogController::update_blog_new/$1');
        $routes->get('delete_blog/(:num)', 'Admin\BlogController::delete_blog/$1');
        $routes->get('change_blog_status/(:num)/(:num)', 'Admin\BlogController::change_blog_status/$1/$2');
    });

    //role permission 
    $routes->group('role_permission', function ($routes) {
        $routes->get('all_permission', 'Admin\SettingController::all_permission');
        $routes->get('add_new_permission', 'Admin\SettingController::add_new_permission');
        $routes->get('edit_permission/(:num)', 'Admin\SettingController::edit_permission/$1');
        $routes->post('permission_add', 'Admin\SettingController::permission_add');
        $routes->post('update_permission/(:num)', 'Admin\SettingController::update_permission/$1');
        $routes->get('delete_permission/(:num)', 'Admin\SettingController::delete_permission/$1');
    });

    //employee 
    $routes->group('employee', function ($routes) {
        $routes->get('all_employees', 'Admin\EmployeeController::all_employees');
        $routes->post('add_employee', 'Admin\EmployeeController::add_employee');
        $routes->get('edit_employee/(:num)', 'Admin\EmployeeController::edit_employee/$1');
        $routes->post('update_employee/(:num)', 'Admin\EmployeeController::update_employee/$1');
        $routes->get('delete_employee/(:num)', 'Admin\EmployeeController::delete_employee/$1');
        $routes->get('login_employee/(:num)', 'Admin\EmployeeController::login_employee/$1');
    });

    // contact
    $routes->group('contact', function ($routes) {
        $routes->get('all_contact_details', 'Admin\SettingController::all_contact_details');
    });

    // Magazine
    $routes->group('magazine', function ($routes) {
        // magazine
        $routes->get('all_magazine', 'Admin\ProductController::all_magazine');
        $routes->post('add_magazine', 'Admin\ProductController::add_magazine');
        $routes->get('edit_magazine/(:num)', 'Admin\ProductController::edit_magazine/$1');
        $routes->post('update_magazine/(:num)', 'Admin\ProductController::update_magazine/$1');
        $routes->get('delete_magazine/(:num)', 'Admin\ProductController::delete_magazine/$1');
        //magazine edition
        $routes->get('all_edition', 'Admin\ProductController::all_edition');
        $routes->post('add_edition', 'Admin\ProductController::add_edition');
        $routes->get('edit_edition/(:num)', 'Admin\ProductController::edit_edition/$1');
        $routes->post('update_edition/(:num)', 'Admin\ProductController::update_edition/$1');
        $routes->get('delete_edition/(:num)', 'Admin\ProductController::delete_edition/$1');
    });

    //Front Setting
    $routes->group('front_setting', function ($routes) {
        // section heading
        $routes->get('heading', 'Admin\FrontController::all_heading');
        $routes->post('update_heading', 'Admin\FrontController::update_heading');
        // slider
        $routes->get('all_slider', 'Admin\FrontController::all_slider');
        $routes->post('add_slider', 'Admin\FrontController::add_slider');
        $routes->get('edit_slider/(:num)', 'Admin\FrontController::edit_slider/$1');
        $routes->post('update_slider/(:num)', 'Admin\FrontController::update_slider/$1');
        $routes->get('delete_slider/(:num)', 'Admin\FrontController::delete_slider/$1');
        //banner
        $routes->get('all_banner', 'Admin\FrontController::all_banner');
        $routes->get('edit_banner/(:num)', 'Admin\FrontController::edit_banner/$1');
        $routes->post('update_banner/(:num)', 'Admin\FrontController::update_banner/$1');
        // testimonial
        $routes->get('all_testimonial', 'Admin\FrontController::all_testimonial');
        $routes->post('add_testimonial', 'Admin\FrontController::add_testimonial');
        $routes->get('edit_testimonial/(:num)', 'Admin\FrontController::edit_testimonial/$1');
        $routes->post('update_testimonial/(:num)', 'Admin\FrontController::update_testimonial/$1');
        $routes->get('delete_testimonial/(:num)', 'Admin\FrontController::delete_testimonial/$1');
        // Our Team
        $routes->get('our_team', 'Admin\FrontController::our_team');
        $routes->post('add_our_team', 'Admin\FrontController::add_our_team');
        $routes->get('edit_our_team/(:num)', 'Admin\FrontController::edit_our_team/$1');
        $routes->post('update_our_team/(:num)', 'Admin\FrontController::update_our_team/$1');
        $routes->get('delete_our_team/(:num)', 'Admin\FrontController::delete_our_team/$1');
        // pages
        $routes->get('all_page', 'Admin\FrontController::all_page');
        $routes->post('add_page', 'Admin\FrontController::add_page');
        $routes->get('edit_page/(:num)', 'Admin\FrontController::edit_page/$1');
        $routes->post('update_page/(:num)', 'Admin\FrontController::update_page/$1');
        $routes->get('delete_page/(:num)', 'Admin\FrontController::delete_page/$1');
        // Event
        $routes->get('all_event', 'Admin\FrontController::all_event');
        $routes->get('add_event', 'Admin\FrontController::add_event');
        $routes->post('add_new_event', 'Admin\FrontController::add_new_event');
        $routes->get('edit_event/(:num)', 'Admin\FrontController::edit_event/$1');
        $routes->post('update_event/(:num)', 'Admin\FrontController::update_event/$1');
        $routes->get('delete_event/(:num)', 'Admin\FrontController::delete_event/$1');
        // Media
        $routes->get('all_media', 'Admin\FrontController::all_media');
        $routes->post('add_media', 'Admin\FrontController::add_media');
        $routes->get('edit_media/(:num)', 'Admin\FrontController::edit_media/$1');
        $routes->post('update_media/(:num)', 'Admin\FrontController::update_media/$1');
        $routes->get('delete_media/(:num)', 'Admin\FrontController::delete_media/$1');
        //help for author
        $routes->get('help_for_author', 'Admin\FrontController::help_for_author');
        $routes->post('update_help_for_author', 'Admin\FrontController::update_help_for_author');
        //print your book
        $routes->get('print_your_book', 'Admin\FrontController::print_your_book');
        $routes->post('update_print_your_book', 'Admin\FrontController::update_print_your_book');
        //publish your book
        $routes->get('publish_your_book', 'Admin\FrontController::publish_your_book');
        $routes->post('update_publish_your_book', 'Admin\FrontController::update_publish_your_book');
        //register as author
        $routes->get('register_as_author', 'Admin\FrontController::register_as_author');
        $routes->post('update_register_as_author', 'Admin\FrontController::update_register_as_author');
        //print cost calculator
        $routes->get('print_cost_calculator', 'Admin\FrontController::print_cost_calculator');
        $routes->post('update_print_cost_calculator', 'Admin\FrontController::update_print_cost_calculator');
        
    });


    $routes->group('setting', function ($routes) {
        // application setting
        $routes->get('application_setting', 'Admin\SettingController::application_setting');
        $routes->post('update_setting', 'Admin\SettingController::update_setting');
        // Own delievery settng
        $routes->get('delivery_setting', 'Admin\SettingController::delivery_setting');
        $routes->post('active_delivery_system', 'Admin\SettingController::delivery_system');
        $routes->post('active_local_delivery_system', 'Admin\SettingController::active_local_delivery_system');
        $routes->post('active_national_delivery_system', 'Admin\SettingController::active_national_delivery_system');
        $routes->post('active_state_delivery_system', 'Admin\SettingController::active_state_delivery_system');
        $routes->post('active_dist_delivery_system', 'Admin\SettingController::active_dist_delivery_system');
        $routes->post('local_delivery_details', 'Admin\SettingController::local_delivery_details');
        $routes->post('dist_delivery_details', 'Admin\SettingController::dist_delivery_details');
        $routes->post('state_delivery_details', 'Admin\SettingController::state_delivery_details');
        $routes->post('national_delivery_details', 'Admin\SettingController::national_delivery_details');
        //shiprocket delivery
        $routes->post('update_shiprocket_details', 'Admin\SettingController::update_shiprocket_details');
    });
});

// Custom route for blog & blog category
$routes->get('(:any)', 'HomeController::any/$1');