<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use App\Models\UserModel;
use WebPConvert\WebPConvert;


class AdminController extends BaseController
{
    public function index()
    {
        $setting    = new SettingModel();
        $user       = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $all_dat = array();
        $month = date("t", strtotime(date('Y-m-d')));
        $data['alldatethismonth'] = range(1, $month);
        foreach ($data['alldatethismonth'] as $date) {
            $at =  date("Y-m-") . $date;
            $all_dat[] = date('d-m', strtotime($at));
        }
        $data['dateList'] = "'" . implode("', '", $all_dat) . "'";
        echo view('admin/include/header', $data);
        echo view('admin/dashboard');
        echo view('admin/include/footer');
    }

    // profile
    function my_profile()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['user'] = get_user_by_id(user()->user_id);
        echo view('admin/include/header', $data);
        echo view('admin/profile/update_profile');
        echo view('admin/include/footer');
    }

    //update profile
    function update_my_profile()
    {
        $user = new UserModel();

        $userData = get_user_by_id(user()->user_id);
        if ($this->request->getFile('user_image')->isValid() && !$this->request->getFile('user_image')->hasMoved()) {
            $image_1 = $this->request->getFile('user_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['user_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($userData->user_image)) {
                    unlink($userData->user_image);
                }
            }
        }
        $data['user_name'] = $this->request->getVar('user_name');
        $data['user_mobile'] = $this->request->getVar('user_mobile');
        $data['user_email'] = $this->request->getVar('user_email');
        $data['user_address'] = $this->request->getVar('user_address');

        if ($user->update_user($data, user()->user_id)) {
            session()->set('success', "Profile Details Successfully Saved");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Profile Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    //password
    public function update_password()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['user'] = get_user_by_id(user()->user_id);
        echo view('admin/include/header', $data);
        echo view('admin/profile/update_password');
        echo view('admin/include/footer');
    }

    //update password
    function update_password_data()
    {
        $user = new UserModel();
        $data['user_password'] = hash("sha256", $this->request->getVar('new_password'));
        if ($user->update_user($data, user()->user_id)) {
            session()->set('success', "Password Successfully Saved");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Password Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    // change account status
    function change_account_status($user_id, $status)
    {
        $user = new UserModel();
        $data['user_status'] = $status;
        if ($user->update_user($data, $user_id)) {
            session()->set('success', "Status Successfully Change");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Status Change Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }


    // Logout
    public function logout()
    {
        session()->destroy();
        return redirect()->to('admin');
    }
}
