<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use WebPConvert\WebPConvert;

class FrontController extends BaseController
{
    /**
     * Heading
     */
    function all_heading()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']        = $setting->get_all_section_heading();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_heading');
        echo view('admin/include/footer');
    }

    function update_heading()
    {
        $setting = new SettingModel();

        if ($setting->update_heading($this->request->getPost())) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Slider
     */

    function all_slider()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_slider']  = $setting->get_all_slider();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_slider');
        echo view('admin/include/footer');
    }

    function add_slider()
    {
        $setting = new SettingModel();

        $data['slider_heading'] = $this->request->getVar('slider_heading');
        $data['slider_sub_heading'] = $this->request->getVar('slider_sub_heading');
        $data['slider_description'] = $this->request->getVar('slider_description');

        if ($this->request->getFile('slider_image')->isValid() && !$this->request->getFile('slider_image')->hasMoved()) {
            $image_1 = $this->request->getFile('slider_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['slider_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($setting->add_slider($data)) {
            session()->set('success', "Slider Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Slider Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_slider($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_slider_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_slider');
        echo view('admin/include/footer');
    }

    function update_slider($id)
    {
        $setting = new SettingModel();

        $data['slider_heading'] = $this->request->getVar('slider_heading');
        $data['slider_sub_heading'] = $this->request->getVar('slider_sub_heading');
        $data['slider_description'] = $this->request->getVar('slider_description');

        if ($this->request->getFile('slider_image')->isValid() && !$this->request->getFile('slider_image')->hasMoved()) {
            $image_1 = $this->request->getFile('slider_image');
            $imageData = $setting->get_slider_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['slider_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($imageData->slider_image)) {
                    unlink($imageData->slider_image);
                }
            }
        }

        if ($setting->update_slider($data, $id)) {
            session()->set('success', "Slider Successfully Updated");
            return redirect()->route('admin/front_setting/all_slider');
        } else {
            session()->set('error', "Slider Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_slider($id)
    {
        $setting = new SettingModel();
        $imageData = $setting->get_slider_by_id($id);

        if (file_exists($imageData->slider_image)) {
            unlink($imageData->slider_image);
        }

        if ($setting->delete_slider($id)) {
            session()->set('success', "Slider Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Slider Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Banner Section Start
     */
    function all_banner()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_banner']  = $setting->get_all_front_banner();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_banner');
        echo view('admin/include/footer');
    }

    function edit_banner($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_front_banner_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_banner');
        echo view('admin/include/footer');
    }

    function update_banner($id)
    {
        $setting = new SettingModel();

        $data['banner_title'] = $this->request->getVar('banner_title');

        if ($this->request->getFile('banner_image')->isValid() && !$this->request->getFile('banner_image')->hasMoved()) {
            $image_1 = $this->request->getFile('banner_image');
            $imageData = $setting->get_front_banner_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['banner_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($imageData->banner_image)) {
                    unlink($imageData->banner_image);
                }
            }
        }

        if ($setting->update_banner($data, $id)) {
            session()->set('success', "Banner Successfully Updated");
            return redirect()->route('admin/front_setting/all_banner');
        } else {
            session()->set('error', "Banner Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Banner Section End
     */

    /**
     * testimonial section Start
     */
    function all_testimonial()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_testimonial']  = $setting->get_all_testimonial();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_testimonial');
        echo view('admin/include/footer');
    }

    function add_testimonial()
    {
        $setting = new SettingModel();

        $data['testimonial_name'] = $this->request->getVar('testimonial_name');
        $data['testimonial_position'] = $this->request->getVar('testimonial_position');
        $data['testimonial_content'] = $this->request->getVar('testimonial_content');
        $data['testimonial_rating'] = $this->request->getVar('testimonial_rating');

        if ($this->request->getFile('testimonial_photo')->isValid() && !$this->request->getFile('testimonial_photo')->hasMoved()) {
            $image_1 = $this->request->getFile('testimonial_photo');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['testimonial_photo'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($setting->add_testimonial($data)) {
            session()->set('success', "Testimonial Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Testimonial Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_testimonial($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_testimonial_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_testimonial');
        echo view('admin/include/footer');
    }

    function update_testimonial($id)
    {
        $setting = new SettingModel();

        $data['testimonial_name'] = $this->request->getVar('testimonial_name');
        $data['testimonial_position'] = $this->request->getVar('testimonial_position');
        $data['testimonial_content'] = $this->request->getVar('testimonial_content');
        $data['testimonial_rating'] = $this->request->getVar('testimonial_rating');

        if ($this->request->getFile('testimonial_photo')->isValid() && !$this->request->getFile('testimonial_photo')->hasMoved()) {
            $image_1 = $this->request->getFile('testimonial_photo');
            $imageData = $setting->get_testimonial_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['testimonial_photo'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($imageData->testimonial_photo)) {
                    unlink($imageData->testimonial_photo);
                }
            }
        }

        if ($setting->update_testimonial($data, $id)) {
            session()->set('success', "Testimonial Successfully Updated");
            return redirect()->route('admin/front_setting/all_testimonial');
        } else {
            session()->set('error', "Testimonial Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_testimonial($id)
    {
        $setting = new SettingModel();
        $imageData = $setting->get_testimonial_by_id($id);

        if (file_exists($imageData->testimonial_photo)) {
            unlink($imageData->testimonial_photo);
        }

        if ($setting->delete_testimonial($id)) {
            session()->set('success', "Testimonial Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Testimonial Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * testimonial section End
     */

    /**
     * Our team section Start
     */
    function our_team()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data']  = $setting->get_all_our_team();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_our_team');
        echo view('admin/include/footer');
    }

    function add_our_team()
    {
        $setting = new SettingModel();

        $data['aot_name'] = $this->request->getVar('aot_name');
        $data['aot_description'] = $this->request->getVar('aot_description');
        $data['aot_position'] = $this->request->getVar('aot_position');

        if ($this->request->getFile('aot_image')->isValid() && !$this->request->getFile('aot_image')->hasMoved()) {
            $image_1 = $this->request->getFile('aot_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['aot_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($setting->add_our_team($data)) {
            session()->set('success', "Our Team Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Our Team Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_our_team($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_our_team_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_our_team');
        echo view('admin/include/footer');
    }

    function update_our_team($id)
    {
        $setting = new SettingModel();

        $data['aot_name'] = $this->request->getVar('aot_name');
        $data['aot_description'] = $this->request->getVar('aot_description');
        $data['aot_position'] = $this->request->getVar('aot_position');

        if ($this->request->getFile('aot_image')->isValid() && !$this->request->getFile('aot_image')->hasMoved()) {
            $image_1 = $this->request->getFile('aot_image');
            $imageData = $setting->get_our_team_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['aot_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($imageData->aot_image)) {
                    unlink($imageData->aot_image);
                }
            }
        }

        if ($setting->update_our_team($data, $id)) {
            session()->set('success', "Our Team Successfully Updated");
            return redirect()->route('admin/front_setting/our_team');
        } else {
            session()->set('error', "Our Team Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_our_team($id)
    {
        $setting = new SettingModel();
        $imageData = $setting->get_our_team_by_id($id);

        if (file_exists($imageData->aot_image)) {
            unlink($imageData->aot_image);
        }

        if ($setting->delete_our_team($id)) {
            session()->set('success', "Our Team Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Our Team Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Our team section End
     */

    /**
     * Page section Start
     */
    function all_page()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_page']  = $setting->get_all_page();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_page');
        echo view('admin/include/footer');
    }

    function add_page()
    {
        $setting = new SettingModel();

        $data['name'] = $this->request->getVar('name');
        $data['slug'] = slug($this->request->getVar('name'));
        $data['meta_descrition'] = $this->request->getVar('meta_descrition');
        $data['meta_keyword'] = $this->request->getVar('meta_keyword');
        $data['content'] = $this->request->getVar('content');
        $data['date'] = date('Y-m-d');

        if ($setting->add_page($data)) {
            session()->set('success', "Page Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Page Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_page($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_page_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_page');
        echo view('admin/include/footer');
    }

    function update_page($id)
    {
        $setting = new SettingModel();

        $data['name'] = $this->request->getVar('name');
        if ($id != 5) {
            $data['slug'] = slug($this->request->getVar('name'));
        }

        $data['meta_descrition'] = $this->request->getVar('meta_descrition');
        $data['meta_keyword'] = $this->request->getVar('meta_keyword');
        $data['content'] = $this->request->getVar('content');

        if ($setting->update_page($data, $id)) {
            session()->set('success', "Page Successfully Updated");
            return redirect()->route('admin/front_setting/all_page');
        } else {
            session()->set('error', "Page Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_page($id)
    {
        $setting = new SettingModel();

        if ($setting->delete_page($id)) {
            session()->set('success', "Page Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Page Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Page section End
     */

    /**
     * Event section Start
     */
    function all_event()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_event']  = $setting->get_all_event();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_event');
        echo view('admin/include/footer');
    }

    function add_event()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/add_event');
        echo view('admin/include/footer');
    }

    function add_new_event()
    {
        $setting = new SettingModel();

        $data['event_title'] = $this->request->getVar('event_title');
        $data['event_slug'] = slug($this->request->getVar('event_title'));
        $data['event_description'] = $this->request->getVar('event_description');
        $data['event_short_description'] = $this->request->getVar('event_short_description');
        $data['event_start_date'] = $this->request->getVar('event_start_date');
        $data['event_end_date'] = $this->request->getVar('event_end_date');
        $data['event_adress'] = $this->request->getVar('event_adress');

        if ($this->request->getFile('event_image')->isValid() && !$this->request->getFile('event_image')->hasMoved()) {
            $image_1 = $this->request->getFile('event_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['event_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($setting->add_event($data)) {
            session()->set('success', "Event Successfully Added");
            return redirect()->route('admin/front_setting/all_event');
        } else {
            session()->set('error', "Event Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_event($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['event']  = $setting->get_event_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_event');
        echo view('admin/include/footer');
    }

    function update_event($id)
    {
        $setting = new SettingModel();

        $data['event_title'] = $this->request->getVar('event_title');
        $data['event_slug'] = slug($this->request->getVar('event_title'));
        $data['event_description'] = $this->request->getVar('event_description');
        $data['event_short_description'] = $this->request->getVar('event_short_description');
        $data['event_start_date'] = $this->request->getVar('event_start_date');
        $data['event_end_date'] = $this->request->getVar('event_end_date');
        $data['event_adress'] = $this->request->getVar('event_adress');

        if ($this->request->getFile('event_image')->isValid() && !$this->request->getFile('event_image')->hasMoved()) {
            $image_1 = $this->request->getFile('event_image');
            $imageData = $setting->get_event_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['event_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($imageData->event_image)) {
                    unlink($imageData->event_image);
                }
            }
        }

        if ($setting->update_event($data, $id)) {
            session()->set('success', "Event Successfully Updated");
            return redirect()->route('admin/front_setting/all_event');
        } else {
            session()->set('error', "Event Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_event($id)
    {
        $setting = new SettingModel();
        $imageData = $setting->get_event_by_id($id);

        if (file_exists($imageData->event_image)) {
            unlink($imageData->event_image);
        }


        if ($setting->delete_event($id)) {
            session()->set('success', "Event Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Event Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Event section End
     */

    /**
     * Media section Start
     */
    function all_media()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data']  = $setting->get_all_media();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/all_media');
        echo view('admin/include/footer');
    }

    function add_media()
    {
        $setting = new SettingModel();

        $data['media_title'] = $this->request->getVar('media_title');
        $data['media_mode'] = $this->request->getVar('media_mode');
        if ($this->request->getVar('media_mode') == 2) {
            $data['media_link'] = $this->request->getVar('media_link');
        } else {
            if ($this->request->getFile('media_image')->isValid() && !$this->request->getFile('media_image')->hasMoved()) {
                $image_1 = $this->request->getFile('media_image');
                $newName_1 = $image_1->getRandomName();
                $image_1->move('uploads', $newName_1);
                $extension = $image_1->getClientExtension();
                if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                    $source_1 = 'uploads/' . $newName_1;
                    $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                    WebPConvert::convert($source_1, $destination_1, [
                        'fail' => 'original',
                        'quality' => 50
                    ]);
                    $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                    $data['media_link'] = $webpPath_1;
                    unlink($source_1);
                }
            }
        }

        if ($setting->add_media($data)) {
            session()->set('success', "Media Successfully Added");
            return redirect()->route('admin/front_setting/all_media');
        } else {
            session()->set('error', "Media Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_media($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_media_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/edit_media');
        echo view('admin/include/footer');
    }

    function update_media($id)
    {
        $setting = new SettingModel();

        $data['media_title'] = $this->request->getVar('media_title');
        $data['media_mode'] = $this->request->getVar('media_mode');
        if ($this->request->getVar('media_mode') == 2) {
            $data['media_link'] = $this->request->getVar('media_link');
        } else {

            if ($this->request->getFile('media_image')->isValid() && !$this->request->getFile('media_image')->hasMoved()) {
                $image_1 = $this->request->getFile('media_image');
                $imageData = $setting->get_media_by_id($id);
                $newName_1 = $image_1->getRandomName();
                $image_1->move('uploads', $newName_1);
                $extension = $image_1->getClientExtension();
                if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                    $source_1 = 'uploads/' . $newName_1;
                    $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                    WebPConvert::convert($source_1, $destination_1, [
                        'fail' => 'original',
                        'quality' => 50
                    ]);
                    $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                    $data['media_link'] = $webpPath_1;
                    unlink($source_1);
                    if (file_exists($imageData->media_link)) {
                        unlink($imageData->media_link);
                    }
                }
            }
        }

        if ($setting->update_media($data, $id)) {
            session()->set('success', "Media Successfully Updated");
            return redirect()->route('admin/front_setting/all_media');
        } else {
            session()->set('error', "Media Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_media($id)
    {
        $setting = new SettingModel();
        $imageData = $setting->get_media_by_id($id);

        if (file_exists($imageData->media_link)) {
            unlink($imageData->media_link);
        }

        if ($setting->delete_media($id)) {
            session()->set('success', "Media Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Media Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Media section End
     */

    /**
     * Help For Auth Section Start
     */
    function help_for_author()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_help_for_author_data();
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/help_for_author');
        echo view('admin/include/footer');
    }

    function update_help_for_author()
    {
        $setting = new SettingModel();

        $data['help_content'] = $this->request->getVar('help_content');

        if ($setting->update_help_for_author($data)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Help For Auth Section End
     */

    /**
     * print your Book Section Start
     */
    function print_your_book()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_print_your_book_data_by_id(1);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/print_your_book');
        echo view('admin/include/footer');
    }

    function update_print_your_book()
    {
        $setting = new SettingModel();

        $data['pp_content'] = $this->request->getVar('pp_content');

        if ($setting->update_print_your_book_info($data, 1)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * print your Book Section End
     */

    /**
     * Publish your  BookSection Start
     */
    function publish_your_book()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_print_your_book_data_by_id(2);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/publish_your_book');
        echo view('admin/include/footer');
    }

    function update_publish_your_book()
    {
        $setting = new SettingModel();

        $data['pp_content'] = $this->request->getVar('pp_content');

        if ($setting->update_print_your_book_info($data, 2)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Publish your Book Section End
     */

    /**
     * register as author Section Start
     */
    function register_as_author()
    {
        error_reporting(0);
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_print_your_book_data_by_id(3);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/register_as_author');
        echo view('admin/include/footer');
    }

    function update_register_as_author()
    {
        $setting = new SettingModel();

        $data['pp_content'] = json_encode($this->request->getVar('pp_content'));

        if ($setting->update_print_your_book_info($data, 3)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * register as author Section End
     */

     /**
     * print cost calculator Section Start
     */
    function print_cost_calculator()
    {
        error_reporting(0);
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data']  = $setting->get_print_your_book_data_by_id(4);
        echo view('admin/include/header', $data);
        echo view('admin/front_setting/print_cost_calculator');
        echo view('admin/include/footer');
    }

    function update_print_cost_calculator()
    {
        $setting = new SettingModel();

        $data['pp_content'] = json_encode($this->request->getVar('pp_content'));

        if ($setting->update_print_your_book_info($data, 4)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * print cost calculator Section End
     */
}
