<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\OrderModel;
use App\Models\SettingModel;
use App\Models\UserModel;
use CodeIgniter\HTTP\ResponseInterface;

class OrderController extends BaseController
{

    public function all_order()
    {
        $start_date = $this->request->getGet('start_date');
        $end_date = $this->request->getGet('end_date');

        // Validate and set default dates
        if (!$start_date || !strtotime($start_date)) {
            $start_date = date('Y-m-d', strtotime('-30 days')); // Default to 30 days ago
        }

        if (!$end_date || !strtotime($end_date)) {
            $end_date = date('Y-m-d'); // Default to today
        }

        // Ensure dates are properly formatted
        $start_date = date('Y-m-d', strtotime($start_date));
        $end_date = date('Y-m-d', strtotime($end_date));

        // Load models
        $setting = new SettingModel();
        $order = new OrderModel();

        // Fetch data
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_order'] = $order->get_all_order($start_date, $end_date);

        // Render views
        echo view('admin/include/header', $data);
        echo view('admin/order/view_all_order');
        echo view('admin/include/footer');
    }

    /// track Order
    function track_order($id)
    {
        error_reporting(0);
        
        $setting = new SettingModel();
        $order = new OrderModel();
        $data['app_setting']    = $setting->get_application_setting();
        $data['order_details']  = $order->get_order_status_by_invoice_id($id);
        $data['last_status']    = $order->check_last_order_status($id);
        echo view('admin/include/header', $data);
        echo view('admin/order/track_order');
        echo view('admin/include/footer');
    }

    //change order status
    function change_order_status()
    {
        $order = new OrderModel();
        $user = new UserModel();
        $order_id = $this->request->getVar('order_id');
        $user_id = $this->request->getVar('user_id');
        $data['order_status'] = $this->request->getVar('status');
        
        if($order->update_order_status($data, $order_id))
        {
            $ord_status['order_status_user_id']     = $user_id;
            $ord_status['order_status_invoice_id']  = $order_id;
            $ord_status['order_status']             = $this->request->getVar('status');
            $ord_status['order_status_comment']     = $this->request->getVar('message');
            $ord_status['order_status_date']        = date('Y-m-d h:i:s');
            $order->add_order_status($ord_status);
            
            session()->set('success', "Order Status Successfully Changed");
            return redirect()->to($this->request->getUserAgent()->getReferrer()); 
        }
        else
        {
            
            session()->set('error', "Order Status Changed Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer()); 
            
        }
    }
}
