<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ProductModel;
use App\Models\SettingModel;
use App\Models\UserModel;
use WebPConvert\WebPConvert;
use GuzzleHttp\Client;

class ProductController extends BaseController
{
    /**
     * Category Section Start
     */
    public function all_category()
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_category'] = $product->get_all_category_and_sub_categopry();
        echo view('admin/include/header', $data);
        echo view('admin/product/view_all_category');
        echo view('admin/include/footer');
    }

    function add_new_category()
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_category'] = $product->get_all_main_category();
        echo view('admin/include/header', $data);
        echo view('admin/product/add_new_category');
        echo view('admin/include/footer');
    }

    function add_category()
    {
        $product = new ProductModel();

        if ($product->check_name_avaliblity($this->request->getVar('category_name'))) {
            session()->set('success', "Category Name Already Exits");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        $data['category_name'] = $this->request->getVar('category_name');
        $data['category_code'] = rand();
        $data['category_slug'] = slug($this->request->getVar('category_name'));
        $data['parent_category'] = $this->request->getVar('parent_category');
        $data['category_front_show'] = $this->request->getVar('category_front_show');
        $data['category_menu_position'] = $this->request->getVar('category_menu_position');
        if (!empty($this->request->getVar('parent_category'))) {
            $data['category_type'] = 2;
        } else {
            $data['category_type'] = 1;
        }
        $data['category_status'] = 1;
        $data['category_date'] = date('Y-m-d h:i:s');
        if ($product->new_category_add($data)) {
            session()->set('success', "Category Successfully Added");
            return redirect()->route('admin/product/all_category');
        } else {
            session()->set('error', "Category Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_category($id)
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_category'] = $product->get_all_category();
        $data['category'] = $product->get_category_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/product/edit_category');
        echo view('admin/include/footer');
    }

    function update_category($id)
    {
        $product = new ProductModel();
        $data['category_name'] = $this->request->getVar('category_name');
        $data['category_slug'] = slug($this->request->getVar('category_name'));
        $data['parent_category'] = $this->request->getVar('parent_category');
        $data['category_front_show'] = $this->request->getVar('category_front_show');
        $data['category_menu_position'] = $this->request->getVar('category_menu_position');
        if (!empty($this->request->getVar('parent_category'))) {
            $data['category_type'] = 2;
        } else {
            $data['category_type'] = 1;
        }

        if ($product->update_category($data, $id)) {
            session()->set('success', "Category Successfully Updated");
            return redirect()->route('admin/product/all_category');
        } else {
            session()->set('error', "Category Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_category($id)
    {
        $product = new ProductModel();

        $is_avali_p = $product->check_parent_cat_exits($id);
        if ($is_avali_p) {
            session()->set('error', "Category Deleted Failed. Please Delete Sub Category First");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        $is_avali = $product->check_cat_exits_in_prd($id);
        if ($is_avali) {
            session()->set('error', "Category Deleted Failed. Please Delete Product First");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        if ($product->delete_category($id)) {
            session()->set('success', "Category Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Category Deleted Failed.");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function deactive_category($id)
    {
        $product = new ProductModel();
        $data['category_status'] = 0;
        if ($product->change_category_status($data, $id)) {
            session()->set('success', "Category Now Deactivated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Category Deactivation Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function active_category($id)
    {
        $product = new ProductModel();
        $data['category_status'] = 1;
        if ($product->change_category_status($data, $id)) {
            session()->set('success', "Category Now Activated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Category Activation Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function fetch_all_sub_category()
    {
        $product = new ProductModel();
        $query =  $product->fetch_all_sub_category($this->request->getVar('category_id'));
        $output = '<option value="">Select</option>';

        foreach ($query as $row) {
            $output .= '<option value="' . $row->category_id . '">' . $row->category_name . '</option>';
        }
        echo $output;
    }
    /**
     * Category Section End
     */

    /**
     * Author Section Start
     */
    public function all_author()
    {
        $setting    = new SettingModel();
        $user       = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_author'] = $user->get_author_all();
        echo view('admin/include/header', $data);
        echo view('admin/product/all_author');
        echo view('admin/include/footer');
    }

    function add_author()
    {
        $user = new UserModel();

        $data['user_name']      = $this->request->getVar('user_name');
        $data['user_mobile']    = $this->request->getVar('user_mobile');
        $data['user_email']     = $this->request->getVar('user_email');
        // $data['user_password']  = hash("sha256", $this->request->getVar('user_mobile'));
        $data['user_role']      = 'Author';
        $data['user_status']    = 1;
        $data['user_created_at']     = date('Y-m-d');

        if ($this->request->getFile('user_image')->isValid() && !$this->request->getFile('user_image')->hasMoved()) {
            $image_1 = $this->request->getFile('user_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['user_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($user->add_user($data)) {
            session()->set('success', "Author Successfully Added");
            return redirect()->route('admin/product/all_author');
        } else {
            session()->set('error', "Author Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_author($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = get_user_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/product/edit_author');
        echo view('admin/include/footer');
    }

    function update_author($id)
    {
        $user = new UserModel();

        $data['user_name']      = $this->request->getVar('user_name');
        $data['user_mobile']    = $this->request->getVar('user_mobile');
        $data['user_email']     = $this->request->getVar('user_email');

        if ($this->request->getFile('user_image')->isValid() && !$this->request->getFile('user_image')->hasMoved()) {
            $image_1 = $this->request->getFile('user_image');
            $authorData = get_user_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['user_image'] = $webpPath_1;
                unlink($source_1);

                if (file_exists($authorData->user_image)) {
                    unlink($authorData->user_image);
                }
            }
        }

        if ($user->update_user($data, $id)) {
            session()->set('success', "Author Successfully Updated");
            return redirect()->route('admin/product/all_author');
        } else {
            session()->set('error', "Author Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_author($id)
    {
        $user = new UserModel();
        $product = new ProductModel();

        $is_avali_p = $product->check_author_exists_in_product($id);
        if ($is_avali_p) {
            session()->set('error', "Author Deleted Failed. Please Change Author in Product");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        if ($user->delete_user($id)) {
            session()->set('success', "Author Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Author Deleted Failed.");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Author Section End
     */

    /**
     * Product Section Start
     */

    function view_all_product()
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_product'] = $product->get_all_product_for_view_page();
        echo view('admin/include/header', $data);
        echo view('admin/product/view_all_product');
        echo view('admin/include/footer');
    }
    public function add_new_product()
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $user       = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_category'] = $product->get_all_main_category();
        $data['all_author'] = $user->get_all_author();
        echo view('admin/include/header', $data);
        echo view('admin/product/add_new_product');
        echo view('admin/include/footer');
    }

    function new_product_add()
    {
        $product = new ProductModel();
        $data['prd_code']           =  uniqid();
        $data['prd_name']           =  name($this->request->getVar('prd_name'));
        $data['prd_code_for_n']     =  $this->request->getVar('prd_code_for_n');
        $data['prd_hsn']            =  $this->request->getVar('prd_hsn');
        $data['prd_tax  ']          =  $this->request->getVar('prd_tax');
        $data['prd_slug']           =  slug($this->request->getVar('prd_name'));
        $data['prd_category']       =  $this->request->getVar('prd_category');
        $data['prd_sub_category']   =  $this->request->getVar('prd_sub_category');
        $data['prd_details']        =  $this->request->getVar('prd_details');
        $data['prd_unit']           =  $this->request->getVar('prd_unit');
        $data['prd_description']    =  $this->request->getVar('prd_description');
        $data['prd_specifications'] =  $this->request->getVar('prd_specifications');
        $data['prd_refund_status']  =  $this->request->getVar('prd_refund_status');
        $data['prd_refund_days']    =  $this->request->getVar('prd_refund_days');
        $data['prd_return_status']  =  $this->request->getVar('prd_return_status');
        $data['prd_return_days']    =  $this->request->getVar('prd_return_days');
        $data['prd_length']          =  $this->request->getVar('prd_length');
        $data['prd_breadth']         =  $this->request->getVar('prd_breadth');
        $data['prd_height']          =  $this->request->getVar('prd_height');
        $data['prd_weight']          =  $this->request->getVar('prd_weight');
        $data['prd_seo_keyword']     =  $this->request->getVar('prd_seo_keyword');
        $data['prd_seo_description'] =  $this->request->getVar('prd_seo_description');
        $data['prd_low_stock']       =  $this->request->getVar('prd_low_stock');
        $data['prd_v_offer']         =  $this->request->getVar('prd_v_offer');
        $data['prd_v_buy_price']         =  $this->request->getVar('prd_v_buy_price');
        $data['prd_v_sell_price']         =  $this->request->getVar('prd_v_sell_price');
        $data['prd_v_offer_price']         =  $this->request->getVar('prd_v_offer_price');
        $data['prd_video']          = json_encode($this->request->getVar('prd_video'));
        $data['prd_ttl_page']         =  $this->request->getVar('prd_ttl_page');
        $data['prd_publish_year']     =  date('Y', strtotime($this->request->getVar('prd_publish_year')));
        $data['prd_format']           =  $this->request->getVar('prd_format');
        $data['prd_language']         =  $this->request->getVar('prd_language');
        $data['prd_flipkart_link']           =  $this->request->getVar('prd_flipkart_link');
        $data['prd_amazone_link']         =  $this->request->getVar('prd_amazone_link');
        $data['prd_author_id']         =  $this->request->getVar('prd_author_id');
        $data['prd_date']           =  date('Y-m-d h:i:s');
        $data['prd_status']         = 1;



        if ($this->request->getFile('prd_default_image')->isValid() && !$this->request->getFile('prd_default_image')->hasMoved()) {
            $image_1 = $this->request->getFile('prd_default_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['prd_default_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        $last_id = $product->add_new_product($data);
        if ($last_id) {

            foreach ($this->request->getFileMultiple('prd_e_image') as $key => $image) {
                if ($image->isValid() && !$image->hasMoved()) {
                    // Generate a random name for the file
                    $newName = $image->getRandomName();
                    // Move the uploaded file to the 'uploads' directory
                    $image->move('uploads', $newName);
                    // Get the file extension
                    $extension = $image->getClientExtension();

                    // Check if the file extension is allowed
                    if (in_array($extension, ['png', 'jpg', 'jpeg'])) {
                        $source = 'uploads/' . $newName;
                        $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';

                        // Convert the image to WebP format
                        WebPConvert::convert($source, $destination, [
                            'fail' => 'original',
                            'quality' => 50
                        ]);

                        // Set the WebP path
                        $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';

                        // Store the WebP image path in the database
                        $dat['prd_e_image'] = $webpPath;
                        $dat['prd_id'] = $last_id;
                        $product->add_extra_product_img($dat);

                        // Remove the original uploaded file
                        unlink($source);
                    }
                }
            }

            session()->set('success', "Product Successfully Added");
            return redirect()->route('admin/product/all_product');
        } else {
            session()->set('error', "Product Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_product($id)
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $user = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_category'] = $product->get_all_main_category();
        $data['product'] = $product->get_product_by_id_for_edit_page($id);
        $data['sub_category'] = $product->get_sub_category_by_category_id($data['product']->prd_category);
        $data['all_author'] = $user->get_all_author();
        echo view('admin/include/header', $data);
        echo view('admin/product/edit_product');
        echo view('admin/include/footer');
    }

    function update_product($id)
    {
        $product = new ProductModel();
        $data['prd_name']           =  name($this->request->getVar('prd_name'));
        $data['prd_code_for_n']     =  $this->request->getVar('prd_code_for_n');
        $data['prd_hsn']            =  $this->request->getVar('prd_hsn');
        $data['prd_tax  ']          =  $this->request->getVar('prd_tax');
        $data['prd_slug']           =  slug($this->request->getVar('prd_name'));
        $data['prd_category']       =  $this->request->getVar('prd_category');
        $data['prd_sub_category']   =  $this->request->getVar('prd_sub_category');
        $data['prd_details']        =  $this->request->getVar('prd_details');
        $data['prd_unit']           =  $this->request->getVar('prd_unit');
        $data['prd_description']    =  $this->request->getVar('prd_description');
        $data['prd_specifications'] =  $this->request->getVar('prd_specifications');
        $data['prd_refund_status']  =  $this->request->getVar('prd_refund_status');
        $data['prd_refund_days']    =  $this->request->getVar('prd_refund_days');
        $data['prd_return_status']  =  $this->request->getVar('prd_return_status');
        $data['prd_return_days']    =  $this->request->getVar('prd_return_days');
        $data['prd_length']          =  $this->request->getVar('prd_length');
        $data['prd_breadth']         =  $this->request->getVar('prd_breadth');
        $data['prd_height']          =  $this->request->getVar('prd_height');
        $data['prd_weight']          =  $this->request->getVar('prd_weight');
        $data['prd_seo_keyword']     =  $this->request->getVar('prd_seo_keyword');
        $data['prd_seo_description'] =  $this->request->getVar('prd_seo_description');
        $data['prd_low_stock']       =  $this->request->getVar('prd_low_stock');
        $data['prd_v_offer']         =  $this->request->getVar('prd_v_offer');
        $data['prd_v_buy_price']         =  $this->request->getVar('prd_v_buy_price');
        $data['prd_v_sell_price']         =  $this->request->getVar('prd_v_sell_price');
        $data['prd_v_offer_price']         =  $this->request->getVar('prd_v_offer_price');
        $data['prd_video']          = json_encode($this->request->getVar('prd_video'));
        $data['prd_ttl_page']         =  $this->request->getVar('prd_ttl_page');
        $data['prd_publish_year']     =  date('Y', strtotime($this->request->getVar('prd_publish_year')));
        $data['prd_format']           =  $this->request->getVar('prd_format');
        $data['prd_language']         =  $this->request->getVar('prd_language');
        $data['prd_flipkart_link']           =  $this->request->getVar('prd_flipkart_link');
        $data['prd_amazone_link']         =  $this->request->getVar('prd_amazone_link');
        $data['prd_author_id']         =  $this->request->getVar('prd_author_id');
        $data['prd_date']           =  date('Y-m-d h:i:s');
        $data['prd_status']         = 1;

        $productData = $product->get_product_by_id_for_edit_page($id);

        if ($this->request->getFile('prd_default_image')->isValid() && !$this->request->getFile('prd_default_image')->hasMoved()) {
            $image_1 = $this->request->getFile('prd_default_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['prd_default_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($productData->prd_default_image)) {
                    unlink($productData->prd_default_image);
                }
            }
        } else {
            $data['prd_default_image'] = $productData->prd_default_image;
        }

        $this->sendToAmazon($data);

        if ($product->update_product($data, $id)) {

            foreach ($this->request->getFileMultiple('prd_e_image') as $key => $image) {
                if ($image->isValid() && !$image->hasMoved()) {
                    // Generate a random name for the file
                    $newName = $image->getRandomName();
                    // Move the uploaded file to the 'uploads' directory
                    $image->move('uploads', $newName);
                    // Get the file extension
                    $extension = $image->getClientExtension();

                    // Check if the file extension is allowed
                    if (in_array($extension, ['png', 'jpg', 'jpeg'])) {
                        $source = 'uploads/' . $newName;
                        $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';

                        // Convert the image to WebP format
                        WebPConvert::convert($source, $destination, [
                            'fail' => 'original',
                            'quality' => 50
                        ]);

                        // Set the WebP path
                        $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';

                        // Store the WebP image path in the database
                        $dat['prd_e_image'] = $webpPath;
                        $dat['prd_id'] = $id;
                        $product->add_extra_product_img($dat);

                        // Remove the original uploaded file
                        unlink($source);
                    }
                }
            }

            session()->set('success', "Product Successfully Updated");
            return redirect()->route('admin/product/all_product');
        } else {
            session()->set('error', "Product Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function getAmazoneAccessToken()
    {
        $clientId = "amzn1.application-oa2-client.d77bf634b5a7444a81ac1e06fb9eea83";
        $clientSecret = "amzn1.oa2-cs.v1.20a17fa4a1934de4956741309bf8e1320026876cb2165bd13a26fae4719255e2";
        $refreshToken = "Atzr|IwEBIG0W2oaCBAOupKHzW8tm7Jj50hiVb344m40eJHUxahAsjWoiAZNiNnhrvG5ajwJ7jgH33Y3GsMzzGaTqWjlKOElx14pSuwHTVtmgaA9hiSVU-w6ettbgnKcP5_L_dg65_3szVh_2gtLuqvOMCKqnJ2TCPI3sWCjywse2vdo5SwtUg9PSm9SQhM4VyhYNUcsSPPR5vpu3bRxntLvajvSbb-kOYotfzrZKiMtSx3T9PZo-BJk0t9e07nTZR5S0FF2820JVo2QkMBQLXevqlmTKBCezjuV7vL0LaGXDum40cVgoVTh1mtYvU2hV-W2hhBXRPRub96TFATmPQ364vB-HMTqG";

        $url = "https://api.amazon.com/auth/o2/token";
        $data = [
            "grant_type" => "refresh_token",
            "refresh_token" => $refreshToken,
            "client_id" => $clientId,
            "client_secret" => $clientSecret
        ];

        $options = [
            "http" => [
                "header"  => "Content-Type: application/x-www-form-urlencoded",
                "method"  => "POST",
                "content" => http_build_query($data)
            ]
        ];

        $context  = stream_context_create($options);
        $response = file_get_contents($url, false, $context);
        $result = json_decode($response, true);

        return $result["access_token"];
    }

    function sendToAmazon($product)
    {
        $client = new Client();

        $amazonApiUrl = "https://sellingpartnerapi-fe.amazon.com/catalog/2022-04-01/items"; // Change based on region

        $accessToken = $this->getAmazoneAccessToken();
        log_message('debug', 'Amazon Access Token: ' . $accessToken);

        $headers = [
            'Content-Type'  => 'application/json',
            'x-amz-access-token' => $accessToken, // Use OAuth Token
        ];
        $product_image = base_url() . $product['prd_default_image'];
        $payload = [
            'marketplaceId' => 'A21TJRUUN4KGV',
            'sellerId'      => 'AKRAM26CC1C9R',
            'productType'   => 'PRODUCT', // Change based on category
            'attributes'    => [
                'title'       => [$product['prd_name']],
                'description' => [$product['prd_description']],
                'sku'         => [rand(1000, 9999)],
                'price'       => [['value' => $product['prd_v_offer_price'], 'currency' => 'INR']],
                'image'       => [['url' => $product_image]],
            ],
        ];

        try {
            $response = $client->request('POST', $amazonApiUrl, [
                'headers' => $headers,
                'json'    => $payload,
            ]);

            $responseBody = json_decode($response->getBody(), true);

            if (isset($responseBody['status']) && $responseBody['status'] == 'SUCCESS') {
                log_message('info', 'Product successfully added to Amazon.');
            } else {
                log_message('error', 'Failed to add product to Amazon: ' . json_encode($responseBody));
            }
        } catch (\Exception $e) {
            log_message('error', 'Amazon API Error: ' . $e->getMessage());
        }
    }

    function delete_product($prd_id)
    {
        $product = new ProductModel();

        $prd = $product->get_product_by_id_for_edit_page($prd_id);
        if (file_exists($prd->prd_default_image)) {
            unlink($prd->prd_default_image);
        }
        if ($product->delete_product($prd_id)) {
            session()->set('success', "Product Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Product Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }


    /**
     * Product Section End
     */

    /**
     * Magazine Section Start
     */
    public function all_magazine()
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $product->get_all_magazine();
        echo view('admin/include/header', $data);
        echo view('admin/magazine/all_magazine');
        echo view('admin/include/footer');
    }

    function add_magazine()
    {
        $product = new ProductModel();

        // if ($product->check_magazine_name_avaliblity($this->request->getVar('magazine_name'))) {
        //     session()->set('success', "Magazine Name Already Exits");
        //     return redirect()->to($this->request->getUserAgent()->getReferrer());
        // }

        $data['magazine_name'] = $this->request->getVar('magazine_name');
        $data['magazine_slug'] = slug($this->request->getVar('magazine_name'));

        if ($product->add_magazine($data)) {
            session()->set('success', "Magazine Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Magazine Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_magazine($id)
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $product->get_magazine_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/magazine/edit_magazine');
        echo view('admin/include/footer');
    }

    function update_magazine($id)
    {
        $product = new ProductModel();
       
        $data['magazine_name'] = $this->request->getVar('magazine_name');
        $data['magazine_slug'] = slug($this->request->getVar('magazine_name'));

        if ($product->update_magazine($data, $id)) {
            session()->set('success', "Magazine Successfully Updated");
            return redirect()->route('admin/magazine/all_magazine');
        } else {
            session()->set('error', "Magazine Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_magazine($id)
    {
        $product = new ProductModel();

        if ($product->delete_magazine($id)) {
            session()->set('success', "Magazine Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Magazine Deleted Failed.");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Magazine Section End
     */

     /**
     * Magazine Edition  Section Start
     */
    public function all_edition()
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $product->get_all_edition();
        $data['all_magazine'] = $product->get_all_magazine();
        echo view('admin/include/header', $data);
        echo view('admin/magazine/all_edition');
        echo view('admin/include/footer');
    }

    function add_edition()
    {
        $product = new ProductModel();

        $data['magazine_edition_name'] = $this->request->getVar('magazine_edition_name');
        $data['magazine_edition_magazine_id'] =  $this->request->getVar('magazine_edition_magazine_id');
        $data['magazine_edition_order_by'] =  $this->request->getVar('magazine_edition_order_by');
        $data['magazine_edition_rand_number'] =  rand(10000, 99999);

        if ($this->request->getFile('magazine_edition_image')->isValid() && !$this->request->getFile('magazine_edition_image')->hasMoved()) {
            $image_1 = $this->request->getFile('magazine_edition_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['magazine_edition_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($this->request->getFile('magazine_edition_pdf')->isValid() && !$this->request->getFile('magazine_edition_pdf')->hasMoved()) {
            $pdf = $this->request->getFile('magazine_edition_pdf');
            
            // Validate that the file is a PDF
            if ($pdf->getClientMimeType() === 'application/pdf') {
                $newName = $pdf->getRandomName(); // Generate a unique name
                $pdf->move('uploads/pdf', $newName); // Move file to 'uploads/pdf' directory
                
                // Store the file path in the database
                $data['magazine_edition_pdf'] = 'uploads/pdf/' . $newName;
            } else {
                return redirect()->back()->with('error', 'Only PDF files are allowed.');
            }
        }

        if ($product->add_edition($data)) {
            session()->set('success', "Edition Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Edition Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_edition($id)
    {
        $setting = new SettingModel();
        $product = new ProductModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $product->get_edition_by_id($id);
        $data['all_magazine'] = $product->get_all_magazine();
        echo view('admin/include/header', $data);
        echo view('admin/magazine/edit_edition');
        echo view('admin/include/footer');
    }

    function update_edition($id)
    {
        $product = new ProductModel();
       
        $data['magazine_edition_name'] = $this->request->getVar('magazine_edition_name');
        $data['magazine_edition_magazine_id'] =  $this->request->getVar('magazine_edition_magazine_id');
        $data['magazine_edition_order_by'] =  $this->request->getVar('magazine_edition_order_by');
        
        if ($this->request->getFile('magazine_edition_image')->isValid() && !$this->request->getFile('magazine_edition_image')->hasMoved()) {
            $image_1 = $this->request->getFile('magazine_edition_image');
            $authorData = $product->get_edition_by_id($id);
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['magazine_edition_image'] = $webpPath_1;
                unlink($source_1);

                if (file_exists($authorData->magazine_edition_image)) {
                    unlink($authorData->magazine_edition_image);
                }
            }
        }

        if ($this->request->getFile('magazine_edition_pdf')->isValid() && !$this->request->getFile('magazine_edition_pdf')->hasMoved()) {
            $pdf = $this->request->getFile('magazine_edition_pdf');
            
            // Validate that the file is a PDF
            if ($pdf->getClientMimeType() === 'application/pdf') {

                $authorData = $product->get_edition_by_id($id);
                if (file_exists($authorData->magazine_edition_pdf)) {
                    unlink($authorData->magazine_edition_pdf);
                }

                $newName = $pdf->getRandomName(); // Generate a unique name
                $pdf->move('uploads/pdf', $newName); // Move file to 'uploads/pdf' directory
                
                // Store the file path in the database
                $data['magazine_edition_pdf'] = 'uploads/pdf/' . $newName;
            } else {
                return redirect()->back()->with('error', 'Only PDF files are allowed.');
            }
        }

        if ($product->update_edition($data, $id)) {
            session()->set('success', "Edition Successfully Updated");
            return redirect()->route('admin/magazine/all_edition');
        } else {
            session()->set('error', "Edition Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_edition($id)
    {
        $product = new ProductModel();

        $authorData = $product->get_edition_by_id($id);

        if (file_exists($authorData->magazine_edition_image)) {
            unlink($authorData->magazine_edition_image);
        }

        if (file_exists($authorData->magazine_edition_pdf)) {
            unlink($authorData->magazine_edition_pdf);
        }

        if ($product->delete_edition($id)) {
            session()->set('success', "Edition Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Edition Deleted Failed.");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Magazine Edition Section End
     */
}
