<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use WebPConvert\WebPConvert;

class SettingController extends BaseController
{
    /**
     * App Setting
     */
    function application_setting()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        echo view('admin/include/header', $data);
        echo view('admin/settings/application_setting');
        echo view('admin/include/footer');
    }

    function update_setting()
    {
        $setting = new SettingModel();
         
        $data['app_name'] = $this->request->getVar('app_name');
        $data['app_keywords'] = $this->request->getVar('app_keywords');
        $data['app_meta_title'] = $this->request->getVar('app_meta_title');
        $data['app_meta_description'] = $this->request->getVar('app_meta_description');
        $data['app_address'] = $this->request->getVar('app_address');
        $data['app_email'] = $this->request->getVar('app_email');
        $data['app_mobile'] = $this->request->getVar('app_mobile');
        $data['app_footer_about_us'] = $this->request->getVar('app_footer_about_us');
        $data['app_mail_protocol'] = $this->request->getVar('app_mail_protocol');
        $data['app_mail_host'] = $this->request->getVar('app_mail_host');
        $data['app_mail_port'] = $this->request->getVar('app_mail_port');
        $data['app_mail_username'] = $this->request->getVar('app_mail_username');
        $data['app_mail_password'] = $this->request->getVar('app_mail_password');
        $data['app_mail_crypto'] = $this->request->getVar('app_mail_crypto');
        $data['app_google_captcha_site_key'] = $this->request->getVar('app_google_captcha_site_key');
        $data['google_captcha_secret_key'] = $this->request->getVar('google_captcha_secret_key');
        $data['app_js'] = $this->request->getVar('app_js');
        $data['app_css'] = $this->request->getVar('app_css');
        $data['app_color_1'] = $this->request->getVar('app_color_1');
        $data['app_color_2'] = $this->request->getVar('app_color_2');
        $data['app_color_3'] = $this->request->getVar('app_color_3');
        $data['app_faecbook'] = $this->request->getVar('app_faecbook');
        $data['app_twitter'] = $this->request->getVar('app_twitter');
        $data['app_youtube'] = $this->request->getVar('app_youtube');
        $data['app_linkedin'] = $this->request->getVar('app_linkedin');
        $data['app_telegram'] = $this->request->getVar('app_telegram');
        $data['app_instagram'] = $this->request->getVar('app_instagram');
        $data['app_phone_pay_merchant_id'] = $this->request->getVar('app_phone_pay_merchant_id');
        $data['app_phone_pay_api_key'] = $this->request->getVar('app_phone_pay_api_key');
        $data['app_company_pin_code'] = $this->request->getVar('app_company_pin_code');
        
        $app_image = $setting->get_application_setting();

        if ($this->request->getFile('app_sticky_logo')->isValid() && !$this->request->getFile('app_sticky_logo')->hasMoved()) {
            $image_1 = $this->request->getFile('app_sticky_logo');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['app_sticky_logo'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($app_image->app_sticky_logo)) {
                    unlink($app_image->app_sticky_logo);
                }
            }
        }
        if ($this->request->getFile('app_footer_logo')->isValid() && !$this->request->getFile('app_footer_logo')->hasMoved()) {
            $image_1 = $this->request->getFile('app_footer_logo');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['app_footer_logo'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($app_image->app_footer_logo)) {
                    unlink($app_image->app_footer_logo);
                }
            }
        }
        if ($this->request->getFile('app_fevicon')->isValid() && !$this->request->getFile('app_fevicon')->hasMoved()) {
            $image_1 = $this->request->getFile('app_fevicon');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['app_fevicon'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($app_image->app_fevicon)) {
                    unlink($app_image->app_fevicon);
                }
            }
        }
        if($setting->update_application_setting($data))
        {
            session()->set('success', "Application Setting Successfully Saved");
            return redirect()->route('admin/setting/application_setting');
        }
        else
        {
            session()->set('error', "Application Setting Saved Failed");
            return redirect()->route('admin/setting/application_setting');
        }
    }
    /**
     * Coupon Code 
     */

    function all_coupon()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_coupon'] = $setting->get_all_coupon_code();
        echo view('admin/include/header', $data);
        echo view('admin/coupon/all_coupon_code');
        echo view('admin/include/footer');
    }

    function add_new_coupon()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        echo view('admin/include/header', $data);
        echo view('admin/coupon/add_new_coupon');
        echo view('admin/include/footer');
    }

    function add_coupon()
    {
        $setting = new SettingModel();
        $data['coupon_code'] = $this->request->getVar('coupon_code');
        $data['coupon_discount'] = $this->request->getVar('coupon_discount');
        $data['coupon_start_date'] = $this->request->getVar('coupon_start_date');
        $data['coupon_end_date'] = $this->request->getVar('coupon_end_date');
        $data['coupon_count'] = $this->request->getVar('coupon_count');
        $data['coupon_status'] = 1;
        if ($setting->add_coupon($data)) {
            session()->set('success', "Coupon Successfully Added");
            return redirect()->route('admin/coupon/all_coupon');
        } else {
            session()->set('error', "Coupon Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_coupon($id)
    {
        $setting = new SettingModel();
        if ($setting->delete_coupon($id)) {
            session()->set('success', "Coupon Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Coupon Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_coupon($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['coupon'] = $setting->get_coupon_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/coupon/edit_coupon');
        echo view('admin/include/footer');
    }

    function update_coupon($id)
    {
        $setting = new SettingModel();
        $data['coupon_code'] = $this->request->getVar('coupon_code');
        $data['coupon_discount'] = $this->request->getVar('coupon_discount');
        $data['coupon_start_date'] = $this->request->getVar('coupon_start_date');
        $data['coupon_end_date'] = $this->request->getVar('coupon_end_date');
        $data['coupon_count'] = $this->request->getVar('coupon_count');
        if ($setting->update_coupon($data, $id)) {
            session()->set('success', "Coupon Successfully Updated");
            return redirect()->route('admin/coupon/all_coupon');
        } else {
            session()->set('error', "Coupon Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Role Permission
     */

    public function all_permission()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_permission'] = $setting->get_all_role_permission();

        return view('admin/include/header', $data)
            . view('admin/role/all_permission')
            . view('admin/include/footer');
    }

    public function add_new_permission()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_menu'] = $setting->get_all_menu_and_sub_menu();

        return view('admin/include/header', $data)
            . view('admin/role/add_permission')
            . view('admin/include/footer');
    }

    public function permission_add()
    {
        $setting = new SettingModel();
        $roleName = $this->request->getVar('role_name');

        // Check if role name already exists
        if ($setting->check_role_name_exists($roleName)) {
            session()->set('error', 'Role Name Already Exists');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        // Add new permission
        if ($setting->permission_add($this->request->getVar('role_name'))) {
            session()->set('success', 'Permission Successfully Added');
            return redirect()->to(base_url('admin/role_permission/all_permission'));
        } else {
            session()->set('error', 'Permission Addition Failed');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function edit_permission($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_menu'] = $setting->get_all_menu_and_sub_menu();
        $data['permission'] = $setting->get_permission_by_id($id);

        return view('admin/include/header', $data)
            . view('admin/role/edit_permission')
            . view('admin/include/footer');
    }

    public function update_permission($id)
    {
        $setting = new SettingModel();
        if ($setting->update_permission($id, $this->request->getPost())) {
            session()->set('success', 'Permission Successfully Updated');
            return redirect()->to(base_url('admin/role_permission/all_permission'));
        } else {
            session()->set('error', 'Permission Update Failed');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function delete_permission($id)
    {
        $setting = new SettingModel();
        if ($setting->delete_permission($id)) {
            session()->set('success', 'Permission Successfully Deleted');
            return redirect()->to(base_url('admin/role_permission/all_permission'));
        } else {
            session()->set('error', 'Permission Deletion Failed');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Contact 
     */
    function all_contact_details()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_contact'] = $setting->get_all_contact_info();
        echo view('admin/include/header', $data);
        echo view('admin/contact/all_contact');
        echo view('admin/include/footer');
    }

    /**
     * Delivery Setting
     */
    function delivery_setting()
    {
        error_reporting(0);
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        echo view('admin/include/header', $data);
        echo view('admin/settings/delivery_setting');
        echo view('admin/include/footer');
    }

    function delivery_system()
    {
        $setting = new SettingModel();
        $data['app_delivery_system'] =  $this->request->getVar('status');
        echo $setting->delivery_system($data);
    }

    function active_national_delivery_system()
    {
        $setting = new SettingModel();
        $data['app_national_delivery'] =  $this->request->getVar('status');
        echo $setting->delivery_system($data);
    }

    function active_state_delivery_system()
    {
        $setting = new SettingModel();
        $data['app_state_delivery'] =  $this->request->getVar('status');
        echo $setting->delivery_system($data);
    }

    function active_dist_delivery_system()
    {
        $setting = new SettingModel();
        $data['app_dist_delivery'] =  $this->request->getVar('status');
        echo $setting->delivery_system($data);
    }

    function active_local_delivery_system()
    {
        $setting = new SettingModel();
        $data['app_local_delivery'] =  $this->request->getVar('status');
        echo $setting->delivery_system($data);
    }

    function local_delivery_details()
    {
        $setting = new SettingModel();
        $data['app_local_delivery_details'] =  json_encode($this->request->getVar('local_delivery_details'));
        if($setting->delivery_system($data))
        {
            session()->set('success', "Local Delivery Details Successfully Updated");
            return redirect()->route('admin/setting/delivery_setting');
        }
        else
        {
            session()->set('error', "Local Delivery Details Update Failed");
            return redirect()->route('admin/setting/delivery_setting');
        }
    }


    function dist_delivery_details()
    {
        $setting = new SettingModel();
        $data['app_dist_delivery_details'] =  json_encode($this->request->getVar('dist_delivery_details'));
        if($setting->delivery_system($data))
        {
            session()->set('success', "Dist Delivery Details Successfully Updated");
            return redirect()->route('admin/setting/delivery_setting');
        }
        else
        {
            session()->set('error', "Dist Delivery Details Update Failed");
            return redirect()->route('admin/setting/delivery_setting');
        }
    }

    function state_delivery_details()
    {
        $setting = new SettingModel();
        $data['app_state_delivery_details'] =  json_encode($this->request->getVar('state_delivery_details'));
        if($setting->delivery_system($data))
        {
            session()->set('success', "State Delivery Details Successfully Updated");
            return redirect()->route('admin/setting/delivery_setting');
        }
        else
        {
            session()->set('error', "State Delivery Details Update Failed");
            return redirect()->route('admin/setting/delivery_setting');
        }
    }

    function national_delivery_details()
    {
        $setting = new SettingModel();
        $data['app_national_delivery_details'] =  json_encode($this->request->getVar('national_delivery_details'));
        if($setting->delivery_system($data))
        {
            session()->set('success', "State Delivery Details Successfully Updated");
            return redirect()->route('admin/setting/delivery_setting');
        }
        else
        {
            session()->set('error', "State Delivery Details Update Failed");
            return redirect()->route('admin/setting/delivery_setting');
        }
    }

    function update_shiprocket_details()
    {
        $setting = new SettingModel();
        $data['app_shiprocket_email_id'] = $this->request->getVar('app_shiprocket_email_id');
        $data['app_shiprocket_password'] = $this->request->getVar('app_shiprocket_password');
        if($setting->delivery_system($data))
        {
            session()->set('success', "Shiprocket Details Successfully Updated");
            return redirect()->route('admin/setting/delivery_setting');
        }
        else
        {
            session()->set('error', "Shiprocket Details Details Update Failed");
            return redirect()->route('admin/setting/delivery_setting');
        }
    }
    
}
