<?php

namespace App\Controllers;

use App\Models\AuthModel;
use App\Models\SettingModel;

class AuthController extends BaseController
{
    /**
     * Home Section 
     * @ Depericated
     */
    public function login()
    {
        if (isset($_POST['submit'])) {
            $data['validation'] = \Config\Services::validation();
            $user_identifier = $this->request->getVar('user_identifier');

            // Check if the input is an email or mobile number
            if (filter_var($user_identifier, FILTER_VALIDATE_EMAIL)) {
                // It's an email, validate email
                $input = $this->validate([
                    'user_identifier' => 'required|valid_email',
                    'user_password'   => 'required'
                ]);
            } elseif (is_numeric($user_identifier) && strlen($user_identifier) == 10) {
                // It's a mobile number, validate mobile
                $input = $this->validate([
                    'user_identifier' => 'required|numeric|min_length[10]|max_length[10]',
                    'user_password'   => 'required'
                ]);
            } else {
                // Invalid input
                session()->set('error', "Please enter a valid Email ID or Mobile Number.");
                return redirect()->route('login');
            }

            if (!$input) {
                echo view('login', [
                    'validation' => $this->validator,
                    'title' => 'Login'
                ]);
            } else {
                $auth = new AuthModel();

                if (filter_var($user_identifier, FILTER_VALIDATE_EMAIL)) {
                    // If it's an email, get user by email
                    $userData = $auth->get_user_by_email($user_identifier);
                } else {
                    // If it's a mobile, get user by mobile
                    $userData = $auth->get_user_by_mobile($user_identifier);
                }

                if (!$userData) {
                    session()->set('error', "Invalid Email ID or Mobile No.");
                    return redirect()->route('login');
                } elseif ($userData->user_status == 0) {
                    session()->set('error', "Account Not Approved. Please Wait For Account Approval.");
                    return redirect()->route('login');
                } elseif ($userData->user_status == 2) {
                    session()->set('error', "Your Account is Banned. Please Contact Administrator");
                    return redirect()->route('login');
                } elseif ($userData->user_status == 3) {
                    session()->set('error', "Your Account was Rejected. Please Contact Administrator");
                    return redirect()->route('login');
                } else {
                    // Check password
                    if ($userData->user_password != hash("sha256", $this->request->getVar('user_password'))) {
                        session()->set('error', "Password does not match.");
                        return redirect()->route('login');
                    } else {
                        $token['user_token'] = rand(100000000, 999999999999);
                        $auth->update_token($token, $userData->user_id);

                        $ses_data = [
                            'user_id'       => $userData->user_id,
                            'name'          => $userData->user_name,
                            'mobile'        => $userData->user_mobile,
                            'role'          => $userData->user_role,
                            'user_token'    => $token['user_token'],
                            'logged_in'     => TRUE
                        ];
                        session()->set($ses_data);
                        if (session()->get('role') != 'User') {
                            return redirect()->to('/admin/dashboard');
                        } else {
                            return redirect()->to('my-account');
                        }
                    }
                }
            }
        } else {
            if (session()->get('logged_in') == TRUE) {
                if (session()->get('role') != 'User') {
                    return redirect()->to('/admin/dashboard');
                } else {
                    return redirect()->to('my-account');
                }
            } else {
                $setting = new SettingModel();
                $data['app_setting']        = $setting->get_application_setting();
                $data['title']              = 'Login | '.$data['app_setting']->app_meta_title;
                $data['description']        = $data['app_setting']->app_meta_description;
                $data['keyword']            = $data['app_setting']->app_keywords;
                echo view('front/include/header', $data);
                echo view('front/login');
                echo view('front/include/footer');
            }
        }
    }

    /**
     * Login Firebase
     */

     public function verify_otp_test()
    {
        // $json = $this->request->getJSON();
        // $mobile = $json->mobile;

        $mobile = '+919330442119';

        $auth = new AuthModel();
        $userData = $auth->get_user_by_mobile(substr($mobile, -10));

        if (!$userData) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Mobile number not found.']);
        } elseif ($userData->user_status == 0) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Account Not Approved.']);
        } elseif ($userData->user_status == 2) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Account Banned.']);
        } elseif ($userData->user_status == 3) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Account Rejected.']);
        }

        // Set session data
        $token['user_token'] = rand(100000000, 999999999999);
        $auth->update_token($token, $userData->user_id);

        $ses_data = [
            'user_id'           => $userData->user_id,
            'user_name'         => $userData->user_name,
            'user_mobile'       => $userData->user_mobile,
            'user_role'         => $userData->user_role,
            'user_token'        => $token['user_token'],
            'logged_in'         => TRUE
        ];
        session()->set($ses_data);

        return $this->response->setJSON(['status' => 'success', 'message' => 'Login successful.', 'user_role' => $userData->user_role]);
    }

    public function verify_otp()
    {
        $json = $this->request->getJSON();
        $mobile = $json->mobile;

        $auth = new AuthModel();
        $userData = $auth->get_user_by_mobile(substr($mobile, -10));

        if (!$userData) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Mobile number not found.']);
        } elseif ($userData->user_status == 0) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Account Not Approved.']);
        } elseif ($userData->user_status == 2) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Account Banned.']);
        } elseif ($userData->user_status == 3) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Account Rejected.']);
        }

        // Set session data
        $token['user_token'] = rand(100000000, 999999999999);
        $auth->update_token($token, $userData->user_id);

        $ses_data = [
            'user_id'           => $userData->user_id,
            'user_name'         => $userData->user_name,
            'user_mobile'       => $userData->user_mobile,
            'user_role'         => $userData->user_role,
            'user_token'        => $token['user_token'],
            'logged_in'         => TRUE
        ];
        session()->set($ses_data);

        return $this->response->setJSON(['status' => 'success', 'message' => 'Login successful.', 'user_role' => $userData->user_role]);
    }

    function registration()
    {
        if (session()->get('logged_in') == TRUE) {
            if (session()->get('role') != 'User') {
                return redirect()->to('/admin/dashboard');
            } else {
                return redirect()->to('my-account');
            }
        } else {
            $setting = new SettingModel();
            $data['app_setting']        = $setting->get_application_setting();
            $data['title']              = 'Registration | '.$data['app_setting']->app_meta_title;
            $data['description']        = $data['app_setting']->app_meta_description;
            $data['keyword']            = $data['app_setting']->app_keywords;
            echo view('front/include/header', $data);
            echo view('front/registration');
            echo view('front/include/footer');
        }
    }

    //logout
    function logout()
    {
        session()->destroy();
        session()->set('success', "You Are Successfully Logout");
        return redirect()->to('login');
    }
}
