<?php

namespace App\Controllers;

use App\Models\UserModel;
use League\OAuth2\Client\Provider\Google;
use CodeIgniter\Controller;

class GoogleAuthController extends Controller
{
    private $provider;

    public function __construct()
    {
        $config = config('Google');
        $this->provider = new Google([
            'clientId'     => $config->clientId,
            'clientSecret' => $config->clientSecret,
            'redirectUri'  => $config->redirectUri,
        ]);
    }

    // Redirect to Google for Authentication
    public function login()
    {
        $authUrl = $this->provider->getAuthorizationUrl();
        session()->set('oauth2state', $this->provider->getState());
        return redirect()->to($authUrl);
    }

    // Callback after Google Auth
    public function callback()
    {
        $state = $this->request->getVar('state');
        $code = $this->request->getVar('code');

        // Validate state
        if (empty($state) || ($state !== session()->get('oauth2state'))) {
            session()->remove('oauth2state');
            return redirect()->to($this->request->getUserAgent()->getReferrer()); 
        }

        try {
            // Exchange code for access token
            $accessToken = $this->provider->getAccessToken('authorization_code', ['code' => $code]);

            // Retrieve user info
            $googleUser = $this->provider->getResourceOwner($accessToken);
            $userData = $googleUser->toArray();

            // Check or register user in the database
            $user = get_user_by_email($userData['email']);

            if (!$user) {
                $userModel = new UserModel();
                $dataUser = [
                    'user_name' => $userData['name'],
                    'user_email' => $userData['email'],
                    'user_role' => 'User',
                    'user_create_at' => date('Y-m-d')
                ];

                $userID = $userModel->add_user($dataUser);
                $userInfo = get_user_by_id($userID);

                $ses_data = [
                    'user_id'           => $userInfo->user_id,
                    'name'              => $userInfo->user_name,
                    'mobile'            => $userInfo->user_mobile,
                    'role'              => $userInfo->user_role,
                    'logged_in'         => TRUE
                ];
            }
            else
            {
                $ses_data = [
                    'user_id'           => $user->user_id,
                    'name'              => $user->user_name,
                    'mobile'            => $user->user_mobile,
                    'role'              => $user->user_role,
                    'logged_in'         => TRUE
                ];
            }
            // Set user session
            session()->set($ses_data);
            return redirect()->to('/dashboard');
        } catch (\Exception $e) {
            return redirect()->to('/auth/login')->with('error', 'Google authentication failed');
        }
    }
}
