<?php

namespace App\Controllers;

use App\Models\BlogModel;
use App\Models\ProductModel;
use App\Models\SettingModel;
use App\Libraries\Shiprocket;
use App\Models\HomeModel;
use App\Models\OrderModel;
use App\Models\UserModel;
use WebPConvert\WebPConvert;

class HomeController extends BaseController
{
    /**
     * Home Section
     */
    public function index()
    {
        $setting                    = new SettingModel();
        $product                    = new ProductModel();
        $blog                       = new BlogModel();
        $user                       = new UserModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_featured_prd']   = $product->get_all_featured_books();
        $data['all_top_prd']        = $product->get_all_top_books();
        $data['all_top_sale']       = $product->get_all_top_selling_books();
        $data['all_top_rating']     = $product->get_all_top_rating_products();
        $data['all_slider']         = $setting->get_all_slider();
        $data['heading']            = $setting->get_all_section_heading();
        $data['all_top_cat']        = $product->get_top_8_category_with_images();
        $data['all_banner']         = $setting->get_all_front_banner();
        $data['all_testimonial']    = $setting->get_all_testimonial();
        $data['all_blog']           = $blog->get_all_blog_four_for_frontend();
        $data['all_author']         = $user->get_all_published_book_author();

        echo view('front/include/header', $data);
        echo view('front/home');
        echo view('front/include/footer');
    }

    /**
     * Contact Page
     */
    public function contact()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        echo view('front/include/header', $data);
        echo view('front/contact');
        echo view('front/include/footer');
    }

    /**
     * Blog Section Start
     */
    function blog_category($dataMain)
    {
        $setting = new SettingModel();
        $blog = new BlogModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['title'] = $dataMain->category_name . ' - ' . $data['app_setting']->app_name;
        $data['description'] = $data['app_setting']->app_meta_description;
        $data['keyword'] = $data['app_setting']->app_keywords;
        $data['data'] = $dataMain;
        $data['all_blog'] = $blog->get_blog_by_category($dataMain->category_id);
        $data['all_category']               = $blog->get_all_category();
        $data['all_top_blog']               = $blog->get_top_4_blog();
        echo view('front/include/header', $data);
        echo view('front/blog/blog_category', $data);
        echo view('front/include/footer');
    }

    function all_blog()
    {
        $setting    = new SettingModel();
        $blog       = new BlogModel();
        $data['app_setting']                = $setting->get_application_setting();
        $data['title']                      = 'Blog || ' . $data['app_setting']->app_name;
        $data['description']                = $data['app_setting']->app_meta_description;
        $data['keyword']                    = $data['app_setting']->app_keywords;
        $data['all_blog']                   = $blog->get_all_blog_for_front();
        $data['all_category']               = $blog->get_all_category();
        $data['all_top_blog']               = $blog->get_top_4_blog();
        echo view('front/include/header', $data);
        echo view('front/blog/all_blog');
        echo view('front/include/footer');
    }

    function blog_details($dataMain)
    {
        $setting = new SettingModel();
        $blog = new BlogModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $dataMain->title . ' - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $dataMain;
        $data['all_category']       = $blog->get_all_category();
        $data['all_top_blog']       = $blog->get_top_4_blog();
        echo view('front/include/header', $data);
        echo view('front/blog/blog_details');
        echo view('front/include/footer');
    }
    /**
     * Blog Section End
     */

    /**
     * About Us Section Start
     */
    function general_information()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = 'General Information - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $setting->get_page_by_id(5);
        echo view('front/include/header', $data);
        echo view('front/about/general_information');
        echo view('front/include/footer');
    }

    function our_team()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = 'Our Team - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $setting->get_all_our_team();
        echo view('front/include/header', $data);
        echo view('front/about/our_team');
        echo view('front/include/footer');
    }

    /**
     * About Us Section End
     */

    /**
     * Event Section Start
     */
    function all_event()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = 'Event - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_event']               = $setting->get_all_event();
        echo view('front/include/header', $data);
        echo view('front/event/all_event');
        echo view('front/include/footer');
    }

    function event_details($dataMain)
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $dataMain->event_title . ' - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $dataMain;
        echo view('front/include/header', $data);
        echo view('front/event/event_details');
        echo view('front/include/footer');
    }

    /**
     * Media Section Start
     */
    function all_media()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              =  'Media - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_data']           = $setting->get_all_media();
        echo view('front/include/header', $data);
        echo view('front/all_media');
        echo view('front/include/footer');
    }

    /**
     * print cost calculator 
     */
    function print_cost_calculator()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = 'Print Cost Calculator - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']                   = $setting->get_print_your_book_data_by_id(4);
        echo view('front/include/header', $data);
        echo view('front/print_cost_calculator');
        echo view('front/include/footer');
    }

    /**
     * register as author
     */

    function register_as_author()
    {
        $setting    = new SettingModel();
        $product    = new ProductModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = 'Register As Author || ' . $data['app_setting']->app_name;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        $data['data']                   = $setting->get_print_your_book_data_by_id(3);
        echo view('front/include/header', $data);
        echo view('front/register_as_author');
        echo view('front/include/footer');
    }

    /**
     * Product Category
     */
    function prd_cat_details($catData)
    {
        $setting    = new SettingModel();
        $product    = new ProductModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['category']               = $catData;
        $data['title']                  = $catData->category_name . ' || ' . $data['app_setting']->app_name;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        $data['all_product']            = $product->get_prd_by_cat_id($catData->category_id);
        echo view('front/include/header', $data);
        echo view('front/product/product_category');
        echo view('front/include/footer');
    }

    /**
     * Product Details
     */
    function product_details($prdData)
    {
        $setting    = new SettingModel();
        $product    = new ProductModel();
        $data['app_setting']                = $setting->get_application_setting();
        $data['product']                    = $prdData;
        $data['title']                      = $prdData->prd_name . ' || ' . $data['app_setting']->app_name;
        $data['description']                = $prdData->prd_seo_description;
        $data['keyword']                    = $prdData->prd_seo_keyword;
        $data['prd_extra_image']            = $product->get_extra_product_image_by_prd_id($prdData->prd_id);
        $data['all_related_prd']            = $product->get_related_prd_for_prd_details_page_by_cat($prdData->prd_category);
        echo view('front/include/header', $data);
        echo view('front/product/product_details');
        echo view('front/include/footer');
    }

    /**
     * Page Details
     */
    function page_details($pageData)
    {
        $setting    = new SettingModel();
        $data['app_setting']                = $setting->get_application_setting();
        $data['title']                      = $pageData->name . ' || ' . $data['app_setting']->app_name;
        $data['description']                = $pageData->meta_keyword;
        $data['keyword']                    = $pageData->meta_descrition;
        $data['data']                       = $pageData;
        echo view('front/include/header', $data);
        echo view('front/page_details');
        echo view('front/include/footer');
    }

    /**
     * Check Devlivery By Pin Code Start
     */
    function get_delivery_details_by_pin_code()
    {
        if ($this->request->getVar('id')) {
            $setting = new SettingModel();
            $shiprocket = new Shiprocket();
            $app_setting = $setting->get_application_setting();
            if ($app_setting->app_delivery_system == 0) {
                $post['postcode'] = $this->request->getVar('id');
                $data = $shiprocket->postcode($post);
                session()->set('zip', $this->request->getVar('id'));
                session()->set('del_system', 'Shiprocket');
                session()->set('city_and_pin', '<b>' . $data['postcode_details']['city'] . ', ' . $data['postcode_details']['postcode'] . '</b>');

                $delivery['delivery_postcode'] = $this->request->getVar('id');
                $delivery['cod'] = 1;
                $delivery['pickup_postcode'] = $app_setting->app_company_pin_code;
                $delivery['weight'] = $this->request->getVar('prd_weight');

                $delivery_details = $shiprocket->serviceability($delivery);
                $delivery_date = $delivery_details['data']['available_courier_companies'][0]['estimated_delivery_days'];
                $shipping_charge =  $delivery_details['data']['available_courier_companies'][0]['rate'];
                $date = date('Y-m-d', strtotime("+" . $delivery_date . " days"));
                $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . $shipping_charge . '</b>';
                session()->set('shipping_charge', $shipping_charge);
                $data = [
                    'type' => 'success',
                    'result' =>  $result,
                    'del_system' => 'Shiprocket'
                ];
                echo json_encode($data);
            } else {
                if ($app_setting->app_local_delivery == 1 && $app_setting->app_dist_delivery == 0 && $app_setting->app_state_delivery == 0 && $app_setting->app_national_delivery == 0) {

                    $post['postcode'] = $this->request->getVar('id');
                    $data = $shiprocket->postcode($post);
                    session()->set('zip', $this->request->getVar('id'));
                    session()->set('del_system', 'local');
                    session()->set('city_and_pin', '<b>' . $data['postcode_details']['city'] . ', ' . $data['postcode_details']['postcode'] . '</b>');
                    $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_local_delivery_details)[1] . " days"));
                    $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_local_delivery_details)[2] . '</b>';
                    session()->set('shipping_charge', json_decode($app_setting->app_local_delivery_details)[2]);
                    $data_r = [
                        'type' => 'success',
                        'result' =>  $result,
                        'del_system' => 'local'
                    ];
                    echo json_encode($data_r);
                } elseif ($app_setting->app_local_delivery == 1 && $app_setting->app_dist_delivery == 1 && $app_setting->app_state_delivery == 0 && $app_setting->app_national_delivery == 0) {
                    $post['postcode'] = $app_setting->app_company_pin_code;
                    $post_1['postcode'] = $this->request->getVar('id');
                    $data = $shiprocket->postcode($post);
                    $data_1 = $shiprocket->postcode($post_1);
                    if ($data['postcode_details']['city'] == $data_1['postcode_details']['city']) {
                        session()->set('zip', $this->request->getVar('id'));
                        session()->set('del_system', 'Dist');
                        session()->set('city_and_pin', '<b>' . $data_1['postcode_details']['city'] . ', ' . $data_1['postcode_details']['postcode'] . '</b>');

                        $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_dist_delivery_details)[1] . " days"));
                        $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_dist_delivery_details)[2] . '</b>';
                        session()->set('shipping_charge', json_decode($app_setting->app_dist_delivery_details)[2]);
                        $data_r = [
                            'type' => 'success',
                            'result' =>  $result,
                            'del_system' => 'Dist'
                        ];
                        echo json_encode($data_r);
                    } else {
                        session()->remove('zip');
                        session()->remove('del_system');
                        session()->remove('city_and_pin');
                        $data = [
                            'type' => 'error',
                            'result' =>  'Delivery Not Available In  ' . $this->request->getVar('id')
                        ];
                        echo json_encode($data);
                    }
                } elseif ($app_setting->app_local_delivery == 1 && $app_setting->app_dist_delivery == 1 && $app_setting->app_state_delivery == 1 && $app_setting->app_national_delivery == 0) {

                    $post['postcode'] = $app_setting->app_company_pin_code;
                    $post_1['postcode'] = $this->request->getVar('id');
                    $data = $shiprocket->postcode($post);
                    $data_1 = $shiprocket->postcode($post_1);
                    if ($data['postcode_details']['city'] == $data_1['postcode_details']['city']) {
                        session()->set('zip', $this->request->getVar('id'));
                        session()->set('del_system', 'Dist');
                        session()->set('city_and_pin', '<b>' . $data_1['postcode_details']['city'] . ', ' . $data_1['postcode_details']['postcode'] . '</b>');

                        $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_dist_delivery_details)[1] . " days"));
                        $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_dist_delivery_details)[2] . '</b>';
                        session()->set('shipping_charge', json_decode($app_setting->app_dist_delivery_details)[2]);
                        $data_r = [
                            'type' => 'success',
                            'result' =>  $result,
                            'del_system' => 'Dist'
                        ];
                        echo json_encode($data_r);
                    } elseif ($data['postcode_details']['state'] == $data_1['postcode_details']['state']) {
                        session()->set('zip', $this->request->getVar('id'));
                        session()->set('del_system', 'State');
                        session()->set('city_and_pin', '<b>' . $data_1['postcode_details']['city'] . ', ' . $data_1['postcode_details']['postcode'] . '</b>');

                        $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_state_delivery_details)[1] . " days"));
                        $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_state_delivery_details)[2] . '</b>';
                        session()->set('shipping_charge', json_decode($app_setting->app_state_delivery_details)[2]);
                        $data_r = [
                            'type' => 'success',
                            'result' =>  $result,
                            'del_system' => 'State'
                        ];
                        echo json_encode($data_r);
                    } else {
                        session()->remove('zip');
                        session()->remove('del_system');
                        session()->remove('city_and_pin');
                        $data = [
                            'type' => 'error',
                            'result' =>  'Delivery Not Available In  ' . $this->request->getVar('id')
                        ];
                        echo json_encode($data);
                    }
                } elseif ($app_setting->app_local_delivery == 1 && $app_setting->app_dist_delivery == 1 && $app_setting->app_state_delivery == 1 && $app_setting->app_national_delivery == 1) {

                    $post['postcode'] = $app_setting->app_company_pin_code;
                    $post_1['postcode'] = $this->request->getVar('id');
                    $data = $shiprocket->postcode($post);
                    $data_1 = $shiprocket->postcode($post_1);
                    if ($data['postcode_details']['city'] == $data_1['postcode_details']['city']) {
                        session()->set('zip', $this->request->getVar('id'));
                        session()->set('del_system', 'Dist');
                        session()->set('city_and_pin', '<b>' . $data_1['postcode_details']['city'] . ', ' . $data_1['postcode_details']['postcode'] . '</b>');

                        $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_dist_delivery_details)[1] . " days"));
                        $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_dist_delivery_details)[2] . '</b>';
                        session()->set('shipping_charge', json_decode($app_setting->app_dist_delivery_details)[2]);
                        $data_r = [
                            'type' => 'success',
                            'result' =>  $result,
                            'del_system' => 'Dist',
                            'res' => '1'
                        ];
                        echo json_encode($data_r);
                    } elseif ($data['postcode_details']['state'] == $data_1['postcode_details']['state']) {
                        session()->set('zip', $this->request->getVar('id'));
                        session()->set('del_system', 'State');
                        session()->set('city_and_pin', '<b>' . $data_1['postcode_details']['city'] . ', ' . $data_1['postcode_details']['postcode'] . '</b>');

                        $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_state_delivery_details)[1] . " days"));
                        $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_state_delivery_details)[2] . '</b>';
                        session()->set('shipping_charge', json_decode($app_setting->app_state_delivery_details)[2]);
                        $data_r = [
                            'type' => 'success',
                            'result' =>  $result,
                            'del_system' => 'State'
                        ];
                        echo json_encode($data_r);
                    } else {
                        session()->set('zip', $this->request->getVar('id'));
                        session()->set('del_system', 'National');
                        session()->set('city_and_pin', '<b>' . $data_1['postcode_details']['city'] . ', ' . $data_1['postcode_details']['postcode'] . '</b>');

                        $date = date('Y-m-d', strtotime("+" . json_decode($app_setting->app_national_delivery_details)[1] . " days"));
                        $result = 'Delivery between <b>' . date('l, d F', strtotime($date)) . '</b> | Delivery Charge : <b>&#x20B9;' . json_decode($app_setting->app_national_delivery_details)[2] . '</b>';
                        session()->set('shipping_charge', json_decode($app_setting->app_national_delivery_details)[2]);
                        $data_r = [
                            'type' => 'success',
                            'result' =>  $result,
                            'del_system' => 'National'
                        ];
                        echo json_encode($data_r);
                    }
                }
            }
        }
    }
    /**
     * Check Devlivery By Pin Code Start
     */

    /**
     * Add to cart Start
     */
    public function add_to_cart()
    {
        // error_reporting(0);
        $cart = \Config\Services::cart();
        $product = new ProductModel();

        $re = "/\\(.*/";
        $prd_id         = $this->request->getVar('prd_id');
        $prd_slug       = $this->request->getVar('prd_slug');
        $prd_name       = preg_replace($re, "", $this->request->getVar('prd_name'));
        $prd_image      = $this->request->getVar('prd_image');
        $prd_price      = $this->request->getVar('prd_price');
        $qty            = $this->request->getVar('qty');

        // Retrieve current cart items
        $cart_contents = $cart->contents();

        // Check if the item already exists in the cart
        $item_exists = false;
        foreach ($cart_contents as $item) {
            if ($item['id'] == $prd_id) {
                // Update quantity and price if the item exists
                $new_qty = $qty; // Add the new quantity to existing quantity
                $item_exists = true;

                $cart->update(array(
                    'rowid'   => $item['rowid'],
                    'qty'     => $new_qty,
                    'price'   => $prd_price,
                    'options' => array(
                        'image'         => $prd_image,
                        'slug'          => $prd_slug,
                        'tax'           => round(($product->get_product_by_id_for_tax($prd_id)->prd_tax / 100) * ($prd_price * $new_qty)),
                    )
                ));
                break;
            }
        }

        // If the item does not exist, add it to the cart
        if (!$item_exists) {
            $data_1 = array(
                'id'      => $prd_id,
                'qty'     => $qty,
                'price'   => $prd_price,
                'name'    => $prd_name,
                'options' => array(
                    'image'         => $prd_image,
                    'slug'          => $prd_slug,
                    'tax'           => round(($product->get_product_by_id_for_tax($prd_id)->prd_tax / 100) * ($prd_price * $qty))
                )
            );
            $cart->insert($data_1);
        }

        // Return a response or print a message
        // print_r($cart->contents());
    }

    function remove_cart()
    {
        $id = $this->request->getVar('cart_id');
        $cart = \Config\Services::cart();
        $data = $cart->remove($id);
        echo $data;
    }

    public function update_cart()
    {
        $rowid = $this->request->getPost('rowid');
        $qty = $this->request->getPost('qty');
        $cart = \Config\Services::cart();

        // Update cart quantity
        $cart->update(array(
            'rowid' => $rowid,
            'qty' => $qty
        ));

        // Return updated cart totals
        echo json_encode([
            'subtotal' => $cart->total(),
            'total' => $cart->total() // Add discount and shipping calculations here
        ]);
    }


    public function cart_total()
    {
        $cart = \Config\Services::cart();
        echo json_encode([
            'subtotal' => $cart->total(),
            'total' => $cart->total(), // Add discount and shipping calculations here
            'discount' => 0 // Or apply actual discount logic
        ]);
    }

    public function apply_coupon()
    {
        $coupon = $this->request->getPost('coupon_code');
        // Validate coupon and apply discount
        if ($coupon == 'DISCOUNT10') {
            $discount = 10; // Example discount
            echo json_encode(['success' => true, 'discount' => $discount]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid coupon']);
        }
    }


    /**
     * Add to cart end
     */

    /**
     * Cart Page Start
     */
    function cart_page()
    {
        $setting = new SettingModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = $data['app_setting']->app_meta_title;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        echo view('front/include/header', $data);
        echo view('front/cart_page');
        echo view('front/include/footer');
    }
    /**
     * Cart Page End
     */

    /**
     * Checkout Page Start
     */
    function checkout_page()
    {
        $setting = new SettingModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = $data['app_setting']->app_meta_title;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        echo view('front/include/header', $data);
        echo view('front/checkout');
        echo view('front/include/footer');
    }

    /**
     * Checkout Page End
     */

    /**
     * order submit start
     */
    function submit_order()
    {
        // error_reporting(0);
        $cart = \Config\Services::cart();
        $order = new OrderModel();
        $user = new UserModel();
        $setting = new SettingModel();
        $rand = date("Ymd") . rand(1000, 9999);
        $tracking = "TC" . rand(1000, 9999) . date("Ymd");
        session()->set('tracking_id', $tracking);
        if ($this->request->getVar('save_address') == 0) {
            $user_details = get_user_by_mobile($this->request->getVar('user_mobile'));
            if (!$user_details) {

                $user_d['user_name']      = $this->request->getVar('user_first_name') . ' ' . $this->request->getVar('user_last_name');
                $user_d['user_mobile']    = $this->request->getVar('user_mobile');
                $user_d['user_email']     = $this->request->getVar('user_email');
                $user_d['user_password']  = hash("sha256", $this->request->getVar('user_mobile'));
                $user_d['user_role']      = 'User';
                $user_d['user_status']    = 1;
                $user_d['user_created_at']     = date('Y-m-d');
                $user_id = $user->add_user($user_d);

                $user_addr['user_order_address_user_id']   = $user_id;
                $user_addr['user_order_address_address']   = $this->request->getVar('user_order_address_address');
                $user_addr['user_order_address_city']      = $this->request->getVar('user_order_address_city');
                $user_addr['user_order_address_state']     = $this->request->getVar('user_order_address_state');
                $user_addr['user_order_address_country']   = $this->request->getVar('user_order_address_country');
                $user_addr['user_order_address_pin']       = $this->request->getVar('user_order_address_pin');
                $address_id = $user->add_new_order_address($user_addr);
            } else {
                $user_id = $user_details->user_id;
                $address_details = $user->check_user_order_address($user_details->user_id, $this->request->getVar('address_id'));
                if ($address_details) {
                    $address_id = $address_details->user_order_address_id;
                } else {
                    $user_addr['user_order_address_user_id']   = $user_details->user_id;
                    $user_addr['user_order_address_address']   = $this->request->getVar('user_order_address_address');
                    $user_addr['user_order_address_city']      = $this->request->getVar('user_order_address_city');
                    $user_addr['user_order_address_state']     = $this->request->getVar('user_order_address_state');
                    $user_addr['user_order_address_country']   = $this->request->getVar('user_order_address_country');
                    $user_addr['user_order_address_pin']       = $this->request->getVar('user_order_address_pin');
                    $address_id = $user->add_new_order_address($user_addr);
                }
            }
        } else {
            $address_id = $this->request->getVar('save_address');
            $user_id = user()->user_id;
        }

        if ($this->request->getVar('paymen_method') == 1) {
            $invoice = $order->get_last_invoice_id();
            if ($invoice) {
                preg_match('/(\d+)$/', $invoice, $matches);
                if (isset($matches[1])) {
                    $last_number = (int)$matches[1]; // Convert to integer
                    $new_number = $last_number + 1; // Increment by 1

                    // Combine the new number with the prefix or date
                    $inv_id = 'GP' . date('Ymd') . $new_number;
                } else {
                    // Handle the case where the numeric part cannot be extracted
                    $inv_id = 'GP' . date('Ymd') . '3300001';
                }
            } else {
                $inv_id = 'GP' . date('Ymd') . '3300001';
            }
            $cart_ttl = 0;
            if (session()->get('coupon_discount')) {
                foreach ($cart->contents() as $carts) {
                    $cart_ttl += $carts['subtotal'];
                }
                $discount = round((session()->get('coupon_discount') / 100) * $cart_ttl);
                $ttl_discount = $discount / count($cart->contents());
                $discount_per = session()->get('coupon_discount');
            } else {
                $ttl_discount = 0;
                $discount_per = 0;
            }


            if (session()->get('shipping_charge')) {
                $shipping = session()->get('shipping_charge') / count($cart->contents());
            } else {
                $shipping = 0;
            }

            if (session()->get('logged_in')) {
                $cart_ttl_for_wallet = 0;
                $ttl_tax_for_wallet = 0;
                foreach ($cart->contents() as $carts_amt) {
                    $cart_ttl_for_wallet += $carts_amt['subtotal'];
                    $ttl_tax_for_wallet += $carts_amt['options']['tax'];
                }
                if (session()->get('shipping_charge')) {
                    $shipping_charge = session()->get('shipping_charge');
                } else {
                    $shipping_charge = 0;
                }

                $cart_ttl_for_wallet + $ttl_tax_for_wallet + $shipping_charge;
                $wallet_bal = min(user()->user_wallet_balance, $cart_ttl_for_wallet);
            } else {
                $wallet_bal = 0;
            }

            foreach ($cart->contents() as $cart) {
                $product = new ProductModel();
                $prd_details = $product->get_product_by_id_for_tax($cart['id']);

                $data['order_prd_id']       = $cart['id'];
                $data['order_qnty']         = $cart['qty'];
                $data['user_id']            = $user_id;
                $data['order_price']        = $cart['subtotal'];
                $data['product_rate']       = $cart['price'];
                $data['order_date']         = date('Y-m-d h:i:s');
                $data['order_status']       = 0;
                $data['order_tracking_code'] = $tracking;
                $data['paymen_method']      = $this->request->getVar('paymen_method');
                $data['user_role']          = 'User';
                $data['gst_type']           = 1;
                $data['tax_rate']           = $prd_details->prd_tax;
                $data['tax_price']          = $cart['options']['tax'];
                $data['invoice_id']         = $inv_id;
                $data['discount_amt']       = $ttl_discount;
                $data['discount_per']       = $discount_per;
                $data['shipping_charge']    = $shipping;
                $data['address_id']         = $address_id;
                $data['is_online_order']    = 1;

                $order->add_order($data);
            }

            for ($a = 0; $a < 2; $a++) {
                $ord_status['order_status_user_id']     = $user_id;
                $ord_status['order_status_invoice_id']  = $inv_id;
                if ($a == 0) {
                    $ord_status['order_status']             = 6;
                } else {
                    $ord_status['order_status']             = 0;
                }
                $ord_status['order_status_date']        = date('Y-m-d h:i:s');
                $order->add_order_status($ord_status);
            }
            if (session()->get('coupon_discount')) {
                $coupon_details = $setting->check_coupon_code_by_name(session()->get('coupon_name'));
                $coupon_c = $coupon_details->coupon_used + 1;
                $cc['coupon_used'] = $coupon_c;
                $setting->update_coupon_count(session()->get('coupon_name'), $cc);
                session()->remove('coupon_name');
                session()->remove('coupon_discount');
            }

            $cart = \Config\Services::cart();
            $cart->destroy();
            session()->remove('coupon_discount');
            session()->set('success', "Order Successfully Placed");
            return redirect()->route('order_success');
        } else {
            $invoice = $order->get_last_invoice_id();
            if ($invoice) {
                $id_in = substr($invoice->invoice_id, 4);
                $mainInv = $id_in + 1;
                $inv_id = date('Y') . $mainInv;
            } else {
                $inv_id = date("Y") . '1001';
            }
            $cart_ttl = 0;
            if (session()->get('coupon_discount')) {
                foreach ($cart->contents() as $carts) {
                    $cart_ttl += $carts['subtotal'];
                }
                $discount = round((session()->get('coupon_discount') / 100) * $cart_ttl);
                $ttl_discount = $discount / count($cart->contents());
                $discount_per = session()->get('coupon_discount');
            } else {
                $ttl_discount = 0;
                $discount_per = 0;
            }
            if (session()->get('shipping_charge')) {
                $shipping = session()->get('shipping_charge') / count($cart->contents());
            } else {
                $shipping = 0;
            }

            if (session()->get('logged_in')) {
                $cart_ttl_for_wallet = 0;
                $ttl_tax_for_wallet = 0;
                foreach ($cart->contents() as $carts_amt) {
                    $cart_ttl_for_wallet += $carts_amt['subtotal'];
                    $ttl_tax_for_wallet += $carts_amt['options']['tax'];
                }
                if (session()->get('shipping_charge')) {
                    $shipping_charge = session()->get('shipping_charge');
                } else {
                    $shipping_charge = 0;
                }

                $cart_ttl_for_wallet + $ttl_tax_for_wallet + $shipping_charge;
                $wallet_bal = min(user()->user_wallet_balance, $cart_ttl_for_wallet);
            } else {
                $wallet_bal = 0;
            }

            $data = array();
            $amount = 0;
            $amtForeOutlet = 0;
            foreach ($cart->contents() as $cart) {
                $product = new ProductModel();
                $prd_details = $product->get_product_by_id_for_tax($cart['id']);

                $arr['order_prd_id']       = $cart['id'];
                $arr['order_qnty']         = $cart['qty'];
                $arr['dealer_id']          = $user_id;
                $arr['order_varient']      = $cart['options']['sub_varient'];
                $arr['order_price']        = $cart['subtotal'];
                $arr['product_rate']       = $cart['price'];
                $arr['varient_table']      = $cart['options']['varient_t_id'];
                $arr['order_date']         = date('Y-m-d h:i:s');
                $arr['order_status']       = 0;
                $arr['order_tracking_code'] = $tracking;
                $arr['dealer_order_id']    = $rand;
                $arr['paymen_method']      = $this->request->getVar('paymen_method');
                $arr['user_role']          = 'User';
                $arr['gst_type']           = 1;
                $arr['tax_rate']           = $prd_details->prd_tax;
                $arr['tax_price']          = $cart['options']['tax'];
                $arr['invoice_id']         = $inv_id;
                $arr['discount_amt']       = $ttl_discount;
                $arr['discount_per']       = $discount_per;
                $arr['shipping_charge']    = $shipping;
                $arr['is_admin_order']     = 0;
                $arr['address_id']         = $address_id;
                $arr['order_wallet_bal_deduct'] = $wallet_bal;
                $arr['is_online_order']    = 1;
                if (session()->get('logged_in')) {
                    $arr['stock_point_id'] = user()->user_added_by;
                }
                if (session()->get('del_system') == 'local') {
                    $arr['stock_point_id'] = $this->request->getVar('store');
                }
                $amount += $arr['order_price'] + $arr['tax_price'] + $arr['shipping_charge'] - $arr['discount_amt'];
                $amtForeOutlet += $arr['order_price'] + $arr['tax_price'] + $arr['shipping_charge'];
                $data[] = $arr;
            }

            $main_amt = $amount - $wallet_bal;

            session()->set('user_wallet_bal', $wallet_bal);
            session()->set('order_details', $data);
            session()->set('amt_for_e_outlet', $amtForeOutlet);
            $recharge_id = $rand;
            session()->set('rechage_id', $recharge_id);
            session()->set('amount_recharge', $main_amt);
            $app_setting = $setting->get_application_setting();
            $api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
            $_SESSION['payable_amount'] = $main_amt;
            $razorpayOrder = $api->order->create(array(
                'receipt'         => $recharge_id,
                'amount'          => $main_amt * 100,
                'currency'        => 'INR',
                'payment_capture' => 1
            ));
            $amount = $razorpayOrder['amount'];
            $razorpayOrderId = $razorpayOrder['id'];
            $_SESSION['razorpay_order_id'] = $razorpayOrderId;
            $_SESSION['recharge_id'] = $recharge_id;
            $_SESSION['amount'] = $main_amt;
            $raz_pay_data = $this->rozr_pay_prepareData($main_amt, $razorpayOrderId, $recharge_id, $user_id);
            echo view('rezorpay_order_payment', array('data' => $raz_pay_data));
        }
    }
    /**
     * order submit End
     */

    /**
     * Order success start
     */
    function order_success()
    {
        $setting = new SettingModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = $data['app_setting']->app_meta_title;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        echo view('front/include/header', $data);
        echo view('front/order_success');
        echo view('front/include/footer');
    }
    /**
     * Order success End
     */

    /**
     * Track Order Start
     */
    function track_order()
    {
        $setting = new SettingModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = $data['app_setting']->app_meta_title;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        if (isset($_POST['submit'])) {
            $order = new OrderModel();
            $data['content']        =   $order->get_order_details_for_track_order($this->request->getVar('track_id'));
            $data['tracking_id']    =   $this->request->getVar('track_id');
            if (!$data['content']) {
                session()->set('error', "No Data Found");
                return redirect()->to('track-order');
            }
        } else {
            $data['content']                = '';
        }
        echo view('front/include/header', $data);
        echo view('front/track_order');
        echo view('front/include/footer');
    }
    /**
     * Track Order End
     */

    /**
     * User dashboard Start
     */
    function my_account()
    {
        if (session()->get('logged_in') == TRUE && session()->get('role') == 'User') {
        } else {
            session()->set('error', "You Dont Have Permission To Access This Page");
            return redirect()->to('/');
        }
    }
    /**
     * User dashboard End
     */

    /**
     * Errro 404 page start
     */
    function error404()
    {
        $setting = new SettingModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = $data['app_setting']->app_meta_title;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        echo view('front/include/header', $data);
        echo view('front/error_404');
        echo view('front/include/footer');
    }
    /**
     * Errro 404 page End
     */


    /**
     * Get Address Data Section Start
     */
    function get_country()
    {
        helper('curl_helper');

        $url = "https://geodata.phplift.net/api/index.php?type=getCountries";
        $response = call_curl($url);

        if ($response['result']) {
            $option = '<option value="">Select From List</option>';
            foreach ($response['result'] as $result) {
                $option .= '<option data-id="' . $result['id'] . '" value="' . $result['name'] . '">' . $result['name'] . '</option>';
            }
        } else {
            $option = '<option value="">No Data Found</option>';
        }
        echo $option;
    }
    function get_state()
    {
        helper('curl_helper');
        $country_id = $_GET['country'];
        $url = "https://geodata.phplift.net/api/index.php?type=getStates&countryId=" . $country_id;
        $response = call_curl($url);

        if ($response['result']) {
            $option = '<option value="">Select From List</option>';
            foreach ($response['result'] as $result) {
                $option .= '<option data-id="' . $result['id'] . '" value="' . $result['name'] . '">' . $result['name'] . '</option>';
            }
        } else {
            $option = '<option value="">No Data Found</option>';
        }

        echo $option;
    }
    function get_city()
    {
        helper('curl_helper');
        $country_id = $_GET['country'];
        $state_id = $_GET['state'];
        $url = "https://geodata.phplift.net/api/index.php?type=getCities&countryId=" . $country_id . '&stateId=' . $state_id;
        $response = call_curl($url);

        if ($response['result']) {
            $option = '<option value="">Select From List</option>';
            foreach ($response['result'] as $result) {
                $option .= '<option data-id="' . $result['id'] . '" value="' . $result['name'] . '">' . $result['name'] . '</option>';
            }
        } else {
            $option = '<option value="">No Data Found</option>';
        }

        echo $option;
    }
    /**
     * Get Address Data Section End
     */

    /**
     * Check Mobile Exists or not
     */
    function check_mobile_avaliblity()
    {
        $user = new UserModel();
        $mobile = $this->request->getVar('mobile');
        echo $user->check_mobile_avaliblity($mobile);
    }

    /**
     * Check Email Exists or not
     */
    function check_email_avaliblity()
    {
        $user = new UserModel();
        $email = $this->request->getVar('email');
        echo $user->check_email_avaliblity($email);
    }

    /**
     * Add New Author
     */
    function author_registartion()
    {
        $user = new UserModel();

        if ($user->check_mobile_avaliblity($this->request->getVar('user_mobile'))) {
            session()->set('error', "Mobile No Already Exists.");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        if ($this->request->getVar('user_email')) {
            if ($user->check_email_avaliblity($this->request->getVar('user_email'))) {
                session()->set('error', "Email ID Already Exists.");
                // return redirect()->to($this->request->getUserAgent()->getReferrer());
            }
        }

        $data['user_name']          = $this->request->getVar('user_name');
        $data['user_slug']          = slug($this->request->getVar('user_name'));
        $data['user_email']         = $this->request->getVar('user_email');
        $data['user_mobile']        = $this->request->getVar('user_mobile');
        $data['user_role']          = 'Author';
        $data['user_status']        = 0;
        $data['user_created_at']    = date('Y-m-d');

        if ($this->request->getFile('user_image')->isValid() && !$this->request->getFile('user_image')->hasMoved()) {
            $image_1 = $this->request->getFile('user_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['user_image'] = $webpPath_1;
                unlink($source_1);
            }
        }

        if ($user->add_user($data)) {
            session()->set('success', "Registration Successfully Complete. Please Wait For Account Approval");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Employee Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Help for Author
     */
    function help_for_author()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $setting->get_help_for_author_data();
        echo view('front/include/header', $data);
        echo view('front/help_for_author');
        echo view('front/include/footer');
    }

    /**
     * print your book
     */
    function print_your_book()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $setting->get_print_your_book_data_by_id(1);
        echo view('front/include/header', $data);
        echo view('front/print_your_book');
        echo view('front/include/footer');
    }

    /**
     * publish your book
     */
    function publish_your_book()
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $setting->get_print_your_book_data_by_id(2);
        echo view('front/include/header', $data);
        echo view('front/publish_your_book');
        echo view('front/include/footer');
    }

    /**
     * Magazone
     */
    function all_magazine()
    {
        $setting = new SettingModel();
        $product = new ProductModel();

        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_data']               = $product->get_all_magazine_for_home();
        // echo '<pre>';
        // print_r($data['all_data']);
        echo view('front/include/header', $data);
        echo view('front/all_magazine');
        echo view('front/include/footer');
    }

    function magazine_edition($slug, $id)
    {
        $setting = new SettingModel();
        $product = new ProductModel();

        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_data']               = $product->get_all_edition_by_magazine_id($id);
        echo view('front/include/header', $data);
        echo view('front/all_edition');
        echo view('front/include/footer');
    }
    /**
     * Dynamic URL by Slug Start
     */
    public function any($slug)
    {
        $slug = slug($slug);
        if (empty($slug)) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $blog = new BlogModel();
        $category = $blog->get_category_by_slug($slug);
        if ($category) {
            $this->blog_category($category);
        } else {
            $post = $blog->get_blog_by_slug($slug);
            if ($post) {
                $this->blog_details($post);
            } else {
                $product = new ProductModel();
                $prd_cat = $product->get_category_by_slug($slug);
                if ($prd_cat) {
                    $this->prd_cat_details($prd_cat);
                } else {
                    $prd_details = $product->get_product_by_slug($slug);
                    if ($prd_details) {
                        $this->product_details($prd_details);
                    } else {
                        $home    = new HomeModel();
                        $pageDetails = $home->get_page_by_slug($slug);
                        if ($pageDetails) {
                            $this->page_details($pageDetails);
                        } else {
                            $setting    = new SettingModel();
                            $eventDetails = $setting->get_event_by_slug($slug);
                            if ($eventDetails) {
                                $this->event_details($eventDetails);
                            } else {
                                $this->error404();
                            }
                        }
                    }
                }
            }
        }
    }
    /**
     * Dynamic URL by Slug End
     */
}
