<?php

if (!function_exists('call_curl')) {
    /**
     * cURL request helper function
     * 
     * @param string $url
     * @param array $postData
     * @param array $headers
     * @param string $method (GET, POST, PUT, DELETE)
     * @return mixed
     */
    function call_curl($url, $postData = [], $headers = [], $method = 'GET')
    {
        $curl = curl_init();
        
        // Set curl options
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        
        // If headers are passed
        if (!empty($headers)) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }

        // Check if the method is POST or others with body data
        if ($method == 'POST' || $method == 'PUT' || $method == 'DELETE') {
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postData));
        }
        
        // Execute the request
        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        
        // Close the cURL session
        curl_close($curl);
        
        // Optionally return the response or handle errors
        if ($httpCode >= 200 && $httpCode < 300) {
            return json_decode($response, true);
        } else {
            return ['error' => 'Request failed with status code ' . $httpCode];
        }
    }
}
