<?php

/**
 * Back End CSS Start 
 */
if (!function_exists('admin_css')) {
    function admin_css()
    {
        return base_url() . "back/";
    }
}
/**
 * Back End CSS End 
 */

/**
 * Front CSS Start 
 */

if (!function_exists('front_css')) {
    function front_css()
    {
        return base_url() . "front/";
    }
}

/**
 * Front CSS End 
 */

/**
 * Admin Panel URL Start
 */
if (!function_exists('admin_url')) {
    function admin_url()
    {
        return base_url() . "admin/";
    }
}
/**
 * Admin Panel URL End
 */

/**
 * get logged user Details Start
 */
if (!function_exists('user')) {
    function user()
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_logged_user();
        if (empty($user)) {
            $auth->logout();
        } else {
            return $user;
        }
    }
}
/**
 * get logged user Details End
 */

/**
 * Get User Data Start
 */
if (!function_exists('get_user_by_id')) {
    function get_user_by_id($id)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_id($id);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}

if (!function_exists('get_user_by_mobile')) {
    function get_user_by_mobile($mobile)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_mobile($mobile);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}

if (!function_exists('get_user_by_email')) {
    function get_user_by_email($email)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_email($email);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}

if (!function_exists('get_user_by_code')) {
    function get_user_by_code($code)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_code($code);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}
/**
 * Get User Data End
 */

/**
 * Check user Image Avaliable or Not Start
 */
if (!function_exists('check_image')) {
    function check_image($url)
    {
        if (file_exists($url)) {
            return base_url() . $url;
        } else {
            return base_url() . 'back/avatar.jpg';
        }
    }
}
/**
 * Check user Image Avaliable or Not End
 */

/**
 * Custom Message Section Start 
 */
if (!function_exists('get_greeting_message')) {
    function get_greeting_message()
    {
        $current_hour = date('G');

        // Initialize the greeting message
        $greeting_message = '';

        // Define the range of hours for different greetings
        if ($current_hour >= 5 && $current_hour < 12) {
            $greeting_message = '&#x1F305; Good Morning! Start your day with a smile 😊'; // Sun emoji
        } elseif ($current_hour >= 12 && $current_hour < 18) {
            $greeting_message = '🌞 Good Afternoon! Hope your day is going great! Keep up the energy 💪'; // Sun with face emoji
        } elseif ($current_hour >= 18 && $current_hour < 24) {
            $greeting_message = '&#x1F31C; Good Evening! Time to relax and unwind 🌇'; // Moon emoji
        } else {
            $greeting_message = '&#x1F31B; Good Night! Rest well and recharge for tomorrow 🌙'; // Crescent moon emoji
        }

        return $greeting_message;
    }
}

/**
 * Custom Message Section End 
 */

/**
 * Check Member Adding Permission Start
 */
if (!function_exists('check_admin_permission')) {
    function check_admin_permission()
    {
        if (user()->user_role == 'Member') {
            $permission = 0;
        } else {
            $permission = 1;
        }

        return $permission;
    }
}
/**
 * Check Member Adding Permission End
 */

/**
 * generate Random Number Start
 */
if (!function_exists('generateRandomString')) {
    function generateRandomString($length)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}
/**
 * generate Random Number Start
 */

/**
 * generate Slug Start
 */
if (!function_exists('slug')) {
    function slug($string, $separator = '-')
    {
        if (is_null($string)) {
            return "";
        }
        $string = trim($string);
        $string = preg_replace("/[\s-]+/", " ", $string);
        $string = preg_replace("/[\s_]/", $separator, $string);

        return $string;
    }
}
/**
 * generate Slug Start
 */

if (!function_exists('generate_form')) {
    function generate_form($action, $fields = [], $submit_label = 'Submit')
    {
        $form = form_open_multipart($action, ['class' => 'needs-validation', 'novalidate']); // Initialize form
        $form .= "<div class='row gy-4 gy-sm-1'>"; // Start of row

        foreach ($fields as $field) {
            $label = $field['label'];
            $name = esc($field['name']);
            $type = esc($field['type']);
            $placeholder = esc($field['placeholder']);
            $required = isset($field['required']) && $field['required'] ? 'required' : ''; // Check if field is required
            $value = isset($field['value']) ? esc($field['value']) : '';
            $id = isset($field['id']) ? esc($field['id']) : esc($field['name']);
            $col_class = isset($field['col_class']) ? esc($field['col_class']) : 'col-md-6'; // Default column class

            // Add asterisk for required fields
            $asterisk = isset($field['required']) && $field['required'] ? '<span class="text-danger">*</span>' : '';

            // Generate input field based on type
            switch ($type) {
                case 'text':
                case 'email':
                case 'password':
                case 'number':
                case 'url':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <div>
                                    <label for='$id' class='form-label'>$label $asterisk</label>
                                    <input type='$type' class='form-control' id='$id' name='$name' value='$value' $required' placeholder='$placeholder'>
                                </div>
                            </div>
                        </div>";
                    break;

                case 'textarea':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <div>
                                    <label for='$id' class='form-label'>$label $asterisk</label>
                                    <textarea placeholder='$placeholder' class='form-control' id='$id' name='$name' $required>$value</textarea>
                                </div>
                            </div>
                        </div>";
                    break;

                case 'select':
                    $options = isset($field['options']) ? $field['options'] : [];
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <div>
                                    <label for='$id' class='form-label'>$label $asterisk</label>
                                    <select class='form-select' id='$id' name='$name' $required>
                                        <option value=''>Choose...</option>";
                    foreach ($options as $option) {
                        $form .= "<option value='" . esc($option['value']) . "' " . ($value == $option['value'] ? 'selected' : '') . ">" . esc($option['text']) . "</option>";
                    }
                    $form .= "
                                    </select>
                                </div>
                            </div>
                        </div>";
                    break;

                case 'checkbox':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <div>
                                    <div class='form-check'>
                                        <input type='checkbox' class='form-check-input' id='$id' name='$name' value='1' $required>
                                        <label class='form-check-label' for='$name'>$label $asterisk</label>
                                    </div>
                                </div>
                            </div>
                        </div>";
                    break;

                case 'datetime-local':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <label for='$id' class='form-label'>$label $asterisk</label>
                                <input type='datetime-local' class='form-control' id='$id' name='$name' value='$value' $required>
                            </div>
                        </div>";
                    break;

                case 'date':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <label for='$id' class='form-label'>$label $asterisk</label>
                                <input type='date' class='form-control' id='$id' name='$name' value='$value' $required>
                            </div>
                        </div>";
                    break;
                case 'time':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <label for='$id' class='form-label'>$label $asterisk</label>
                                <input type='time' class='form-control' id='$id' name='$name' value='$value' $required>
                            </div>
                        </div>";
                    break;
                case 'file':
                    $form .= "
                        <div class='$col_class'>
                            <div class='mb-2'>
                                <label for='$id' class='form-label'>$label $asterisk</label>
                                <input type='file' class='form-control' id='$id' name='$name' $required>
                            </div>
                        </div>";
                    break;

                default:
                    break;
            }
        }

        $form .= "</div>"; // End of row
        $form .= "
        <div class='col-sm-12 col-lg-12 text-center mt-3'>
            <button type='submit' class='btn btn-primary'>$submit_label</button>
        </div>";
        $form .= form_close(); // Close form

        return $form;
    }
}

function timeAgo($timestamp)
{
    $timeAgo = time() - strtotime($timestamp); // Current time - timestamp
    if ($timeAgo < 60) {
        return 'just now';
    } elseif ($timeAgo < 3600) {
        $minutes = floor($timeAgo / 60);
        return $minutes . ' min' . ($minutes > 1 ? 's' : '') . ' ago';
    } elseif ($timeAgo < 86400) {
        $hours = floor($timeAgo / 3600);
        return $hours . ' hr' . ($hours > 1 ? 's' : '') . ' ago';
    } elseif ($timeAgo < 604800) {
        $days = floor($timeAgo / 86400);
        return $days . ' day' . ($days > 1 ? 's' : '') . ' ago';
    } else {
        // If more than a week ago, return the date
        return date('M j, Y', strtotime($timestamp));
    }
}

function encryptData($data, $key)
{
    $cipherMethod = 'AES-256-CBC';
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($cipherMethod));
    $compressedData = gzcompress(json_encode($data)); // Compress data
    $encrypted = openssl_encrypt($compressedData, $cipherMethod, $key, 0, $iv);
    return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($iv . $encrypted));
}


function decryptData($encryptedData, $key)
{
    $cipherMethod = 'AES-256-CBC';
    $encryptedData = str_replace(['-', '_'], ['+', '/'], $encryptedData); // Reverse URL-safe encoding
    $cipherData = base64_decode($encryptedData);
    $ivLength = openssl_cipher_iv_length($cipherMethod);
    $iv = substr($cipherData, 0, $ivLength);
    $encryptedText = substr($cipherData, $ivLength);
    $decryptedCompressed = openssl_decrypt($encryptedText, $cipherMethod, $key, 0, $iv);
    return json_decode(gzuncompress($decryptedCompressed), true); // Decompress data
}

function youtubeBanner($pageVideUrl)
{
    $link = $pageVideUrl;
    $video_id = explode("?v=", $link);
    if (!isset($video_id[1])) {
        $video_id = explode("youtu.be/", $link);
    }
    $youtubeID = $video_id[1];
    if (empty($video_id[1])) $video_id = explode("/v/", $link);
    $video_id = explode("&", $video_id[1]);
    $youtubeVideoID = $video_id[0];
    if ($youtubeVideoID) {
        return 'https://img.youtube.com/vi/' . $youtubeVideoID . '/mqdefault.jpg';
    } else {
        return false;
    }
}

if (!function_exists('name')) {
    function name($String, $separator = '-')
    {
        if (is_null($String)) {
            return "";
        }

        return preg_replace('/[^a-zA-Z0-9_ %\[\]\.\(\)%&-]/s', '', $String);
    }
}

if (!function_exists('banner_image')) {
    function banner_image($keyID)
    {
        $setting = new \App\Models\SettingModel;
        $image = $setting->get_front_banner_by_id($keyID);
        $content = '';
        if ($image && file_exists($image->banner_image)) {
            $content = '<section class="cta-banner-section fix section-padding pt-10">
                <div class="container">
                    <img src="' . base_url($image->banner_image) . '" class="img w-100" alt="' . $image->banner_title . '"/>
                </div>
            </section>';
        }
        return $content;
    }
}
if (!function_exists('youtubeEmbed')) {
    function youtubeEmbed($url, $height, $width)
    {
        // Extract YouTube Video ID using regex
        preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/', $url, $matches);

        // Check if a valid ID is found
        if (!empty($matches[1])) {
            $videoID = $matches[1];

            // Return the embed iFrame
            return '<iframe width="'.$height.'" height="'.$width.'" src="https://www.youtube.com/embed/' . $videoID . '" 
                title="YouTube video player" frameborder="0" 
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                allowfullscreen></iframe>';
        } else {
            return "Invalid YouTube URL";
        }
    }
}
