<?php

namespace App\Models;

use CodeIgniter\Model;

class AuthModel extends Model
{
    protected $users = 'users';
    protected $role = 'role_permission';
    protected $db;

    /**
     * 
     */
    function get_user_by_mobile($mobile)
    {
        return $this->db->table($this->users)
            ->where('user_mobile', $mobile)
            ->get()
            ->getRow();
    }

    function get_user_by_email($email)
    {
        return $this->db->table($this->users)
            ->where('user_email', $email)
            ->get()
            ->getRow();
    }

    function get_user_by_mobile_and_password($mobile, $password)
    {
        return $this->db->table($this->users)
            ->where(['user_mobile' => $mobile, 'user_password' => $password])
            ->get()
            ->getRow();
    }
    function update_token($token, $id)
    {
        return $this->db->table($this->users)
            ->where('user_id', $id)
            ->update($token);
    }

    //function get user
    public function get_logged_user()
    {
        if ($this->is_logged_in()) {
            return $this->db->table($this->users)
                ->where('user_id', session()->get('user_id'))
                ->get()
                ->getRow();
        }
    }

    //is logged in
    public function is_logged_in()
    {
        //check if user logged in
        if (
            session()->get('logged_in') == true &&
            !empty($this->get_user_by_id(session()->get('user_id')))
        ) {
            return true;
        } else {
            return false;
        }
    }

    //is logged in
    public function check_session()
    {
        if (session()->get('user_id')) {
            $data = $this->get_user_by_id(session()->get('user_id'));
            if (session()->get('user_token') == $data->user_token) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    //get user by id
    public function get_user_by_id($id)
    {
        return $this->db->table($this->users)
            ->where('user_id', $id)
            ->get()
            ->getRow();
    }
    
    //get user by code
    function get_user_by_code($code)
    {
        return $this->db->table($this->users)
            ->where('user_code', $code)
            ->get()
            ->getRow();
    }

    public function logout()
    {
        session_destroy();
        return redirect()->to('login');
    }

    /**
     * Role Permission Setting Start
     */
    function get_all_role_permission()
    {
        $user_role = user()->user_role;
        $per = $this->db->table($this->role)
            ->where('role_name', $user_role)
            ->get()
            ->getRow();
        return json_decode($per->permission, true);
    }
    /**
     * Role Permission Setting End 
     */
}
