<?php

namespace App\Models;

use CodeIgniter\Model;

class HomeModel extends Model
{
    protected $db;
    protected $home_slider                  = 'home_slider';
    protected $extra_page                   = 'home_extra_pages';
    protected $home_testimonials            = 'home_testimonials';
    protected $home_banner                  = 'home_banner';


    //get slider by id 
    function get_slider_by_id()
    {
        return $this->db->table($this->home_slider)
            ->where('slider_id', 1)
            ->get()
            ->getRow();
    }

    //update slider
    function update_slider($data, $id)
    {
        return $this->db->table($this->home_slider)
            ->where('slider_id', 1)
            ->update($data);
    }

    // get all extra pages
    function get_all_page()
    {
        return $this->db->table($this->extra_page)
            ->get()
            ->getResult();
    }

    //get extra page by id
    function get_page_by_id($id)
    {
        return $this->db->table($this->extra_page)
            ->where('id', $id)
            ->get()
            ->getRow();
    }

    //get extra page by slug
    function get_page_by_slug($slug)
    {
        return $this->db->table($this->extra_page)
            ->where('slug', $slug)
            ->get()
            ->getRow();
    }

    // add new extra page
    function add_new_page($data)
    {
        return $this->db->table($this->extra_page)
            ->insert($data);
    }

    //update extra page
    function update_page($data, $id)
    {
        return $this->db->table($this->extra_page)
            ->where('id', $id)
            ->update($data);
    }

    // get all extra active pages 
    function get_all_active_page()
    {
        return $this->db->table($this->extra_page)
            ->where('status', 1)
            ->get()
            ->getResult();
    }

    // get all page for home page footer 
    function get_all_page_footer_important()
    {
        return $this->db->table($this->extra_page)
            ->where('important', 'Important')
            ->where('status', 1)
            ->get()
            ->getResult();
    }

    // get all page for home page footer 
    function get_all_page_footer_help()
    {
        return $this->db->table($this->extra_page)
            ->where('important', 'Help')
            ->where('status', 1)
            ->get()
            ->getResult();
    }

    // get all page for home page header 
    function get_all_page_header_top()
    {
        return $this->db->table($this->extra_page)
            ->where('important', 'Top')
            ->where('status', 1)
            ->get()
            ->getResult();
    }

    // delete extra page
    function delete_page($id)
    {
        return $this->db->table($this->extra_page)
            ->where('id', $id)
            ->delete();
    }

    function get_all_banner()
    {
        return $this->db->table($this->home_banner)
            ->get()
            ->getResult();
    }

    function add_banner($data)
    {
        return $this->db->table($this->home_banner)
            ->insert($data);
    }

    function get_banner_by_position($value)
    {
        return $this->db->table($this->home_banner)
            ->where('banner_position', $value)
            ->get()
            ->getResult();
    }

    function get_banner_by_id($id)
    {
        return $this->db->table($this->home_banner)
            ->where('banner_id', $id)
            ->get()
            ->getRow();
    }

    function delete_banner($id)
    {
        return $this->db->table($this->home_banner)
            ->where('banner_id', $id)
            ->delete();
    }

    function update_banner($data, $id)
    {
        return $this->db->table($this->home_banner)
            ->where('banner_id', $id)
            ->update($data);
    }

    
}
