<?php

namespace App\Models;

use CodeIgniter\Model;

class OrderModel extends Model
{
    protected $db;
    protected $order                    = 'order';
    protected $product                  = 'product';
    protected $order_status             = 'order_status';


    // add order
    function add_order($data)
    {
        return $this->db->table($this->order)
            ->insert($data);
    }

    // order status
    function add_order_status($data)
    {
        return $this->db->table($this->order_status)
            ->insert($data);
    }

    // get all order
    function get_all_order($start_date, $end_date)
    {
        $info = $this->db->table($this->order)
            ->join('users', 'users.user_id = order.user_id')
            ->join('user_order_address', 'user_order_address.user_order_address_id = order.address_id')
            ->where('DATE(order.order_date) >=', $start_date)
            ->where('DATE(order.order_date) <=', $end_date)
            ->where('order.user_role', 'User')
            ->where('order.is_online_order', 1)
            ->select('users.user_name, users.user_mobile, users.user_email, user_order_address.*, order.order_id, order.order_date, order.order_status, order.order_tracking_code, order.user_id, order.invoice_id, order.user_role, order.paymen_method, order.order_payment_id ')
            ->groupBy('order.invoice_id')
            ->selectSum('order.order_price')
            ->selectSum('order.tax_price')
            ->selectSum('order.shipping_charge')
            ->selectSum('order.discount_amt')
            ->get();
        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {
                $info = $this->db->table($this->order)
                    ->join('product', 'product.prd_id = order.order_prd_id')
                    ->select('order.order_price, order.product_rate, order.order_qnty')
                    ->select('product.prd_name, product.prd_default_image, product.prd_tax')
                    ->where('invoice_id', $row->invoice_id)
                    ->get();
                $row->orders = $info->getResult();


                array_push($final, $row);
            }
        }
        return  $final;
    }

    /**
     * Wishlist
     */
    function get_wishlist_prd_count_by_user_id($user_id)
    {
        return $this->db->table('wishlist')
            ->where('user_id', $user_id)
            ->get()
            ->getNumRows();
    }

    // get last invoice ID
    function get_last_invoice_id()
    {
        return $this->db->table($this->order)
            ->orderBy('order_id', "DESC")
            ->limit(1)
            ->select('invoice_id')
            ->get()
            ->getRow();
    }

    //update order status
    function update_order_status($data, $order_id)
    {
        return $this->db->table($this->order)
            ->where('invoice_id', $order_id)
            ->update($data);
    }

    //get tracking order details
    function get_order_details_for_track_order($id)
    {
        return $this->db->table($this->order)
            ->where('order_tracking_code', $id)
            ->select('invoice_id')
            ->get()
            ->getRow();
    }

    //get order status
    function check_order_status_order_id($id, $status)
    {

        return $this->db->table($this->order_status)
            ->where('order_status_invoice_id', $id)
            ->where('order_status', $status)
            ->get()
            ->getRow();
    }

    function get_order_status_by_invoice_id($id)
    {
        return $this->db->table($this->order_status)
            ->where('order_status_invoice_id', $id)
            ->get()
            ->getResult();
    }

    function check_last_order_status($id)
    {

        return $this->db->table($this->order_status)
            ->where('order_status_invoice_id', $id)
            ->orderBy('id', "DESC")
            ->get()
            ->getRow();
    }

    function get_all_order_details_by_order_id($id)
    {
        return $this->db->table($this->order)
            ->where('order.invoice_id', $id)
            ->join('product', 'product.prd_id = order.order_prd_id')
            ->select('order.order_price, product.prd_name, product.prd_default_image')
            ->get()
            ->getResult();
    }
    
}
