<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductModel extends Model
{
    protected $db;
    protected $product                  = 'product';
    protected $category                 = 'product_category';
    protected $product_image            = 'product_extra_image';
    protected $product_review           = 'product_review';


    /**
     * Product Category Section Start
     */

    function count_all_category()
    {
        return $this->db->table($this->category)
            ->get()
            ->getNumRows();
    }

    function check_name_avaliblity($name)
    {
        return $this->db->table($this->category)
            ->where('category_name', $name)
            ->get()
            ->getRow();
    }

    function get_all_category_and_sub_categopry()
    {
        $builder = $this->db->table($this->category . ' as pc');
        $builder->select('pc.category_id, pc.category_name, pc.category_slug, pc.category_menu_position, pc.category_status, pc.category_type, parent.category_name as parent_menu_name');
        $builder->join($this->category . ' as parent', 'pc.parent_category = parent.category_id', 'left'); // Join to get parent category name
        $builder->where('pc.category_type', 2); // Filter for subcategories
        $builder->orWhere('pc.category_type', 1); // Include main categories
        $query = $builder->get();
        return $query->getResult();
    }

    function get_all_category_and_sub_categopry_for_home_page()
    {
        $info = $this->db->table($this->category)
            ->select('category_id, category_name, category_slug')
            ->where('category_status', 1)
            ->where('category_type', 1)
            ->get();
        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {
                $info =  $this->db->table($this->category)
                    ->select('category_id, category_name, category_slug')
                    ->where('parent_category', $row->category_id)
                    ->where('category_status', 1)
                    ->get();

                $row->sub_category = $info->getResult();

                array_push($final, $row);
            }
        }
        return $final;
    }

    function get_sub_category_by_category_id($id)
    {
        return $this->db->table($this->category)
            ->where('parent_category', $id)
            ->get()
            ->getResult();
    }

    function get_all_category()
    {
        return $this->db->table($this->category)
            ->get()
            ->getResult();
    }

    function get_all_main_category()
    {
        return $this->db->table($this->category)
            ->where('category_type', 1)
            ->get()
            ->getResult();
    }

    function get_category_by_id($id)
    {
        return $this->db->table($this->category)
            ->where('category_id', $id)
            ->get()
            ->getRow();
    }

    function get_category_by_slug($slug)
    {
        return $this->db->table($this->category)
            ->where('category_slug', $slug)
            ->get()
            ->getRow();
    }

    function new_category_add($data)
    {
        return $this->db->table($this->category)->insert($data);
    }

    function update_category($data, $id)
    {
        return $this->db->table($this->category)
            ->where('category_id', $id)
            ->update($data);
    }

    public function check_cat_exits_in_prd($id)
    {
        return $this->db->table('product')
            ->like('prd_category', $id)
            ->orLike('prd_sub_category', $id)
            ->orLike('prd_child_category', $id)
            ->get()
            ->getResult();
    }

    public function check_parent_cat_exits($id)
    {
        return $this->db->table($this->category)
            ->where('parent_category', $id)
            ->get()
            ->getResult();
    }

    function delete_category($id)
    {
        return $this->db->table($this->category)
            ->where('category_id', $id)
            ->delete();
    }

    function change_category_status($data, $id)
    {
        return $this->db->table($this->category)
            ->where('category_id', $id)
            ->update($data);
    }

    function fetch_all_sub_category($id)
    {
        return $this->db->table($this->category)
            ->where('parent_category', $id)
            ->get()
            ->getResult();
    }

    /**
     * Product Section Start
     */

    function get_all_product_for_view_page()
    {
        return $this->db->table($this->product)
            ->join('product_category', 'product_category.category_id = product.prd_category')

            ->select('product_category.category_name, product.*')
            ->get()
            ->getResult();
    }

    function add_new_product($data)
    {
        $this->db->table($this->product)->insert($data);
        return $this->db->insertID();
    }

    function update_product($data, $id)
    {
        return $this->db->table($this->product)
            ->where('prd_id', $id)
            ->update($data);
    }

    function add_extra_product_img($data)
    {
        return $this->db->table($this->product_image)->insert($data);
    }

    function get_extra_product_image_by_prd_id($id)
    {
        return $this->db->table($this->product_image)
            ->where('prd_id', $id)
            ->get()
            ->getResult();
    }

    function get_product_by_id_for_edit_page($id)
    {
        $info = $this->db->table($this->product)
            ->where('prd_id', $id)
            ->get();

        $final = array();
        if ($info->getNumRows() > 0) {
            $img_prd = [];
            $prd_video = [];
            foreach ($info->getResult() as $row) {
                $info = $this->db->table($this->product_image)
                    ->where('prd_id', $row->prd_id)
                    ->get();
                $img_prd = $info->getResult();

                $row->extra_image =  $img_prd;

                array_push($final, $row);
            }
        }
        return  $final[0];
    }

    function delete_product($id)
    {
        return $this->db->table($this->product)
            ->where('prd_id', $id)
            ->delete();
    }

    // get product for tax
    function get_product_by_id_for_tax($id)
    {
        return $this->db->table($this->product)
            ->where('prd_id', $id)
            ->select('prd_tax')
            ->get()
            ->getRow();
    }

    //get product by slug
    function get_product_by_slug($slug)
    {
        $row = $this->db->table($this->product)
            ->where('prd_slug', $slug)
            ->get()
            ->getRow();
        if ($row) {
            $main_tax_price = round(($row->prd_v_sell_price  * $row->prd_tax) / 100);
            $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

            if ($row->prd_v_offer == 1) {
                $org_tax_price = round(($row->prd_v_offer_price  * $row->prd_tax) / 100);
                $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                $ttl_dis_price = $row->mainPrice - $row->org_price;
                $per = ($ttl_dis_price * 100) / $row->mainPrice;
                $row->discount = round($per);
            } else {
                $row->org_price = 0;
                $row->discount = '';
            }
            $row->rating = $this->get_prd_rating_details($row->prd_id);
            $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);
            return $row;
        } else {
            return false;
        }
    }

    //get related product for product details page 
    function get_related_prd_for_prd_details_page_by_cat($cat)
    {
        $info = $this->db->table($this->product)
            ->select('prd_id, prd_name, prd_slug,  prd_default_image, prd_tax, prd_v_buy_price, prd_v_sell_price, prd_v_offer, prd_v_offer_price')
            ->where('prd_status', 1)
            ->where('prd_category', $cat)
            ->limit(8)
            ->get();
        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {

                $main_tax_price = round(($row->prd_v_sell_price  * $row->prd_tax) / 100);
                $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

                if ($row->prd_v_offer == 1) {
                    $org_tax_price = round(($row->prd_v_offer_price  * $row->prd_tax) / 100);
                    $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                    $ttl_dis_price = $row->mainPrice - $row->org_price;
                    $per = ($ttl_dis_price * 100) / $row->mainPrice;
                    $row->discount = round($per);
                } else {
                    $row->org_price = 0;
                    $row->discount = '';
                }
                $row->rating = $this->get_prd_rating_details($row->prd_id);
                $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);
                array_push($final, $row);
            }
        }
        return  $final;
    }

    // home featured book 
    function get_all_featured_books()
    {
        $info = $this->db->table($this->product)
            ->select('prd_id, prd_name, prd_slug,  prd_default_image, prd_tax, prd_v_buy_price, prd_v_sell_price, prd_v_offer, prd_v_offer_price')
            ->where('prd_status', 1)
            ->orderBy('prd_date', "DESC")
            ->limit(6)
            ->get();

        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {

                $main_tax_price = round(($row->prd_v_sell_price  * $row->prd_tax) / 100);
                $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

                if ($row->prd_v_offer == 1) {
                    $org_tax_price = round(($row->prd_v_offer_price  * $row->prd_tax) / 100);
                    $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                    $ttl_dis_price = $row->mainPrice - $row->org_price;
                    $per = ($ttl_dis_price * 100) / $row->mainPrice;
                    $row->discount = round($per);
                } else {
                    $row->org_price = 0;
                    $row->discount = '';
                }
                $row->rating = $this->get_prd_rating_details($row->prd_id);
                $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);
                array_push($final, $row);
            }
        }
        return  $final;
    }

    // home top book
    function get_all_top_books()
    {
        $info = $this->db->table($this->product)
            ->select('prd_id, prd_name, prd_slug,  prd_default_image, prd_tax, prd_v_buy_price, prd_v_sell_price, prd_v_offer, prd_v_offer_price')
            ->where('prd_status', 1)
            ->orderBy('prd_total_visit', "DESC")
            ->limit(8)
            ->get();

        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {

                $main_tax_price = round(($row->prd_v_sell_price  * $row->prd_tax) / 100);
                $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

                if ($row->prd_v_offer == 1) {
                    $org_tax_price = round(($row->prd_v_offer_price  * $row->prd_tax) / 100);
                    $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                    $ttl_dis_price = $row->mainPrice - $row->org_price;
                    $per = ($ttl_dis_price * 100) / $row->mainPrice;
                    $row->discount = round($per);
                } else {
                    $row->org_price = 0;
                    $row->discount = '';
                }
                $row->rating = $this->get_prd_rating_details($row->prd_id);
                $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);
                array_push($final, $row);
            }
        }
        return  $final;
    }

    // home top seling book
    function get_all_top_selling_books()
    {
        $info = $this->db->table($this->product)
            ->select('prd_id, prd_name, prd_slug,  prd_default_image, prd_tax, prd_v_buy_price, prd_v_sell_price, prd_v_offer, prd_v_offer_price')
            ->where('prd_status', 1)
            ->orderBy('prd_total_visit', "DESC")
            ->limit(8)
            ->get();

        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {

                $main_tax_price = round(($row->prd_v_sell_price  * $row->prd_tax) / 100);
                $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

                if ($row->prd_v_offer == 1) {
                    $org_tax_price = round(($row->prd_v_offer_price  * $row->prd_tax) / 100);
                    $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                    $ttl_dis_price = $row->mainPrice - $row->org_price;
                    $per = ($ttl_dis_price * 100) / $row->mainPrice;
                    $row->discount = round($per);
                } else {
                    $row->org_price = 0;
                    $row->discount = '';
                }
                $row->rating = $this->get_prd_rating_details($row->prd_id);
                $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);
                array_push($final, $row);
            }
        }
        return  $final;
    }
    //  home top raring product
    function get_all_top_rating_products($limit = 6)
    {
        // Query to get all active products
        $info = $this->db->table($this->product)
            ->select('prd_id, prd_name, prd_slug, prd_default_image, prd_tax, prd_v_buy_price, prd_v_sell_price, prd_v_offer, prd_v_offer_price')
            ->where('prd_status', 1) // Active products only
            ->get();

        $final = array();

        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {
                // Calculate price including tax
                $main_tax_price = round(($row->prd_v_sell_price * $row->prd_tax) / 100);
                $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

                // Handle discounted price if applicable
                if ($row->prd_v_offer == 1) {
                    $org_tax_price = round(($row->prd_v_offer_price * $row->prd_tax) / 100);
                    $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                    $ttl_dis_price = $row->mainPrice - $row->org_price;
                    $per = ($ttl_dis_price * 100) / $row->mainPrice;
                    $row->discount = round($per);
                } else {
                    $row->org_price = 0;
                    $row->discount = '';
                }

                // Fetch product rating and user count
                $row->rating = $this->get_prd_rating_details($row->prd_id);
                $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);

                // Add to the final array
                array_push($final, $row);
            }

            // Sort products by rating (highest to lowest)
            usort($final, function ($a, $b) {
                return $b->rating <=> $a->rating;
            });

            // Limit the number of products returned
            return array_slice($final, 0, $limit);
        }

        return $final;
    }

    // product selling wise top 8 category
    function get_top_8_category_with_images()
    {
        return $this->db->table('order o')
            ->select('pc.category_id, pc.category_name, pc.category_slug, COUNT(o.order_id) AS total_orders, p.prd_default_image AS product_image')
            ->join('product p', 'o.order_prd_id = p.prd_id')
            ->join('product_category pc', 'p.prd_category = pc.category_id')
            ->groupBy('pc.category_id, pc.category_name, pc.category_slug, p.prd_default_image')
            ->orderBy('total_orders', 'DESC')
            ->limit(8)
            ->get()
            ->getResult();
    }



    /**
     * Product Rating & reviews
     */
    function get_prd_rating_details($prd_id)
    {
        $status =  $this->db->table($this->product_review)
            ->where('product_review.product_id', $prd_id)
            ->where('product_review.status', 1)
            ->get()
            ->getResult();
        if ($status) {
            $five_star_rat =  $this->db->table($this->product_review)
                ->where('product_review.product_id', $prd_id)
                ->where('product_review.status', 1)
                ->where('product_review.rate', 5)
                ->get()
                ->getNumRows();
            $four_start_rat =  $this->db->table($this->product_review)
                ->where('product_review.product_id', $prd_id)
                ->where('product_review.status', 1)
                ->where('product_review.rate', 4)
                ->get()
                ->getNumRows();
            $three_start_rat =  $this->db->table($this->product_review)
                ->where('product_review.product_id', $prd_id)
                ->where('product_review.status', 1)
                ->where('product_review.rate', 3)
                ->get()
                ->getNumRows();
            $two_start_rat =  $this->db->table($this->product_review)
                ->where('product_review.product_id', $prd_id)
                ->where('product_review.status', 1)
                ->where('product_review.rate', 2)
                ->get()
                ->getNumRows();
            $one_start_rat =  $this->db->table($this->product_review)
                ->where('product_review.product_id', $prd_id)
                ->where('product_review.status', 1)
                ->where('product_review.rate', 1)
                ->get()
                ->getNumRows();

            $rrr =  (5 * $five_star_rat + 4 * $four_start_rat + 3 * $three_start_rat + 2 * $two_start_rat + 1 * $one_start_rat) / ($five_star_rat + $four_start_rat + $three_start_rat + $two_start_rat + $one_start_rat);


            return $rrr * 100 / 5;
        } else {
            return 0;
        }
    }

    function get_prd_rating_user_count_details($prd_id)
    {
        $status =  $this->db->table($this->product_review)
            ->where('product_review.product_id', $prd_id)
            ->where('product_review.status', 1)
            ->get()
            ->getNumRows();
        if ($status) {
            return $status;
        } else {
            return 0;
        }
    }

    // get product by category id
    function get_prd_by_cat_id($cat)
    {
        $info = $this->db->table($this->product)
            ->select('prd_id, prd_name, prd_slug,  prd_default_image, prd_tax, prd_v_buy_price, prd_v_sell_price, prd_v_offer, prd_v_offer_price')
            ->where('prd_status', 1)
            ->where('prd_category', $cat)
            ->get();
        $final = array();
        if ($info->getNumRows() > 0) {
            foreach ($info->getResult() as $row) {

                $main_tax_price = round(($row->prd_v_sell_price  * $row->prd_tax) / 100);
                $row->mainPrice = $row->prd_v_sell_price + $main_tax_price;

                if ($row->prd_v_offer == 1) {
                    $org_tax_price = round(($row->prd_v_offer_price  * $row->prd_tax) / 100);
                    $row->org_price = $row->prd_v_offer_price + $org_tax_price;

                    $ttl_dis_price = $row->mainPrice - $row->org_price;
                    $per = ($ttl_dis_price * 100) / $row->mainPrice;
                    $row->discount = round($per);
                } else {
                    $row->org_price = 0;
                    $row->discount = '';
                }
                $row->rating = $this->get_prd_rating_details($row->prd_id);
                $row->rating_user = $this->get_prd_rating_user_count_details($row->prd_id);
                array_push($final, $row);
            }
        }
        return  $final;
    }

    // check if author exists or not
    function check_author_exists_in_product($id)
    {
        return $this->db->table($this->product)
            ->where('prd_author_id', $id)
            ->get()
            ->getNumRows();
    }

    /**
     * Magazine Section Start
     */
    function get_all_magazine()
    {
        return $this->db->table('magazine')
            ->get()
            ->getResult();
    }

    public function get_all_magazine_for_home()
    {
        return $this->db->table('magazine')
            ->select('magazine.*, magazine_edition.magazine_edition_id, magazine_edition.magazine_edition_name, 
                      magazine_edition.magazine_edition_image, magazine_edition.magazine_edition_pdf')
            ->join('magazine_edition', 'magazine.magazine_id = magazine_edition.magazine_edition_magazine_id')
            ->where('magazine_edition.magazine_edition_id = (
                SELECT MAX(magazine_edition_id) 
                FROM magazine_edition 
                WHERE magazine_edition.magazine_edition_magazine_id = magazine.magazine_id
            )', null, false) // Subquery to get the latest edition per magazine
            ->get()
            ->getResult();
    }
    

    function get_magazine_by_id($id)
    {
        return $this->db->table('magazine')
            ->where('magazine_id', $id)
            ->get()
            ->getRow();
    }

    function add_magazine($data)
    {
        return $this->db->table('magazine')
            ->insert($data);
    }

    function update_magazine($data, $id)
    {
        return $this->db->table('magazine')
            ->where('magazine_id', $id)
            ->update($data);
    }

    function delete_magazine($id)
    {
        return $this->db->table('magazine')
            ->where('magazine_id', $id)
            ->delete();
    }

    function get_all_edition()
    {
        return $this->db->table('magazine_edition')
            ->join('magazine', 'magazine.magazine_id = magazine_edition.magazine_edition_magazine_id')
            ->orderBy('magazine_edition_order_by', "ASC")
            ->get()
            ->getResult();
    }

    function get_all_edition_by_magazine_id($id)
    {
        return $this->db->table('magazine_edition')
            ->join('magazine', 'magazine.magazine_id = magazine_edition.magazine_edition_magazine_id')
            ->orderBy('magazine_edition_order_by', "ASC")
            ->where('magazine_edition_magazine_id', $id)
            ->get()
            ->getResult();
    }

    function get_edition_by_id($id)
    {
        return $this->db->table('magazine_edition')
            ->where('magazine_edition_id', $id)
            ->get()
            ->getRow();
    }

    function add_edition($data)
    {
        return $this->db->table('magazine_edition')
            ->insert($data);
    }

    function update_edition($data, $id)
    {
        return $this->db->table('magazine_edition')
            ->where('magazine_edition_id', $id)
            ->update($data);
    }

    function delete_edition($id)
    {
        return $this->db->table('magazine_edition')
            ->where('magazine_edition_id', $id)
            ->delete();
    }

    /**
     * Magazine Section End
     */
}
