<?php

namespace App\Models;

use CodeIgniter\Model;

class SettingModel extends Model
{
    protected $setting = 'application_setting';
    protected $visual_setting = 'visual_setting';
    protected $coupon_code = 'coupon_code';
    protected $role = 'role_permission';
    protected $menu = 'menu';
    protected $contact = 'contact_us';
    protected $banner = 'front_banner';
    protected $event = 'event';
    protected $db;

    // get application setting
    function get_application_setting()
    {
        return $this->db->table($this->setting)
            ->where('app_id', 1)
            ->get()
            ->getRow();
    }

    //update application setting
    function update_application_setting($data)
    {
        return $this->db->table($this->setting)
            ->where('app_id', 1)
            ->update($data);
    }

    function get_all_support_department()
    {
        return $this->db->table('role_permission')
            ->select('id, role_name')
            ->where('support_ticket', 1)
            ->where('role_name !=', 'Admin')
            ->get()
            ->getResult();
    }

    function add_new_ticket($data)
    {
        return $this->db->table('support_ticket')
            ->insert($data);
    }

    function add_new_support_ticket_comment($data)
    {
        return $this->db->table('support_ticket_comment')
            ->insert($data);
    }

    function get_all_support_ticket_by_user_id($user_id)
    {
        return $this->db->table('support_ticket')
            ->join('role_permission', 'role_permission.id = support_ticket.department')
            ->select('support_ticket.*, role_permission.role_name')
            ->where('support_ticket.user_id', $user_id)
            ->get()
            ->getResult();
    }

    function all_support_ticket_comment($ticket_id)
    {
        return $this->db->table('support_ticket_comment')
            ->where('ticket_id', $ticket_id)
            ->get()
            ->getResult();
    }

    function get_all_support_ticket()
    {
        return $this->db->table('support_ticket')
            ->join('users', 'users.user_id = support_ticket.user_id')
            ->join('role_permission', 'role_permission.id = support_ticket.department')
            ->select('support_ticket.*, role_permission.role_name, users.user_name')
            ->get()
            ->getResult();
    }

    function get_all_support_ticket_by_role_id_num_rows($staus)
    {
        return $this->db->table('support_ticket')
            ->select('status')
            ->where('status', $staus)
            ->get()
            ->getNumRows();
    }

    function change_support_status($data, $id)
    {
        return $this->db->table('support_ticket')
            ->where('id', $id)
            ->update($data);
    }

    function support_ticket_by_ticket_id($ticket_id)
    {
        return $this->db->table('support_ticket')
            ->where('rand_id', $ticket_id)
            ->get()
            ->getRow();
    }

    //get all menu & sub menu
    public function getAllMenuAndSubMenu()
    {
        $db = \Config\Database::connect();

        // Get all main menus
        $menuTable = $db->table('menu');
        $allMenus = $menuTable
            ->where('is_main_menu', 1)
            ->orderBy('menu_order_by', 'ASC')
            ->get()
            ->getResult();

        $final = [];

        foreach ($allMenus as $menu) {
            // Get all submenus for the current main menu
            $subMenuTable = $db->table('menu');
            $subMenus = $subMenuTable
                ->where('main_menu_id', $menu->menu_id)
                ->get()
                ->getResult();

            // Attach submenus to the main menu
            $menu->sub_menu = $subMenus;

            // Add the menu to the final array
            $final[] = $menu;
        }

        return $final;
    }

    /**
     * Coupon Section start
     */
    function get_all_coupon_code()
    {
        return $this->db->table($this->coupon_code)
            ->get()
            ->getResult();
    }

    function check_coupon_code_by_name($name)
    {
        return $this->db->table($this->coupon_code)
            ->where('coupon_code', $name)
            ->get()
            ->getRow();
    }

    function update_coupon_count($name, $data)
    {
        return $this->db->table($this->coupon_code)
            ->where('coupon_code', $name)
            ->update($data);
    }

    function add_coupon($data)
    {
        return $this->db->table($this->coupon_code)
            ->insert($data);
    }

    function delete_coupon($id)
    {
        return $this->db->table($this->coupon_code)
            ->where('coupon_id', $id)
            ->delete();
    }

    function get_coupon_by_id($id)
    {
        return $this->db->table($this->coupon_code)
            ->where('coupon_id', $id)
            ->get()
            ->getRow();
    }

    function update_coupon($data, $id)
    {
        return $this->db->table($this->coupon_code)
            ->where('coupon_id', $id)
            ->update($data);
    }

    /**
     * All menu & Submenu
     */
    function get_all_menu_and_sub_menu()
    {

        $all_menu = $this->db->table($this->menu)
            ->orderBy('menu_order_by', 'ASC')
            ->where('is_main_menu', 1)
            ->get()
            ->getresult();
        $final = [];
        foreach ($all_menu as $key => $sub_menu) {

            $all_sub_menu = $this->db->table($this->menu)
                ->where('main_menu_id', $sub_menu->menu_id)
                ->get()
                ->getResult();
            $sub_menu->sub_menu = $all_sub_menu;
            array_push($final, $sub_menu);
        };
        return $final;
    }
    /**
     * Role Permission
     */
    function get_all_role_permission()
    {
        return $this->db->table($this->role)
            // ->where('role_name', $user_role)
            ->get()
            ->getResult();
    }

    function get_role_permission()
    {
        return $this->db->table($this->role)
            ->where('role_name !=', 'Admin')
            ->get()
            ->getResult();
    }

    function get_permission_by_id($id)
    {
        return $this->db->table($this->role)
            ->where('id', $id)
            ->where('role_name !=', 'Admin')
            ->get()
            ->getRow();
    }

    function check_role_name_exists($name)
    {
        return $this->db->table($this->role)
            ->where('role_name', $name)
            ->get()
            ->getRow();
    }

    function permission_add($role_name)
    {
        $permissions = [];

        // Loop through submitted permission
        foreach ($_POST['permission'] as $menu_name => $submenu_permissions) {
            foreach ($submenu_permissions as $submenu_name => $value) {
                list($menu, $submenu) = explode('|', $submenu_name);
                $menu = str_replace("_", " ", $menu);
                $submenu = str_replace("_", " ", $submenu);

                $permissions[$menu][$submenu] = 1;
            }
        }

        $all_menu = $this->get_all_menu_and_sub_menu();
        // Loop through all menus to ensure all submenu permissions are set
        foreach ($all_menu as $menu) {
            $menu_name = $menu->menu_name;

            // Initialize submenu permissions for the menu
            if (!isset($permissions[$menu_name])) {
                $permissions[$menu_name] = [];
            }

            // Loop through submenus of the current menu
            foreach ($menu->sub_menu as $submenu) {
                $submenu_name = $submenu->menu_name;

                // Set the permission to 0 if not selected
                if (!isset($permissions[$menu_name][$submenu_name])) {
                    $permissions[$menu_name][$submenu_name] = 0;
                }
            }
        }

        // Output the permissions in the desired format
        $output = [];
        foreach ($permissions as $menu_name => $submenus) {
            $submenuStrings = [];
            foreach ($submenus as $submenu_name => $selected) {
                $submenuStrings[] = "\"{$submenu_name}\":{$selected}";
            }
            $output[] = "\"{$menu_name}\":{" . implode(', ', $submenuStrings) . "}";
        }

        // Output the result
        $data['permission'] = "{" . implode(', ', $output) . "}";
        $data['role_name'] = $role_name;

        return $this->db->table($this->role)
            ->insert($data);
    }

    function update_permission($id)
    {
        $permissions = [];

        // Loop through submitted permission
        foreach ($_POST['permission'] as $menu_name => $submenu_permissions) {
            foreach ($submenu_permissions as $submenu_name => $value) {
                list($menu, $submenu) = explode('|', $submenu_name);
                $menu = str_replace("_", " ", $menu);
                $submenu = str_replace("_", " ", $submenu);

                $permissions[$menu][$submenu] = 1;
            }
        }

        $all_menu = $this->get_all_menu_and_sub_menu();
        // Loop through all menus to ensure all submenu permissions are set
        foreach ($all_menu as $menu) {
            $menu_name = $menu->menu_name;

            // Initialize submenu permissions for the menu
            if (!isset($permissions[$menu_name])) {
                $permissions[$menu_name] = [];
            }

            // Loop through submenus of the current menu
            foreach ($menu->sub_menu as $submenu) {
                $submenu_name = $submenu->menu_name;

                // Set the permission to 0 if not selected
                if (!isset($permissions[$menu_name][$submenu_name])) {
                    $permissions[$menu_name][$submenu_name] = 0;
                }
            }
        }

        // Output the permissions in the desired format
        $output = [];
        foreach ($permissions as $menu_name => $submenus) {
            $submenuStrings = [];
            foreach ($submenus as $submenu_name => $selected) {
                $submenuStrings[] = "\"{$submenu_name}\":{$selected}";
            }
            $output[] = "\"{$menu_name}\":{" . implode(', ', $submenuStrings) . "}";
        }

        // Output the result
        $data['permission'] = "{" . implode(', ', $output) . "}";
        // $data['role_name'] = $this->input->post('role_name');

        return $this->db->table($this->role)
            ->where('id', $id)
            ->update($data);
    }

    function delete_permission($id)
    {
        return $this->db->table($this->role)
            ->where('id', $id)
            ->delete();
    }

    /**
     * Contact Info 
     */
    function get_all_contact_info()
    {
        return $this->db->table($this->contact)
            ->get()
            ->getResult();
    }

    /**
     * Delivery System
     */
    function delivery_system($data)
    {
        return $this->db->table($this->setting)
            ->where('app_id', 1)
            ->update($data);
    }

    /**
     * Font Setting
     */

    // heading
    function get_all_section_heading()
    {
        return $this->db->table('section_heading')
            ->where('heading_id', 1)
            ->get()
            ->getRow();
    }

    // update heading
    function update_heading($data)
    {
        return $this->db->table('section_heading')
            ->where('heading_id', 1)
            ->update($data);
    }

    //all slider
    function get_all_slider()
    {
        return $this->db->table('slider')
            ->get()
            ->getResult();
    }

    // add slider
    function add_slider($data)
    {
        return $this->db->table('slider')
            ->insert($data);
    }

    //get slider by id
    function get_slider_by_id($id)
    {
        return $this->db->table('slider')
            ->where('slider_id', $id)
            ->get()
            ->getRow();
    }

    //update slider
    function update_slider($data, $id)
    {
        return $this->db->table('slider')
            ->where('slider_id', $id)
            ->update($data);
    }

    //delete slider
    function delete_slider($id)
    {
        return $this->db->table('slider')
            ->where('slider_id', $id)
            ->delete();
    }

    // all front banner
    function get_all_front_banner()
    {
        return $this->db->table('front_banner')
            ->get()
            ->getResult();
    }

    //get banner by id
    function get_front_banner_by_id($id)
    {
        return $this->db->table('front_banner')
            ->where('banner_id', $id)
            ->get()
            ->getRow();
    }

    //update banner by id
    function update_banner($data, $id)
    {
        return $this->db->table('front_banner')
            ->where('banner_id', $id)
            ->update($data);
    }

    //all testimonial
    function get_all_testimonial()
    {
        return $this->db->table('testimonial')
            ->get()
            ->getResult();
    }

    // add testimonial
    function add_testimonial($data)
    {
        return $this->db->table('testimonial')
            ->insert($data);
    }

    //get testimonial by id
    function get_testimonial_by_id($id)
    {
        return $this->db->table('testimonial')
            ->where('testimonial_id', $id)
            ->get()
            ->getRow();
    }

    //update testimonial
    function update_testimonial($data, $id)
    {
        return $this->db->table('testimonial')
            ->where('testimonial_id', $id)
            ->update($data);
    }

    //delete testimonial
    function delete_testimonial($id)
    {
        return $this->db->table('testimonial')
            ->where('testimonial_id', $id)
            ->delete();
    }

    //all Our Team
    function get_all_our_team()
    {
        return $this->db->table('about_our_team')
            ->get()
            ->getResult();
    }

    // add testimonial
    function add_our_team($data)
    {
        return $this->db->table('about_our_team')
            ->insert($data);
    }

    //get testimonial by id
    function get_our_team_by_id($id)
    {
        return $this->db->table('about_our_team')
            ->where('aot_id', $id)
            ->get()
            ->getRow();
    }

    //update testimonial
    function update_our_team($data, $id)
    {
        return $this->db->table('about_our_team')
            ->where('aot_id', $id)
            ->update($data);
    }

    //delete testimonial
    function delete_our_team($id)
    {
        return $this->db->table('about_our_team')
            ->where('aot_id', $id)
            ->delete();
    }

    //all pages
    function get_all_page()
    {
        return $this->db->table('home_extra_pages')
            ->get()
            ->getResult();
    }

    //get page by id
    function get_page_by_id($id)
    {
        return $this->db->table('home_extra_pages')
            ->where('id', $id)
            ->get()
            ->getRow();
    }

    //get page by slug
    function get_page_by_slug($slug)
    {
        return $this->db->table('home_extra_pages')
            ->where('slug', $slug)
            ->get()
            ->getRow();
    }

    // add page
    function add_page($data)
    {
        return $this->db->table('home_extra_pages')
            ->insert($data);
    }

    // update page
    function update_page($data, $id)
    {
        return $this->db->table('home_extra_pages')
            ->where('id', $id)
            ->update($data);
    }

    // delete page
    function delete_page($id)
    {
        return $this->db->table('home_extra_pages')
            ->where('id', $id)
            ->delete();
    }

    //get all event
    function get_all_event()
    {
        return $this->db->table($this->event)
            ->get()
            ->getResult();
    }

    // add event
    function add_event($data)
    {
        return $this->db->table($this->event)
            ->insert($data);
    }

    //get event by id
    function get_event_by_id($id)
    {
        return $this->db->table($this->event)
            ->where('event_id', $id)
            ->get()
            ->getRow();
    }

    //update event
    function update_event($data, $id)
    {
        return $this->db->table($this->event)
            ->where('event_id', $id)
            ->update($data);
    }

    //get event by slug
    function get_event_by_slug($slug)
    {
        return $this->db->table($this->event)
            ->where('event_slug', $slug)
            ->get()
            ->getRow();
    }

    //delete event
    function delete_event($id)
    {
        return $this->db->table($this->event)
            ->where('event_id', $id)
            ->delete();
    }

    //gget all event
    function get_all_media()
    {
        return $this->db->table('media')
            ->get()
            ->getResult();
    }

    // add event
    function add_media($data)
    {
        return $this->db->table('media')
            ->insert($data);
    }

    //get event by id
    function get_media_by_id($id)
    {
        return $this->db->table('media')
            ->where('media_id', $id)
            ->get()
            ->getRow();
    }

    //update event
    function update_media($data, $id)
    {
        return $this->db->table('media')
            ->where('media_id', $id)
            ->update($data);
    }

    //delete Media
    function delete_media($id)
    {
        return $this->db->table('media')
            ->where('media_id', $id)
            ->delete();
    }

    //get help for author data
    function get_help_for_author_data()
    {
        return $this->db->table('help_for_author')
            ->where('help_id', 1)
            ->get()
            ->getRow();
    }

    //update help for author
    function update_help_for_author($data)
    {
        return $this->db->table('help_for_author')
            ->where('help_id', 1)
            ->update($data);
    }

    //get print & publish your book data by id
    function get_print_your_book_data_by_id($id)
    {
        return $this->db->table('print_and_publish_book_info')
            ->where('pp_id', $id)
            ->get()
            ->getRow();
    }

    //update print & publish your book data by id
    function update_print_your_book_info($data, $id)
    {
        return $this->db->table('print_and_publish_book_info')
            ->where('pp_id', $id)
            ->update($data);
    }
}
