<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $db;
    protected $user = 'users';

    // check email exists or not
    public function check_email_avaliblity($email)
    {
        return $this->db->table('users')
            ->where('user_email', $email)
            ->get()
            ->getNumRows();
    }

    // check Mobile exists or not
    public function check_mobile_avaliblity($mobile)
    {
        return $this->db->table('users')
            ->where('user_mobile', $mobile)
            ->get()
            ->getNumRows();
    }

    // add new user data
    public function add_user($data)
    {
        $this->db->table($this->user)->insert($data);
        return $this->db->insertID(); // Get the last inserted ID
    }

    //update user
    function update_user($data, $id)
    {
        return $this->db->table($this->user)
            ->where('user_id', $id)
            ->update($data);
    }

    //add order address
    public function add_new_order_address($data)
    {
        $this->db->table('user_order_address')
            ->insert($data);
        return $this->db->insertID();
    }

    //get user order address
    function check_user_order_address($user_id, $address_id)
    {
        return $this->db->table('user_order_address')
            ->where('user_order_address_user_id', $user_id)
            ->where('user_order_address_id', $address_id)
            ->get()
            ->getRow();
    }

    //delete user
    function delete_user($id)
    {
        return $this->db->table($this->user)
            ->where('user_id', $id)
            ->delete();
    }

    /**
     * Employee 
     */
    function get_all_employee()
    {
        return $this->db->table($this->user)
            ->where('user_is_employee', 1)
            ->get()
            ->getResult();
    }

    /**
     * Author Section Start
     */
    function get_all_author()
    {
        return $this->db->table($this->user)
            ->where('user_status', 1)
            ->where('user_role', 'Author')
            ->get()
            ->getResult();
    }

    function get_author_all()
    {
        return $this->db->table($this->user)
            ->where('user_role', 'Author')
            ->get()
            ->getResult();
    }

    function get_all_published_book_author()
    {
        // Fetch all unique prd_author_ids from the product table
        $all_product = $this->db->table('product')
            ->select('prd_author_id')
            ->where('prd_author_id !=', 0)
            ->groupBy('prd_author_id') // Ensure unique prd_author_id values
            ->get()
            ->getResult();

        $all_data = [];

        // Loop through each unique author ID
        foreach ($all_product as $user_id) {
            // Fetch user details (name and image)
            $user_data = $this->db->table('users')
                ->select('user_name, user_image')
                ->where('user_id', $user_id->prd_author_id)
                ->get()
                ->getRow();

            // Count the number of books published by the user
            $book_count = $this->db->table('product')
                ->where('prd_author_id', $user_id->prd_author_id)
                ->countAllResults();

            // Add user data and book count to the final array
            if ($user_data) {
                $all_data[] = [
                    'user_name' => $user_data->user_name,
                    'user_image' => $user_data->user_image,
                    'published_book' => $book_count,
                ];
            }
        }

        return $all_data;
    }


    /**
     * Author Section End
     */
}
