<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Add New Blog</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item active">Blog</li>
            <li class="breadcrumb-item active">Add New Blog</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <!-- SELECT2 EXAMPLE -->
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">Add Blog</h3>
          <div class="card-tools">
            <a href="<?php echo base_url() ?>admin/blog/view_all_post"><button type="button" class="btn btn-success btn-sm"><i class="fa fa-eye"></i> All Blog</button></a>
          </div>
        </div>
        <!-- /.card-header -->
        <?php echo form_open_multipart(base_url() . 'admin/blog/new_blog_add'); ?>
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label>Blog Title <span class="required">*</span></label>
                <input type="text" name="title" class="form-control" placeholder="Enter Blog Title" required="">
              </div>
            </div>
            <div class="col-md-12 d-none">
              <div class="form-group">
                <label>Blog Slug <small>(If you leave it blank, it will be generated automatically.)</small></label>
                <input type="text" name="title_slug" class="form-control" placeholder="Enter Blog Slug">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Blog Short Description <span class="required">*</span></label>
                <textarea type="text" name="short_description" class="form-control" placeholder="Enter Blog Short Description" required=""></textarea>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Blog SEO Keywords</label>
                <textarea type="text" name="keywords" class="form-control" placeholder="Enter Blog Keywords"></textarea>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Blog SEO Description</label>
                <textarea type="text" name="keywords" class="form-control" placeholder="Enter Blog Keywords"></textarea>
              </div>
            </div>


            <div class="col-md-12">
              <div class="row">
                <div class="col-sm-4">
                  <div class="">
                    <label for="radioDanger3">
                      Send Post to All Subscribers <small>(Newsletter)</small>
                    </label>
                  </div>
                </div>
                <div class="col-sm-4">
                  <div class="form-group clearfix">
                    <div class="icheck-danger d-inline">
                      <input type="radio" name="send_post_to_subscribes" checked="" id="send_post_to_subscribes-off" value="0">
                      <label for="send_post_to_subscribes-off">No
                      </label>
                    </div>
                    <div class="icheck-success d-inline ml-3">
                      <input type="radio" name="send_post_to_subscribes" id="send_post_to_subscribes-on" value="1">
                      <label for="send_post_to_subscribes-on">Yes 
                      </label>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-12">
              <div class="form-group">
                <label>Blog Content</label>
                <textarea type="text" name="content" class="form-control text-editor" placeholder="Enter Blog content"></textarea>
              </div>
            </div>

            <div class="col-md-6 ">
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label for="inputEmail" class="col-sm-12 col-form-label">Blog Image <span class="text-danger">*</span></label>
                    <input type="file" name="image" class="form-control name_list image" required/>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Blog Category <span class="text-danger">*</span></label>
                <select name="category" class="form-control" required>
                  <option value="">Select Category</option>
                  <?php foreach ($all_category as $key => $category): ?>
                    <option value="<?php echo $category->category_id ?>"><?php echo $category->category_name ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>


            <div class="col-md-12">
              <div class="form-group">
                <button class="btn btn-info" type="submit" style="float: right">Save</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>