<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Blog Category</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="#">Blog</a></li>
            <li class="breadcrumb-item active">All Blog Category </li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-4">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">Add New Category</h3>
            </div>
            <!-- /.card-header -->
            <?php echo form_open_multipart(base_url() . 'admin/blog/add_new_category'); ?>
            <div class="card-body">
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Category Name<span class="required">*</span></label>
                    <input type="text" name="category_name" class="form-control" placeholder="Enter Category Name" required="">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <button class="btn btn-info" type="submit" style="float: right">Save</button>
                  </div>
                </div>
              </div>
              <?php echo form_close(); ?>
            </div>
          </div>
        </div>

        <div class="col-sm-8">
          <div class="card card-default">
            <div class="card-header">
            <h3 class="card-title">View Category</h3>

            </div>
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>id</th>
                    <th>Category Name</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i = 1;
                  foreach ($all_category as $key => $category): ?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $category->category_name ?></td>
                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-category<?php echo $category->category_id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" href="<?php echo base_url() ?>admin/blog/delete_category/<?php echo $category->category_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                  <?php endforeach; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php $i = 1;
foreach ($all_category as $key => $category): ?>
  <div class="modal fade" id="update-category<?php echo $category->category_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Update Category</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <?php echo form_open_multipart(base_url() . 'admin/blog/update_blog_category/' . $category->category_id); ?>
          <div class="form-group">
            <label for="message-text" class="col-form-label">Category Title:</label>
            <input type="text" name="category_name" class="form-control" value="<?php echo $category->category_name ?>" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update</button>
        </div>
        <?php echo form_close(); ?>
      </div>
    </div>
  </div>
<?php endforeach; ?>