<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>View All Blog</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item active">View All Blog</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">All Blogs</h3>
              <div class="card-tools">
                <a href="<?php echo base_url() ?>admin/blog/add_new_blog" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> Add Blog</a>
              </div>
            </div>
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>id</th>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Category</th>
                    <?php if (user()->user_role != 'Author'): ?>
                      <th>Author</th>
                    <?php endif; ?>
                    <th>Status</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i = 1;
                  foreach ($all_blog as $key => $blog):
                  ?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><img src="<?php echo base_url() ?>/<?php echo $blog->image ?>" width="70;"></td>
                      <td><?php echo $blog->title ?></td>
                      <td><?php echo $blog->category_name ?></td>
                      <?php if (user()->user_role != 'Author'): ?>
                        <td><?php echo $blog->author_name; ?></td>
                      <?php endif; ?>
                      <td>
                        <?php if ($blog->status == 1): ?>
                          <span class="badge badge-success">Active</span>
                        <?php else: ?>
                          <span class="badge badge-warning">Pending</span>
                        <?php endif; ?>
                      </td>
                      <td>
                        <?php if (user()->user_role != 'Author'): ?>
                          <?php if ($blog->status == 0): ?>
                            <a href="<?php echo base_url() ?>admin/blog/change_blog_status/<?php echo $blog->id ?>/1" class="btn btn-success btn-sm"><i class="fa fa-check" aria-hidden="true"></i></a>
                          <?php endif; ?>
                        <?php endif; ?>

                        <a href="<?php echo base_url() ?>admin/blog/update_blog/<?php echo $blog->id ?>" class="btn btn-info btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" href="<?php echo base_url() ?>admin/blog/delete_blog/<?php echo $blog->id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>

                      </td>
                    </tr>
                    <?php $i++; ?>
                  <?php endforeach; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>