<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6 col-12">
                    <h1 class="m-0">Dashboard</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Dashboard</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <?php if (user()->user_role == 'Admin') : ?>
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <!-- Total Order -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3>
                                    <?= db_connect()->table('order')->countAllResults(); ?>
                                </h3>
                                <p>Total Order</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                            <a href="<?= site_url('/admin/subscription/all_order'); ?>" class="small-box-footer">
                                More info <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Total Income -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>
                                    <?php
                                    $db = db_connect();
                                    $query = $db->table('order')->selectSum('order_price', 'total_income')->get()->getRow();
                                    echo $query->total_income ?? 0;
                                    ?>
                                </h3>
                                <p>Total Income</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-inr"></i>
                            </div>
                            <a href="<?= site_url('/admin/subscription/all_order'); ?>" class="small-box-footer">
                                More info <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Total Users -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3>
                                    <?= db_connect()->table('users')->where('user_role', 'User')->countAllResults(); ?>
                                </h3>
                                <p>Total Users</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-users"></i>
                            </div>
                            <a href="<?= site_url('/admin/subscription/all_subscribers'); ?>" class="small-box-footer">
                                More info <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Total Product -->
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-primary">
                            <div class="inner">
                                <h3>
                                    <?= db_connect()->table('product')->countAllResults(); ?>
                                </h3>
                                <p>Total Product</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-tag"></i>
                            </div>
                            <a href="<?= site_url('/admin/product/all_product'); ?>" class="small-box-footer">
                                More info <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Monthly Sales Report -->
                    <div class="col-lg-12 col-12">
                        <div class="card">
                            <div class="card-header border-transparent">
                                <h3 class="card-title">Monthly Sales Report</h3>
                            </div>
                            <div class="card-body p-3">
                                <canvas id="monthly_sales" height="102"></canvas>
                            </div>
                        </div>
                    </div>

                    <!-- Day Wise Income Report -->
                    <div class="col-lg-12 col-12">
                        <div class="card">
                            <div class="card-header border-transparent">
                                <h3 class="card-title">Day Wise Income Report</h3>
                            </div>
                            <div class="card-body p-3">
                                <canvas id="day_wise_income" height="102"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <script src="<?php echo admin_css() ?>plugins/chart.js/Chart.js"></script>
        <script>
            const day_wise_income = document.getElementById('day_wise_income').getContext('2d');
            const day_income = new Chart(day_wise_income, {
                type: 'line',
                data: {
                    labels: [<?php echo $dateList; ?>],
                    datasets: [{
                        data: [<?php $m = 1;
                                if (!empty($day_income_report[0])) {
                                    for ($i = 0; $i < count($alldatethismonth); $i++) {
                                        if (!empty($day_income_report[0][$i])) {
                                            for ($j = $m; $j <= count($alldatethismonth); $j++) {
                                                if (@$day_income_report[0][$i]->month != $j) {
                                                    echo "0,";
                                                } else {
                                                    echo ($day_income_report[0][$i]->total_month . ",");
                                                    $m = $day_income_report[0][$i]->month + 1;
                                                    break 1;
                                                }
                                            }
                                        } else {
                                            echo "0,";
                                            break;
                                        }
                                    }
                                } ?>],
                        backgroundColor: ['#ffc107', ],
                        borderColor: ['#ffc107', ],
                        borderWidth: 2
                    }]
                },
                options: {
                    scaleLabel: function(label) {
                        return '$' + label.value
                    },
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItems, data) {
                                return " ₹ " + tooltipItems.yLabel.toString();
                            }
                        }
                    },
                    legend: {
                        display: false,
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                }
            });
            const monthly_sales = document.getElementById('monthly_sales').getContext('2d');
            const month_sales = new Chart(monthly_sales, {
                type: 'line',
                data: {
                    labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                    datasets: [{
                        data: [<?php $m = 1;
                                if (!empty($monthly_sales_report[0])) {
                                    for ($i = 0; $i < 12; $i++) {
                                        if (!empty($monthly_sales_report[0][$i])) {
                                            for ($j = $m; $j <= 12; $j++) {
                                                if (@$monthly_sales_report[0][$i]->month != $j) {
                                                    echo "0,";
                                                } else {
                                                    echo ($monthly_sales_report[0][$i]->total_month . ",");
                                                    $m = $monthly_sales_report[0][$i]->month + 1;
                                                    break 1;
                                                }
                                            }
                                        } else {
                                            echo "0,";
                                            break;
                                        }
                                    }
                                } ?>],
                        backgroundColor: ['rgba(255, 99, 132, 0.2)', ],
                        borderColor: ['rgba(255, 99, 132, 1)', ],
                        borderWidth: 2
                    }]
                },
                options: {
                    legend: {
                        display: false,
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                }
            });
        </script>

    <?php endif; ?>

</div>
