<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h4>All Employee</h4>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Employee</a></li>
                        <li class="breadcrumb-item active">All Employee</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>


    <section class="content">
        <div class="container-fluid">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">View All Employee</h3>
                    <div class="card-tools">
                        <a href="#" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus" aria-hidden="true"></i> Add Employee</a>
                    </div>
                </div>
                <div class="card-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Role</th>
                                <th>Contact Details</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1;
                            foreach ($all_employee as $data) : ?>
                                <tr>
                                    <td><?php echo $i; ?></td>
                                    <td><?php echo $data->user_name; ?></td>
                                    <td><?php echo $data->user_role; ?></td>
                                    <td>
                                        <i class="fa fa-phone"></i> <?php echo $data->user_mobile; ?>
                                        <?php if ($data->user_email) : ?>
                                            <br />
                                            <i class="fa fa-envelope"></i> <?php echo $data->user_email; ?>
                                        <?php endif; ?>
                                        <?php if ($data->user_address) : ?>
                                            <br />
                                            <i class="fa fa-home"></i> <?php echo $data->user_address; ?>
                                        <?php endif; ?>
                                        
                                    </td>
                                    <td>
                                        <a class="btn btn-warning btn-sm" href="<?php echo base_url(); ?>admin/employee/login_employee/<?php echo $data->user_id; ?>"><i class="fa fa-sign-in"></i></a>

                                        <a class="btn btn-success btn-sm" href="<?php echo base_url(); ?>admin/employee/edit_employee/<?php echo $data->user_id; ?>"><i class="fas fa-edit"></i></a>
                                        
                                        <a class="btn btn-danger btn-sm" href="<?php echo base_url(); ?>admin/employee/delete_employee/<?php echo $data->user_id; ?>"><i class="fas fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

</div>



<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content ">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Employee</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo
            form_open('admin/employee/add_employee');
            ?>
            <div class="modal-body">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-7">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Name <span class="text-danger">*</span></label>
                                <input class="form-control" placeholder="Enter Employee Name" name="user_name" required>
                            </div>
                        </div>
                        <div class="col-sm-5">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Role <span class="text-danger">*</span></label>
                                <select class="form-control" placeholder="Enter Employee Designation" name="user_role" required>
                                    <option value="">Select From List</option>
                                    <?php foreach ($all_role as $key => $role):?>
                                    <option value="<?php echo $role->role_name; ?>"><?php echo $role->role_name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Mobile <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" placeholder="Enter Employee Name" name="user_mobile" required title="Please enter a 10-digit mobile number" pattern="[1-9]{1}[0-9]{9}">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Email </label>
                                <input class="form-control" placeholder="Enter Employee Email" name="user_email" type="email" pattern="[a-z0-9._%+\-]+@[a-z0-9.\-]+\.[a-z]{2,}$" title="Please Enter Valid Email ID">
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Address </label>
                                <textarea class="form-control" type="text" placeholder="Enter Employee Address" name="user_address"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Save</button>
            </div>
            <?php echo
            form_close();
            ?>
        </div>
    </div>
</div>
