<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h4>All Media</h4>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Front Setting</a></li>
                        <li class="breadcrumb-item active">All Media</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>


    <section class="content">
        <div class="container-fluid">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">View All Media</h3>
                    <div class="card-tools">
                        <a href="#" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus" aria-hidden="true"></i> Add Media</a>
                    </div>
                </div>
                <div class="card-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Content</th>
                                <th>Mode</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1;
                            foreach ($all_data as $data) : ?>
                                <tr>
                                    <td><?php echo $i; ?></td>
                                    <td>
                                        <?php echo $data->media_title; ?>
                                    </td>
                                    <td>
                                        <?php if ($data->media_mode == 1): ?>
                                            <img src="<?php echo base_url($data->media_link); ?>" width="100">
                                        <?php else: ?>
                                            <?php echo youtubeEmbed($data->media_link, 100, 50); ?>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php
                                        if ($data->media_mode == 1) {
                                            echo 'Image';
                                        } else {
                                            echo 'Video';
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <!-- <a class="btn btn-success btn-sm" href="<?php //echo base_url(); ?>admin/front_setting/edit_media/<?php //echo $data->media_id; ?>"><i class="fas fa-edit"></i></a> -->

                                        <a class="btn btn-danger btn-sm" href="<?php echo base_url(); ?>admin/front_setting/delete_media/<?php echo $data->media_id; ?>"><i class="fas fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

</div>



<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content ">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Media</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo
            form_open_multipart('admin/front_setting/add_media');
            ?>
            <div class="modal-body">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-8">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Title <span class="text-danger">*</span></label>
                                <input class="form-control" placeholder="Enter Member Title" required name="media_title">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="mode" class="col-form-label">Mode <span class="text-danger">*</span></label>
                                <select class="form-control" id="mode" name="media_mode" required>
                                    <option value="">Select From List</option>
                                    <option value="1">Image</option>
                                    <option value="2">Video</option>
                                </select>
                            </div>
                        </div>

                        <!-- Image Upload Field -->
                        <div class="col-sm-12" id="imageField" style="display: none;">
                            <div class="form-group">
                                <label for="aot_image" class="col-form-label">Image (Size 500 X 500) <span class="text-danger">*</span></label>
                                <input class="form-control" id="aot_image" name="media_image" type="file">
                            </div>
                        </div>

                        <!-- YouTube Link Field -->
                        <div class="col-sm-12" id="videoField" style="display: none;">
                            <div class="form-group">
                                <label for="aot_video" class="col-form-label">YouTube Video Link <span class="text-danger">*</span></label>
                                <input class="form-control" id="aot_video" name="media_link" type="text" placeholder="Enter YouTube Link">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Save</button>
            </div>
            <?php echo
            form_close();
            ?>
        </div>
    </div>
</div>
<script>
    document.getElementById("mode").addEventListener("change", function () {
        var mode = this.value;
        var imageField = document.getElementById("imageField");
        var videoField = document.getElementById("videoField");
        var imageInput = document.getElementById("aot_image");
        var videoInput = document.getElementById("aot_video");

        if (mode == "1") {
            imageField.style.display = "block";
            videoField.style.display = "none";
            imageInput.setAttribute("required", "required");
            videoInput.removeAttribute("required");
        } else if (mode == "2") {
            imageField.style.display = "none";
            videoField.style.display = "block";
            videoInput.setAttribute("required", "required");
            imageInput.removeAttribute("required");
        } else {
            imageField.style.display = "none";
            videoField.style.display = "none";
            imageInput.removeAttribute("required");
            videoInput.removeAttribute("required");
        }
    });
</script>