<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">Update Media</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Media</a></li>
                        <li class="breadcrumb-item active">Update Media</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <!-- Info boxes -->
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Update Media</h3>
                    <div class="card-tools">
                        <a href="<?php echo base_url(); ?>admin/front_setting/all_media" class="btn btn-primary btn-sm"><i class="fa fa-eye" aria-hidden="true"></i> View Media</a>
                    </div>
                </div>
                <!-- /.card-header -->

                <?php
                echo form_open_multipart('admin/front_setting/update_media/' . $data->media_id); ?>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-8">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Title <span class="text-danger">*</span></label>
                                <input value="<?php echo $data->media_title; ?>" class="form-control" placeholder="Enter Member Title" required name="media_title">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="mode" class="col-form-label">Mode <span class="text-danger">*</span></label>
                                <select class="form-control" id="mode" name="media_mode" required>
                                    <option value="">Select From List</option>
                                    <option <?php if($data->media_mode == 1){echo 'selected';}?> value="1">Image</option>
                                    <option <?php if($data->media_mode == 2){echo 'selected';}?> value="2">Video</option>
                                </select>
                            </div>
                        </div>

                        <!-- Image Upload Field -->
                        <div class="col-sm-12" id="imageField" style="display: none;">
                            <div class="form-group">
                                <label for="aot_image" class="col-form-label">Image (Size 500 X 500) <span class="text-danger">*</span></label>
                                <input class="form-control" id="aot_image" name="media_image" type="file">
                            </div>
                        </div>

                        <!-- YouTube Link Field -->
                        <div class="col-sm-12" id="videoField" style="display: none;">
                            <div class="form-group">
                                <label for="aot_video" class="col-form-label">YouTube Video Link <span class="text-danger">*</span></label>
                                <input class="form-control" id="aot_video" name="media_link" type="text" placeholder="Enter YouTube Link">
                            </div>
                        </div>

                        <div class="col-md-12 ">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input type="submit" class="btn btn-info" value="Submit" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo form_close() ?>
            </div>
        </div>
    </section>
</div>