<div class="content-wrapper">
   <div class="content-header">
      <div class="container-fluid">
         <div class="row mb-2">
            <div class="col-sm-6">
               <h1 class="m-0 text-dark">Order Status</h1>
            </div>
            <div class="col-sm-6">
               <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
                  <li class="breadcrumb-item"><a href="#">Order</a></li>
                  <li class="breadcrumb-item active">Order Status</li>
               </ol>
            </div>
         </div>
      </div>
   </div>
   <section class="content">
      <div class="container-fluid">
         <div class="row">
            <div class="col-md-12">
               <div class="timeline">
                  <?php foreach ($order_details as $details): ?>
                     <div class="time-label">
                        <span class="bg-info"><?php echo date('d M Y', strtotime($details->order_status_date))?></span>
                     </div>
                     <?php if($details->order_status == 6): ?>
                        <div>
                           <i class="fas fa-shopping-cart bg-blue"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Placed</a></h3>
                              <div class="timeline-body">
                                Order ID : <b><?php echo $details->order_status_invoice_id; ?></b>
                              </div>
                           </div>
                        </div>
                     <?php elseif ($details->order_status == 0):?>
                        <div>
                           <i class="fas fa-shopping-cart bg-warning"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Pending</a></h3>
                              <?php if($details->order_status_comment): ?>
                                 <div class="timeline-body">
                                   <?php echo $details->order_status_comment; ?>
                                 </div>
                              <?php else:?>
                                 <div class="timeline-body">
                                   We are checking your order. Please wait for the next update
                                 </div>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php elseif ($details->order_status == 1):?>
                        <div>
                           <i class="fas fa-shopping-cart bg-success"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Accepted</a></h3>
                              <?php if($details->order_status_comment): ?>
                                 <div class="timeline-body">
                                   <?php echo $details->order_status_comment; ?>
                                 </div>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php elseif ($details->order_status == 2):?>
                        <div>
                           <i class="fas fa-ban bg-danger"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Rejected</a></h3>
                              <?php if($details->order_status_comment): ?>
                                 <div class="timeline-body">
                                   <?php echo $details->order_status_comment; ?>
                                 </div>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php elseif ($details->order_status == 3):?>
                        <div>
                           <i class="fas fa-shopping-cart bg-primary"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Preparing</a></h3>
                              <?php if($details->order_status_comment): ?>
                                 <div class="timeline-body">
                                   <?php echo $details->order_status_comment; ?>
                                 </div>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php elseif ($details->order_status == 4):?>
                        <div>
                           <i class="fas fa-shopping-cart bg-primary"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Dispatched</a></h3>
                              <?php if($details->order_status_comment): ?>
                                 <div class="timeline-body">
                                   <?php echo $details->order_status_comment; ?>
                                 </div>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php elseif ($details->order_status == 5):?>
                        <div>
                           <i class="fas fa-shopping-cart bg-success"></i>
                           <div class="timeline-item">
                              <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i', strtotime($details->order_status_date))?></span>
                              <h3 class="timeline-header"><a href="#">Order Delivered</a></h3>
                              <?php if($details->order_status_comment): ?>
                                 <div class="timeline-body">
                                   <?php echo $details->order_status_comment; ?>
                                 </div>
                              <?php endif;?>
                           </div>
                        </div>
                     <?php endif;?>
                  <?php endforeach ?>

                  <!-- END timeline item -->
                  <div>
                     <?php if($last_status->order_status == 0): ?>
                        <i class="fas fa-clock bg-warning"></i>
                     <?php elseif($last_status->order_status == 1): ?>
                        <i class="fas fa-clock bg-info"></i>
                     <?php elseif($last_status->order_status == 2): ?>
                        <i class="fas fa-times  bg-danger"></i>
                     <?php elseif($last_status->order_status == 3): ?>
                        <i class="fas fa-clock  bg-primary"></i>
                     <?php elseif($last_status->order_status == 4): ?>
                        <i class="fas fa-clock  bg-info"></i>
                     <?php elseif($last_status->order_status == 5): ?>
                        <i class="fas fa-check bg-success"></i>
                     <?php endif;?>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </section>
</div>