<div class="content-wrapper">
   <div class="content-header">
      <div class="container-fluid">
         <div class="row mb-2">
            <div class="col-sm-6">
               <h1 class="m-0 text-dark">View Order</h1>
            </div>
            <div class="col-sm-6">
               <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
                  <li class="breadcrumb-item"><a href="#">Order</a></li>
                  <li class="breadcrumb-item active">View Order</li>
               </ol>
            </div>
         </div>
      </div>
   </div>
   <section class="content">
      <div class="container-fluid">
         <div class="card card-default">
            <div class="card-header">
               <form method="GET" action="">
                  <div class="container">
                     <div class="row">
                        <div class="col-sm-4">
                           <div class="form-group">
                              <label class="" for="from_date">Start Date &nbsp;&nbsp;&nbsp;</label>
                              <input required="" type="date" name="start_date" class="form-control datepicker" id="from_date">
                           </div>
                        </div>


                        <div class="col-sm-4">
                           <div class="form-group end_date">
                              <label class="" for="to_date">End Date &nbsp;&nbsp;&nbsp;</label>
                              <input required="" type="date" name="end_date" class="form-control datepicker" id="to_date">
                           </div>
                        </div>
                        <div class="col-sm-3">
                           <label style="color: #fff;">s</label>
                           <div class="form-group end_date">

                              <button style="float: right;" type="submit" class="btn btn-success">Search</button>
                           </div>
                        </div>
                     </div>
                  </div>

                  <?php echo form_close() ?>
            </div>
         </div><!--/. container-fluid -->
   </section>
   <section class="content">
      <div class="container-fluid">
         <div class="card card-default">
            <div class="card-header">
               <h3 class="card-title">All Order List</h3>
            </div>
            <div class="card-body" style="overflow-x:auto;">
               <table id="example1" class="table table-bordered table-striped">
                  <thead>
                     <tr>
                        <th>id</th>
                        <th>Product Details</th>
                        <th>Order Details</th>
                        <th>User Details</th>
                        <th>User Address</th>
                        <th>Status</th>
                        <th>Bill</th>
                        <th></th>

                     </tr>
                  </thead>
                  <tbody>
                     <?php $i = 1;
                     foreach ($all_order as $key => $order): ?>
                        <tr>
                           <td><?php echo $i ?></td>
                           <td>
                              <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#order_model<?php echo $order->invoice_id ?>">View All Order</button>
                              <div class="modal fade" id="order_model<?php echo $order->invoice_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                 <div class="modal-dialog modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                       <div class="modal-header">
                                          <h5 class="modal-title" id="exampleModalLongTitle">Order Details</h5>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                             <span aria-hidden="true">&times;</span>
                                          </button>
                                       </div>
                                       <div class="modal-body">
                                          <table class="order_tlb">
                                             <tr>
                                                <th>Product Image</th>
                                                <th>Product Name</th>
                                                <th>Product Qnty</th>
                                                <th>Order Amount</th>
                                             </tr>
                                             <?php
                                             foreach ($order->orders as $value) {
                                             ?>
                                                <tr>
                                                   <td><img src="<?php echo base_url(); ?><?php echo $value->prd_default_image ?>" width="50px"></td>
                                                   <td><?php echo $value->prd_name; ?></td>
                                                   <td><?php echo $value->order_qnty; ?></td>
                                                   <td><?php echo $value->order_price; ?></td>
                                                </tr>
                                             <?php } ?>
                                          </table>
                                       </div>
                                       <div class="modal-footer">
                                          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </td>
                           <td style="font-size: 14px;">

                              <span class="badge badge-primary" style="text-align:left">
                                 Amount : <i style="font-size:8px" class="fas fa-rupee-sign" aria-hidden="true"></i> <?php echo $order->order_price ?>
                                 <br />
                                 Tax : <i style="font-size:8px" class="fas fa-rupee-sign" aria-hidden="true"></i> <?php echo $order->tax_price ?>
                                 <br />
                                 Discount : <i style="font-size:8px" class="fas fa-rupee-sign" aria-hidden="true"></i> <?php echo $order->discount_amt ?>
                                 <br />
                                 Shipping : <i style="font-size:8px" class="fas fa-rupee-sign" aria-hidden="true"></i> <?php echo $order->shipping_charge ?>
                                 <br />

                                 Total : <i style="font-size:8px" class="fas fa-rupee-sign" aria-hidden="true"></i> <?php echo $order->order_price + $order->tax_price + $order->shipping_charge - $order->discount_amt; ?></span>
                              <?php $ttlOrderAmt = $order->order_price + $order->tax_price + $order->shipping_charge; ?>
                              <br />

                              <?php
                              if ($order->paymen_method == 2): ?>
                                 <span class="badge badge-danger">Pay ID : <?php echo $order->order_payment_id ?></span> <br />
                              <?php endif; ?>
                              <span class="badge badge-warning">Date : <?php echo date('d-m-Y h:i:s', (strtotime($order->order_date))) ?></span> <br />
                              <span class="badge badge-success">Tracking Code : <?php echo $order->order_tracking_code ?></span> <br />
                              <span class="badge badge-info">Pay By :
                                 <?php
                                 if ($order->paymen_method == 1) {
                                    echo 'COD';
                                 } else
                                 {
                                    echo 'Online';
                                 } ?>
                              </span>
                           </td>

                           <td style="font-size: 14px;">
                              <span class="badge badge-success">Name : <?php echo $order->user_name ?></span> <br />
                              <span class="badge badge-info">Mob : <?php echo $order->user_mobile ?></span> 
                              <?php if($order->user_email): ?>
                              <br />
                              <span class="badge badge-primary">Email : <?php echo $order->user_email ?></span>
                              <?php endif; ?>

                           </td>
                           <td style="font-size: 14px;">
                              <?php echo $order->user_order_address_address ?>, <?php echo $order->user_order_address_city ?>, <?php echo $order->user_order_address_state ?>, <?php echo $order->user_order_address_country ?> - <?php echo $order->user_order_address_pin ?>
                           </td>
                           <td style="font-size: 14px;">
                              <?php if ($order->order_status == 0): ?>
                                 <span class="badge badge-warning">Pending</span>
                              <?php elseif ($order->order_status == 1): ?>
                                 <span class="badge badge-secondary">Accepted</span>
                              <?php elseif ($order->order_status == 2): ?>
                                 <span class="badge badge-danger">Reject</span>
                              <?php elseif ($order->order_status == 3): ?>
                                 <span class="badge badge-info">Preparing</span>
                              <?php elseif ($order->order_status == 4): ?>
                                 <span class="badge badge-primary">Dispatched</span>
                              <?php elseif ($order->order_status == 5): ?>
                                 <span class="badge badge-success">Delivered</span>
                              <?php endif; ?>
                              <br />
                              <a href="<?php echo base_url() ?>admin/order/track_order/<?php echo $order->invoice_id ?>" class="btn btn-warning btn-xs">Track Order</a>
                           </td>
                           <td>

                              <a target="_blank" href="<?php echo base_url() ?>admin/order/download_bill/<?php echo $order->invoice_id ?>"><i class="fa fa-download" aria-hidden="true"></i></a>

                           </td>
                           <td class="text-right py-0 align-middle">
                              <?php if ($order->order_status != 5 && $order->order_status != 2): ?>
                                 <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                    Action
                                 </button>
                                 <div class="dropdown-menu">

                                    <?php if ($order->order_status == 0): ?>
                                       <a class="dropdown-item" onclick="change_order_status('<?php echo $order->invoice_id ?>', 1, <?php echo $order->user_id; ?>)" href="javascript:void(0)">&nbsp;Accepted</a>
                                       <div class="dropdown-divider"></div>
                                       <a class="dropdown-item" onclick="change_order_status('<?php echo $order->invoice_id ?>', 2, <?php echo $order->user_id; ?>)" href="javascript:void(0)">&nbsp;Reject</a>
                                    <?php endif; ?>
                                    <?php if ($order->order_status == 1): ?>
                                       <a class="dropdown-item" onclick="change_order_status('<?php echo $order->invoice_id ?>', 0, <?php echo $order->user_id; ?>)" href="javascript:void(0)">&nbsp;Pending</a>
                                       <div class="dropdown-divider"></div>
                                       <a class="dropdown-item" onclick="change_order_status('<?php echo $order->invoice_id ?>', 3, <?php echo $order->user_id; ?>)" href="javascript:void(0)">&nbsp;Preparing</a>
                                    <?php endif; ?>
                                    <?php if ($order->order_status == 3): ?>
                                       <a class="dropdown-item" onclick="change_order_status('<?php echo $order->invoice_id ?>', 4, <?php echo $order->user_id; ?>)" href="javascript:void(0)">&nbsp;Dispatched</a>
                                    <?php endif; ?>
                                    <?php if ($order->order_status == 4): ?>
                                       <a class="dropdown-item" onclick="change_order_status('<?php echo $order->invoice_id ?>', 5, <?php echo $order->user_id; ?>)" href="javascript:void(0)">&nbsp;Delivered</a>
                                    <?php endif; ?>
                                 </div>
                              <?php endif; ?>
                           </td>

                        </tr>
                        <?php $i++; ?>
                     <?php endforeach; ?>
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </section>
</div>
<script type="text/javascript">
   function change_order_status(order_id, status, user_id) {
      $('#comment').modal('show');
      $('#order_id').val(order_id);
      $('#status').val(status);
      $('#user_id').val(user_id);
   }

   function get_prd_details(prdName) {
      alert(prdName)
   }
</script>
<div class="modal fade" id="comment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add Comment</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <?php echo form_open(base_url() . '/admin/order/change_order_status'); ?>
         <div class="modal-body">
            <div class="form-group">
               <label for="message-text" class="col-form-label">Add Comment:</label>
               <textarea class="form-control" rows="7" placeholder="Enter Comment if Required" name="message"></textarea>
               <input type="hidden" name="order_id" id="order_id">
               <input type="hidden" name="status" id="status">
               <input type="hidden" name="user_id" id="user_id">
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Update</button>
         </div>
         <?php echo form_close(); ?>
      </div>
   </div>
</div>