<?php 
use App\Models\HomeModel;
?>
<div class="content-wrapper">
  <div class="content-header">
     <div class="container-fluid">
        <div class="row mb-2">
           <div class="col-sm-6">
              <h1 class="m-0 text-dark">All Reviews</h1>
           </div>
           <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                 <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
                 <li class="breadcrumb-item"><a href="#">Product</a></li>
                 <li class="breadcrumb-item active">All Reviews</li>
              </ol>
           </div>
        </div>
     </div>
  </div>
  <section class="content">
     <div class="container-fluid">
        <div class="card card-default">
           <div class="card-header">
              <h3 class="card-title">All Product Reviews</h3>
           </div>
           <div class="card-body" style="overflow-x:auto;">
              <table id="example1" class="table table-bordered table-striped">
                 <thead>
                    <tr>
                       <th>id</th>
                       <th>Product Name</th>
                       <th>User Details</th>
                       <th>Comment</th>
                       <th>Rate</th>
                       <th>Date</th>
                       <th>Status</th>
                       <th></th>
                    </tr>
                 </thead>
                 <tbody>
                    <?php $i=1; foreach ($all_reviews as $key => $reviews):
                    $home = new HomeModel();
                     $prd_puchase_info = $home->get_prd_puchase_info_by_prd_id($reviews->product_id, $reviews->reviewer_id);
                     ?>
                    <tr>
                       <td><?php echo $i ?></td>
                       <td><?php echo $reviews->prd_name ?></td>
                       <td>
                        <?php echo $reviews->user_name ?>
                        <?php if(count($prd_puchase_info) > 0){?>
                           <img src="<?php echo base_url() ?>/front/verified.png" style="width: 40px;margin-top: -10px;">
                        <?php }; ?>
                        <br/>
                        <span class="badge badge-warning">Mob : <?php echo $reviews->user_mobile ?></span>
                        <br/>
                        <span class="badge badge-success">Email : <?php echo $reviews->user_email ?></span>
                       </td>
                       <td><?php echo $reviews->comments ?></td>
                       <td><?php echo $reviews->rate ?></td>
                       <td><?php echo $reviews->date_time ?></td>
                       <td><?php if($reviews->status == 0){echo '<span class="badge badge-warning">Pending</span>';}else{echo '<span class="badge badge-success">Showing</span>';}  ?></td>
                       <td class="text-right py-0 align-middle">
                          <div class="btn-group btn-group-sm">
                           <?php if($reviews->status == 0): ?>
                             <a title="Approve" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>/admin/product/approve_review/<?php echo $reviews->product_review_id ?>" class="btn btn-success" ><i class="fas fa-check"></i></a>
                           <?php else: ?>
                              <a title="Disapprove" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>/admin/product/disapprove_review/<?php echo $reviews->product_review_id ?>" class="btn btn-warning" ><i class="fas fa-times"></i></a>
                           <?php endif;?>
                             <!-- <a title="Delete" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>/admin/product/delete_product/<?php echo $reviews->product_review_id ?>" class="btn btn-danger"><i class="fas fa-trash"></i></a> -->
                          </div>
                       </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                 </tbody>
              </table>
           </div>
        </div>
      </div>
    </section>
</div>
