<div class="content-wrapper">
  <div class="content-header">
     <div class="container-fluid">
        <div class="row mb-2">
           <div class="col-sm-6">
              <h1 class="m-0 text-dark">View Product</h1>
           </div>
           <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                 <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
                 <li class="breadcrumb-item"><a href="#">Product</a></li>
                 <li class="breadcrumb-item active">View Product</li>
              </ol>
           </div>
        </div>
     </div>
  </div>
  <section class="content">
     <div class="container-fluid">
        <div class="card card-default">
           <div class="card-header">
              <h3 class="card-title">All Product List</h3>
              <div class="card-tools">
                 <a href="<?php echo base_url()?>admin/product/add_new_product" class="btn btn-success btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Product</a>
              </div>
           </div>
           <div class="card-body" style="overflow-x:auto;">
              <table id="example1" class="table table-bordered table-striped">
                 <thead>
                    <tr>
                       <th>id</th>
                       <th>Product Name</th>
                       <th>Category</th>
                       <th>Code, Unit, Tax, HSN </th>
                       <th>Price Details</th>
                       <th>Image</th>
                       <th>Status</th>
                       <th></th>
                    </tr>
                 </thead>
                 <tbody>
                    <?php 
                    $i=1; foreach ($all_product as $key => $product):
                    ?>
                    <tr>
                       <td><?php echo $i ?></td>
                       <td style="font-size: 12px;"><?php echo $product->prd_name ?></td>
                       <td style="text-align: center;font-size: 14px;">
                          <span class="badge badge-success"><?php echo $product->category_name ?></span>
                       </td>
                       <td><span class="badge badge-success">Code : <?php echo $product->prd_code_for_n ?></span><br/>
                        <span class="badge badge-info">Tax : <?php echo $product->prd_tax ?>%</span><br/>
                        <span class="badge badge-primary">HSN : <?php echo $product->prd_hsn ?></span><br/></td>
                       <td > 
                          <span style="color: green">&#x20B9; 
                          <?php 
                             if($product->prd_v_offer == 0)
                               {
                                   echo $product->prd_v_sell_price;
                               }
                               else
                               {
                                   echo $product->prd_v_offer_price;
                                   echo '<br/><del> &#x20B9; '.$product->prd_v_sell_price.'</del>';
                               }
                             ?> 
                          </span>
                       </td>
                       <td>
                           <?php if($product->prd_default_image): ?>
                              <a href="#"><img src="<?php echo base_url() ?><?php echo $product->prd_default_image ?>" width="50px" height="50px;"></a>
                           <?php else: ?>
                              <a href="#"><img src="<?php echo base_url() ?>/No-Preview-Available.jpg" width="70px"></a>
                           <?php endif;?>
                       </td>
                       <td>
                          <div class="form-group">
                             <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                <input onchange="update_product_status(this)" type="checkbox" name="status<?php echo $i?>" class="custom-control-input" id="status5<?php echo $i?>" <?php if($product->prd_status == 1){echo 'checked';} ?> value="<?php echo $product->prd_id ?>">
                                <label class="custom-control-label" for="status5<?php echo $i?>"></label>
                             </div>
                          </div>
                       </td>
                       <td class="text-right py-0 align-middle">
                          <div class="btn-group btn-group-sm">
                        
                             <a title="Edit Product" href="<?php echo base_url() ?>admin/product/edit_product/<?php echo $product->prd_id ?>" class="btn btn-info" ><i class="fas fa-edit"></i></a>
                             <br/>
                             <a title="Delete" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/product/delete_product/<?php echo $product->prd_id ?>" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                          </div>
                       </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                 </tbody>
              </table>
           </div>
        </div>
      </div>
    </section>
</div>
