<!-- <link rel="stylesheet" href="<?php echo front_css(); ?>pdf_reader/css/creative.css" type="text/css"> -->
<link rel="stylesheet" href="<?php echo front_css(); ?>pdf_reader/wow_book/wow_book.css" type="text/css">

<div class="breadcrumb-wrapper">
    <div class="container">
        <div class="page-heading">
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="<?php echo base_url(); ?>">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                    <li>
                        Magazine
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<section class="news-section fix section-padding">
    <div class="container">
        <div class="row g-4">
            <?php foreach ($all_data as $key => $data): ?>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="news-card-items style-2 mt-0">
                        <a href="javascript:void(0)" onclick="open_book_reader('<?php echo base_url($data->magazine_edition_pdf); ?>', 'book<?php echo $key; ?>')" class="news-image">
                            <img src="<?php echo base_url($data->magazine_edition_image); ?>" alt="<?php echo $data->magazine_edition_name; ?>">
                        </a>
                        <div class="news-content text-center">
                            <h3><a href="javascript:void(0)" onclick="open_book_reader('<?php echo base_url($data->magazine_edition_pdf); ?>', 'book<?php echo $key; ?>')">
                                    <?php echo $data->magazine_name; ?>
                                </a></h3>
                            <h3><a href="javascript:void(0)" onclick="open_book_reader('<?php echo base_url($data->magazine_edition_pdf); ?>', 'book<?php echo $key; ?>')">
                                    (<?php echo $data->magazine_edition_name; ?>)
                                </a></h3>
                            <a href="javascript:void(0)" class="theme-btn-2" onclick="open_book_reader('<?php echo base_url($data->magazine_edition_pdf); ?>', 'book<?php echo $key; ?>')">
                                Read More <i class="fa-regular fa-arrow-right-long"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div style="display: none;">
                    <div id="book<?php echo $key; ?>"></div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<script>
    function fullscreenErrorHandler() {
        if (self != top) return "The frame is blocking full screen mode. Click on 'remove frame' button above and try to go full screen again.";
    }

    function open_book_reader(pdf, bookId) {
        var options = {
            height: 1024,
            width: 1450, // Adjust width for a two-page view
            pageNumbers: false,
            pdf: pdf, // Dynamically load the correct PDF file
            pdfFind: true,
            pdfTextSelectable: true,
            lightbox: "#" + bookId,
            lightboxClass: "lightbox-pdf",
            centeredWhenClosed: true,
            hardcovers: true,
            curl: false,
            toolbar: "lastLeft, left, currentPage, right, lastRight, find, toc, zoomin, zoomout, download, flipsound, fullscreen, thumbnails",
            thumbnailsPosition: 'bottom',
            responsiveHandleWidth: 50,
            onFullscreenError: fullscreenErrorHandler,
            flipSoundPath: "<?php echo front_css(); ?>/pdf_reader/wow_book/sound/"
        };

        buildBook("#" + bookId, options);
    }

    function buildBook(elem, options) {
        var book = $.wowBook(elem);
        if (!book) {
            $(elem).wowBook(options);
            book = $.wowBook(elem);
        }
        book.showLightbox();
    }
</script>
<style>
    .news-card-items .news-image {
        height: 250px;
        display: flex;
        justify-content: center;
    }

    .news-card-items .news-image img:first-child {
        position: inherit;
        left: 0;
        top: 0;
        right: 0;
        bottom: 0;
        z-index: 1;
        -webkit-transform: inherit;
        transform: inherit;
        opacity: 1;
        -webkit-filter: blur(10px);
        filter: inherit;
    }

    .news-card-items .news-image img {
        width: inherit;
        height: 100%;
        position: relative;
        display: block;
        object-fit: cover;
        -webkit-transition: all 500ms ease;
        transition: all 500ms ease;
        padding: 20px 20px 0 20px;
    }

    .wowbook-lightbox>.wowbook-close {
        background: transparent !important;
        border: none !important;
        color: #222 !important;
        font-size: 2.5em;
    }

    .wowbook-lightbox>.wowbook-close:hover {
        background: #444 !important;
        color: white !important;
        border-radius: 3px;
    }


    .lightbox-images1 .wowbook-book-container {
        background: #6d6b92;
        /* Old browsers */
        background: -moz-radial-gradient(center, ellipse cover, #ffffff 0%, #6d6b92 100%);
        /* FF3.6-15 */
        background: -webkit-radial-gradient(center, ellipse cover, #ffffff 0%, #6d6b92 100%);
        /* Chrome10-25,Safari5.1-6 */
        background: radial-gradient(ellipse at center, #ffffff 0%, #6d6b92 100%);
        /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
    }

    .lightbox-images1>.wowbook-close,
    .lightbox-images2>.wowbook-close {
        color: #ccc !important;
    }

    .lightbox-images2 .wowbook-book-container {
        background: #1E2831;
        /* Old browsers */
        background: -moz-radial-gradient(center, ellipse cover, #ffffff 0%, #1E2831 100%);
        /* FF3.6-15 */
        background: -webkit-radial-gradient(center, ellipse cover, #ffffff 0%, #1E2831 100%);
        /* Chrome10-25,Safari5.1-6 */
        background: radial-gradient(ellipse at center, #ffffff 0%, #1E2831 100%);
        /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
    }

    .lightbox-pdf .wowbook-book-container {
        background: #e5e5e5 url(img/bg-lightbox-pdf.png);
        /* Old browsers */
        background: #e5e5e5 -moz-radial-gradient(center, ellipse cover, #ffffff 20%, #bbbbbb 100%);
        /* FF3.6-15 */
        background: #e5e5e5 -webkit-radial-gradient(center, ellipse cover, #ffffff 20%, #bbbbbb 100%);
        /* Chrome10-25,Safari5.1-6 */
        background: #e5e5e5 radial-gradient(ellipse at center, #ffffff 20%, #bbbbbb 100%);
        /* W3C, IE10+, FF16+, Chrome26+,Opera12+, Safari7+*/
    }

    .lightbox-html .wowbook-book-container {
        background: url(img/book_html/wood.jpg);
    }

    .lightbox-html .wowbook-toolbar {
        margin-top: 1em;
        /* FIXME */
        box-sizing: content-box !important;
    }

    .lightbox-html .wowbook-controls {
        border-radius: 6px;
        width: auto;
    }

    .lightbox-html.wowbook-mobile .wowbook-toolbar {
        margin: 0;
    }

    .lightbox-html.wowbook-mobile .wowbook-controls {
        border-radius: 0;
        width: 100%;
    }

    .wowbook-right .wowbook-gutter-shadow {
        background-image: url("img/page_right_background.png");
        background-position: 0 0;
        width: 75px;
    }

    .wowbook-left .wowbook-gutter-shadow {
        background-image: url("img/page_left_background.png");
        opacity: 0.5;
        width: 60px;
    }

    .wowbook-control-currentPage {
        font-family: "Segoe UI", Helvetica, Arial, sans-serif;
    }
</style>

<script src="<?php echo front_css(); ?>pdf_reader/js/jquery.easing.min.js"></script>
<script src="<?php echo front_css(); ?>pdf_reader/js/jquery.fittext.js"></script>
<script src="<?php echo front_css(); ?>pdf_reader/js/wow.min.js"></script>
<script src="<?php echo front_css(); ?>pdf_reader/js/creative.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>pdf_reader/wow_book/pdf.combined.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>pdf_reader/wow_book/wow_book.min.js"></script>