<!-- Fancybox CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />

<!-- Fancybox JS -->
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>

<div class="breadcrumb-wrapper">

    <div class="container">
        <div class="page-heading">
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="<?php echo base_url(); ?>">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                    <li>
                        Media
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<section class="Error-section section-padding fix">
    <div class="container">
        <div class="row justify-content-center">
            <?php foreach ($all_data as $media): ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="media-card text-center">
                        <?php if ($media->media_mode == 1): // Image Mode 
                        ?>
                            <a href="<?= base_url($media->media_link); ?>" data-fancybox="gallery">
                                <img src="<?= base_url($media->media_link); ?>" class="media-img" alt="<?php echo $media->media_title; ?>">
                            </a>
                        <?php else: // YouTube Video Mode 
                        ?>
                            <?php
                            // Extract YouTube Video ID
                            preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/', $media->media_link, $matches);
                            $videoID = !empty($matches[1]) ? $matches[1] : '';
                            ?>

                            <?php if ($videoID): ?>
                                <a href="https://www.youtube.com/embed/<?= $videoID; ?>?autoplay=1&rel=0"
                                    data-fancybox="gallery" data-caption="<?php echo $media->media_title; ?>">
                                    <div class="video-overlay">
                                        <i class="fa fa-play-circle play-icon"></i>
                                        <img src="https://img.youtube.com/vi/<?= $videoID; ?>/hqdefault.jpg" class="media-img">
                                    </div>
                                </a>
                            <?php else: ?>
                                <p>Invalid YouTube Link</p>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Fancybox Script -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        Fancybox.bind("[data-fancybox]", {
            type: "iframe", // Ensure it's treated as an iframe
            iframe: {
                preload: false
            },
            buttons: ["close"],
        });
    });
</script>
<style>
    /* Ensure all media cards have the same height */
.media-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%; /* Make all cards equal height */
    padding: 15px;
    background: #fff;
    border-radius: 8px;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s ease-in-out;
}

/* Add hover effect */
.media-card:hover {
    transform: translateY(-5px);
}

/* Ensure images fit properly */
.media-img {
    max-width: 100%;
    height: auto;
    border-radius: 6px;
    object-fit: cover;
}

/* Video overlay styling */
.video-overlay {
    position: relative;
    display: inline-block;
    width: 100%;
    height: 200px; /* Fixed height for uniformity */
    background: #000;
    border-radius: 6px;
    overflow: hidden;
}

.video-overlay img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    opacity: 0.8;
}

/* Play icon in the center of the video overlay */
.play-icon {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 50px;
    color: #fff;
    opacity: 0.9;
    transition: 0.3s;
}

.video-overlay:hover .play-icon {
    opacity: 1;
    color: #ff3d00;
}

/* Responsive fixes */
@media (max-width: 768px) {
    .video-overlay {
        height: 180px;
    }
    .play-icon {
        font-size: 40px;
    }
}

</style>