<?php
$cart = \Config\Services::cart();
?>
<div class="breadcrumb-wrapper">
    <div class="container">
        <div class="page-heading">
            <h1>Cart</h1>
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="<?php echo base_url(); ?>">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                    <li>
                        Cart
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="cart-section section-padding">
    <div class="container">
        <div class="main-cart-wrapper">
            <div class="row g-5">
                <div class="col-xl-9">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Price</th>
                                    <th>Quantity</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody id="cart-items">
                                <?php 
                                $cart_ttl = 0;
                                foreach ($cart->contents() as $cart): 
                                    $cart_ttl += $cart['subtotal'];
                                    ?>
                                    <tr data-rowid="<?php echo $cart['rowid']; ?>">
                                        <td>
                                            <span class="d-flex gap-5 align-items-center">
                                                <a href="javascript:void(0)" onclick="remove_cart('<?php echo $cart['rowid']; ?>')" class="remove-icon">
                                                    <img src="<?php echo front_css(); ?>img/icon/icon-9.svg" alt="img">
                                                </a>
                                                <span class="cart">
                                                    <img src="<?php echo base_url(); ?><?php echo $cart['options']['image']; ?>" alt="img" height="100">
                                                </span>
                                                <span class="cart-title">
                                                    <?php echo $cart['name']; ?>
                                                </span>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="cart-price">&#x20B9;<?php echo $cart['price']; ?></span>
                                        </td>
                                        <td>
                                            <span class="quantity-basket">
                                                <span class="qty">
                                                    <button class="qtyminus" aria-hidden="true">−</button>
                                                    <input type="number" class="qty-input" name="qty" value="<?php echo $cart['qty']; ?>" min="1" max="100000" step="1">
                                                    <button class="qtyplus" aria-hidden="true">+</button>
                                                </span>
                                            </span>
                                        </td>
                                        <td class="subtotal">
                                            <span class="subtotal-price">&#x20B9;<?php echo $cart['subtotal']; ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="cart-wrapper-footer">
                        
                        <form action="#">
                            <div class="input-area">
                                <input type="text" name="Coupon Code" id="CouponCode" placeholder="Coupon Code">
                                <button type="submit" class="theme-btn" id="apply-coupon">
                                    Apply
                                </button>
                            </div>
                        </form>
                    </div>

                </div>

                <div class="col-xl-3">
                    <div class="table-responsive cart-total">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Cart Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <span class="d-flex gap-5 align-items-center justify-content-between">
                                            <span class="sub-title">Subtotal:</span>
                                            <span class="sub-price" id="cart-subtotal">&#x20B9;<?php echo $cart_ttl; ?></span>
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="d-flex gap-5 align-items-center justify-content-between">
                                            <span class="sub-title">Discount:</span>
                                            <span class="sub-text" id="cart-discount">&#x20B9;0</span>
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="d-flex gap-5 align-items-center justify-content-between">
                                            <span class="sub-title">Shipping:</span>
                                            <span class="sub-text">&#x20B9;0</span>
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="d-flex gap-5 align-items-center justify-content-between">
                                            <span class="sub-title">Total:</span>
                                            <span class="sub-price sub-price-total" id="cart-total">&#x20B9;<?php echo $cart_ttl; ?></span>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <a href="<?php echo base_url(); ?>checkout" class="theme-btn">Proceed to checkout</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Handle Quantity Increase/Decrease
    $(document).on('click', '.qtyplus, .qtyminus', function() {
        var $input = $(this).closest('span').find('.qty-input');
        var value = parseInt($input.val());
        var min = $input.attr('min');
        var max = $input.attr('max');
        var rowid = $(this).closest('tr').data('rowid');
        var price = parseFloat($(this).closest('tr').find('.cart-price').text().replace('₹', '').trim());

        if ($(this).hasClass('qtyplus')) {
            if (value < max) {
                value++;
            }
        } else if ($(this).hasClass('qtyminus')) {
            if (value > min) {
                value--;
            }
        }

        $input.val(value);
        updateCart(rowid, value, price);
    });

    // Update cart in backend via AJAX
   function updateCart(rowid, qty, price) {
        $.ajax({
            url: '<?php echo base_url(); ?>update_cart',
            type: 'POST',
            data: {rowid: rowid, qty: qty},
            success: function (data) {
                var cart = JSON.parse(data);
                // Update subtotal for this row
                var subtotal = price * qty;
                $("tr[data-rowid='" + rowid + "'] .subtotal-price").text('₹' + subtotal);

                // Update total cart summary
                updateCartTotal();
            },
            error: function () {
                alert('Error updating cart');
            }
        });
    }

    // Update Cart Total
    function updateCartTotal() {
        $.ajax({
            url: '<?php echo base_url(); ?>cart_total',
            type: 'GET',
            success: function(data) {
                var cart = JSON.parse(data);
                $('#cart-subtotal').text('₹' + cart.subtotal);
                $('#cart-total').text('₹' + cart.total);
                $('#cart-discount').text(cart.discount ? '₹' + cart.discount : '₹0');
            }
        });
    }

    // Apply Coupon Code
    $('#apply-coupon').on('click', function() {
        var coupon = $('#CouponCode').val();

        if (coupon) {
            $.ajax({
                url: '<?php echo base_url(); ?>apply_coupon',
                type: 'POST',
                data: {
                    coupon_code: coupon
                },
                success: function(data) {
                    var result = JSON.parse(data);
                    if (result.success) {
                        iziToast.success({
                            title: 'Success',
                            message: 'Coupon applied successfully',
                            position: 'topRight'
                        });
                        updateCartTotal();
                    } else {
                        iziToast.error({
                            title: 'Error',
                            message: result.message,
                            position: 'topRight'
                        });
                    }
                }
            });
        } else {
            iziToast.warning({
                title: 'Warning',
                message: 'Please enter a coupon code',
                position: 'topRight'
            });
        }
    });
</script>