<?php
$cart = \Config\Services::cart();
?>
<div class="breadcrumb-wrapper">
    <div class="container">
        <div class="page-heading">
            <h1>Checkout</h1>
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="index.html">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                    <li>
                        Checkout
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- Checkout Section Start -->
<section class="checkout-section fix section-padding">
    <div class="container">
        <?php echo
        form_open(base_url() . 'submit_order');
        ?>
        <div class="row g-5">
            <div class="col-lg-8">

                <div class="checkout-single-wrapper">
                    <div class="checkout-single boxshado-single">
                        <h4>Billing Details</h4>
                        <div class="checkout-single-form">
                            <div class="row g-4">
                                <div class="col-lg-6">
                                    <div class="input-single">
                                        <span>First Name <b class="text-danger">*</b></span>
                                        <input type="text" name="user_first_name" id="userFirstName" required=""
                                            placeholder="First Name">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="input-single">
                                        <span>Last Name <b class="text-danger">*</b></span>
                                        <input type="text" name="user_last_name" id="userLastName" required=""
                                            placeholder="Last Name">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="input-single">
                                        <span>Company name (optional)</span>
                                        <input name="company-name" id="companyname">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="input-single">
                                        <span>Country <b class="text-danger">*</b></span>
                                        <select onchange="get_all_state()" name="user_order_address_country" id="p_country" placeholder="Select a Country" required>
                                            <option value="">Select A Country</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 position-relative">
                                    <div class="loader_input_filed">
                                        <div class="spinner"></div>
                                    </div>
                                    <div class="input-single">
                                        <span>State <b class="text-danger">*</b></span>
                                        <select onchange="get_all_city()" name="user_order_address_state" id="p_state" placeholder="Select a State" required>
                                            <option value="">Select A State</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-7 position-relative">
                                    <div class="loader_input_filed_2">
                                        <div class="spinner"></div>
                                    </div>
                                    <div class="input-single">
                                        <span>City <b class="text-danger">*</b></span>
                                        <select name="user_order_address_city" id="p_city" placeholder="Select a City" required>
                                            <option value="">Select A City</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="input-single">
                                        <span>Pin Code <b class="text-danger">*</b></span>
                                        <input name="user_order_address_pin" placeholder="Pin Code" required type="number" value="<?php echo session()->get('zip') ?>">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="input-single">
                                        <span>Address <b class="text-danger">*</b></span>
                                        <input name="user_order_address_address" placeholder="House No./ Street Address / Village Name Etc." required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="input-single">
                                        <span>Phone <b class="text-danger">*</b></span>
                                        <input name="user_mobile" id="phone"
                                            placeholder="Enter your Mobile No."
                                            pattern="[0-9]{10}"
                                            title="Please enter a 10-digit mobile number."
                                            required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="input-single">
                                        <span>Email ID</span>
                                        <input name="user_email" id="email22" placeholder="email">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="input-check payment-save">
                                        <input type="checkbox" class="form-check-input" name="save-for-next" id="saveForNext111">
                                        <label for="saveForNext">Save for my next payment</label>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="input-single">
                                        <span>order notes (optional)</span>
                                        <textarea name="notes" id="notes"
                                            placeholder="Notes about your order, e.g special notes for delivery."></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
            <div class="checkout-order-area p-4 sticky-right" style="box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;">
                    <h3>Your Order</h3>
                    <div class="product-checout-area">
                        <div class="table-responsive order_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cart_ttl = 0;
                                    $i = 1;
                                    $cart_tax = 0;
                                    $main_price_with_out_tax_ttl = 0;

                                    foreach ($cart->contents() as $cart):
                                        $cart_ttl += $cart['subtotal'];
                                        $cart_tax += $cart['options']['tax'];
                                        $main_price_with_out_tax = $cart['subtotal'] - $cart['options']['tax'];
                                        $main_price_with_out_tax_ttl += $cart['subtotal'] - $cart['options']['tax'];
                                    ?>
                                        <tr>
                                            <td><?php echo mb_strimwidth($cart['name'], 0, 20, "..."); ?>
                                                <span class="product-qty">x <?php echo $cart['qty']; ?></span>
                                            </td>
                                            <td>&#x20B9;<?php echo $main_price_with_out_tax; ?></td>
                                        </tr>
                                    <?php $i++;
                                    endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total</th>
                                        <td class="product-subtotal">&#x20B9;<?php echo $main_price_with_out_tax_ttl; ?></td>
                                    </tr>
                                    <tr>
                                        <td>Tax</td>
                                        <td>&#x20B9;<?php echo $cart_tax; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Sub Total</th>
                                        <td class="product-subtotal">&#x20B9;<?php echo $ttl_amount =  $main_price_with_out_tax_ttl + $cart_tax; ?></td>
                                    </tr>
                                    <?php $discount = 0;
                                    if (session()->get('coupon_discount')): ?>
                                        <tr>
                                            <td>Discount (<?php echo session()->get('coupon_discount'); ?>%)</td>
                                            <td>&#x20B9;<?php echo $discount = round((session()->get('coupon_discount') / 100) * $ttl_amount); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td>Shipping</td>
                                        <td><?php if (session()->get('shipping_charge')) {
                                                echo '&#x20B9;' . session()->get('shipping_charge');
                                            } else {
                                                echo 'Free Shipping';
                                            } ?></td>
                                    </tr>
                                    <tr>
                                        <th>Grand Total</th>
                                        <td class="product-subtotal">
                                            <span>&#x20B9;<?php echo $g_total = $ttl_amount + session()->get('shipping_charge') - $discount ?></span>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <h3 class="mt-3 pb-3">Payment Option</h3>
                    <div class="product-checout-area">
                        <div class="checkout-item-2">
                            <div class="form-check-3 d-flex align-items-center from-customradio-2 mt-3">
                                <input class="form-check-input" value="1" name="paymen_method" type="radio"  id="flexRadioDefault12224">
                                <label class="form-check-label" for="flexRadioDefault12224">
                                    Cash on delivery
                                </label>
                            </div>
                            <div class="form-check-3 d-flex align-items-center from-customradio-2 mt-3">
                                <input class="form-check-input" value="2" name="paymen_method" type="radio"  id="flexRadioDefault12225" checked>
                                <label class="form-check-label" for="flexRadioDefault12225">
                                    Pay By Online
                                </label>
                                <ul class="brand-logo">
                                    <li>
                                        <a>
                                            <img src="<?php echo front_css(); ?>prepaid_icon.gif" alt="img" width="50">
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div>
                            <button type="submit" class="btn btn-success w-100">Place Order</button>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo form_close(); ?>
        </div>
    </div>
</section>
<style>
    .checkout-single-wrapper .checkout-single .checkout-single-form .input-single textarea,
    .checkout-single-wrapper .checkout-single .checkout-single-form .input-single .country-select,
    .checkout-single-wrapper .checkout-single .checkout-single-form .input-single input,
    select {
        height: 50px;
    }
</style>
<!-- <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script> -->
<script>
    // $(document).ready(function() {
    //     $('#p_country').select2({
    //         placeholder: "Select a Country",
    //         width: "resolve"
    //     });
    // });
</script>
