 <?php

    use App\Models\HomeModel;
    use App\Models\OrderModel;
    use App\Models\SettingModel;

    $uri = service('uri');
    $home = new HomeModel();
    $order = new OrderModel();
    $setting = new SettingModel();
    $all_page = $home->get_all_active_page();
    $cart = \Config\Services::cart();
    $heading            = $setting->get_all_section_heading();
    ?>
 <!-- Footer Section start  -->
 <footer class="footer-section footer-bg d-none d-lg-block">
     <div class="container">
         <div class="contact-info-area">

             <div class="row newsletter-section align-items-center">
                 <div class="col-sm-2">
                     <div class="plane-shape float-bob-y wow fadeInUp" data-wow-delay=".2s">
                         <img src="<?php echo front_css(); ?>img/plane-shape.png" alt="img">
                     </div>
                 </div>
                 <div class="col-sm-4 wow fadeInUp" data-wow-delay=".4s">
                     <h1 class="text-white"><?php echo $heading->heading_newsletter_heading; ?></h1>
                     <p class="text-white"><?php echo $heading->heading_newsletter_sub_heading; ?></p>
                 </div>
                 <div class="col-sm-6 wow fadeInUp" data-wow-delay=".6s">
                     <div class="footer-input">
                         <input type="email" id="email2" placeholder="Enter Email Address">
                         <button class="newsletter-btn" type="submit">
                             <i class="fa-regular fa-paper-plane"></i>
                         </button>
                     </div>
                 </div>
             </div>

         </div>
     </div>
     <div class="footer-widgets-wrapper d-none d-lg-block">
         <div class="container">
             <div class="row">
                 <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".2s">
                     <div class="single-footer-widget">
                         <div class="widget-head">
                             <a href="index.html">
                                 <img src="<?php echo base_url($app_setting->app_sticky_logo); ?>" alt="logo-img" style="height:70px">
                             </a>
                         </div>
                         <div class="footer-content">
                             <p>
                                 <?php echo $app_setting->app_footer_about_us; ?>
                             </p>
                             <div class="social-icon d-flex align-items-center">
                                 <?php if ($app_setting->app_faecbook): ?>
                                     <a href="<?php echo $app_setting->app_faecbook; ?>" target="_blank" class="facebook"><i class="fab fa-facebook-f"></i></a>
                                 <?php endif; ?>
                                 <?php if ($app_setting->app_twitter): ?>
                                     <a href="<?php echo $app_setting->app_twitter; ?>" target="_blank" class="twitter"><i class="fab fa-twitter"></i></a>
                                 <?php endif; ?>
                                 <?php if ($app_setting->app_youtube): ?>
                                     <a href="<?php echo $app_setting->app_youtube; ?>" target="_blank" class="youtube"><i class="fab fa-youtube"></i></a>
                                 <?php endif; ?>
                                 <?php if ($app_setting->app_linkedin): ?>
                                     <a href="<?php echo $app_setting->app_linkedin; ?>" target="_blank" class="linkedin"><i class="fab fa-linkedin-in"></i></a>
                                 <?php endif; ?>
                                 <?php if ($app_setting->app_telegram): ?>
                                     <a href="<?php echo $app_setting->app_telegram; ?>" target="_blank" class="telegram"><i class="fab fa-telegram-plane"></i></a>
                                 <?php endif; ?>
                                 <?php if ($app_setting->app_instagram): ?>
                                     <a href="<?php echo $app_setting->app_instagram; ?>" target="_blank" class="instagram"><i class="fab fa-instagram"></i></a>
                                 <?php endif; ?>
                             </div>
                         </div>
                     </div>
                 </div>
                 <div class="col-xl-3 col-lg-4 col-md-6 ps-lg-5 wow fadeInUp" data-wow-delay=".4s">
                     <div class="single-footer-widget">
                         <div class="widget-head">
                             <h3>Useful Link</h3>
                         </div>
                         <ul class="list-area">
                             <li><a href="<?php echo base_url(); ?>login"><i class="fa-solid fa-chevrons-right"></i> Login</a></li>
                             <li><a href="<?php echo base_url(); ?>registration"><i class="fa-solid fa-chevrons-right"></i> Register</a></li>
                             <li><a href="<?php echo base_url(); ?>track-order"><i class="fa-solid fa-chevrons-right"></i> Track Order</a></li>
                             <?php foreach ($all_page as $page):
                                    if ($page->important == 'Userfull Link'): ?>
                                     <li><a href="<?php echo base_url(); ?><?php echo $page->slug; ?>"><i class="fa-solid fa-chevrons-right"></i> <?php echo $page->name; ?></a></li>
                             <?php endif;
                                endforeach; ?>
                         </ul>
                     </div>
                 </div>
                 <div class="col-xl-3 col-lg-4 col-md-6 ps-lg-5 wow fadeInUp" data-wow-delay=".6s">
                     <div class="single-footer-widget">
                         <div class="widget-head">
                             <h3>Policies</h3>
                         </div>
                         <ul class="list-area">
                             <?php foreach ($all_page as $page):
                                    if ($page->important == 'Policies'): ?>
                                     <li><a href="<?php echo base_url(); ?><?php echo $page->slug; ?>"><i class="fa-solid fa-chevrons-right"></i> <?php echo $page->name; ?></a></li>
                             <?php endif;
                                endforeach; ?>
                         </ul>
                     </div>
                 </div>
                 <div class="col-xl-3 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".8s">
                     <div class="single-footer-widget">
                         <div class="widget-head">
                             <h3>Contact Info</h3>
                         </div>
                         <ul class="list-area">
                             <?php if ($app_setting->app_mobile): ?>
                                 <li><a href="tel:+91<?php echo $app_setting->app_mobile; ?>"> <i class="fa-regular fa-phone"></i> +91<?php echo $app_setting->app_mobile; ?></a></li>
                             <?php endif;
                                if ($app_setting->app_email): ?>
                                 <li><a href="mailto:<?php echo $app_setting->app_email; ?>"> <i class="fa-regular fa-envelope"></i> <?php echo $app_setting->app_email; ?></a></li>
                             <?php endif;
                                if ($app_setting->app_address): ?>
                                 <li><a href="#"> <i class="fa-regular fa-house"></i> <?php echo $app_setting->app_address; ?></a></li>
                             <?php endif ?>
                         </ul>
                     </div>
                 </div>
             </div>
         </div>
     </div>
     <div class="footer-bottom">
         <div class="container">
             <div class="footer-wrapper d-flex align-items-center justify-content-between">
                 <p class="wow fadeInLeft" data-wow-delay=".3s">
                     © All Copyright <?php echo date('Y') ?> by <a href="<?php echo base_url(); ?>"><?php echo $app_setting->app_name; ?></a>
                 </p>
                 <ul class="brand-logo wow fadeInRight" data-wow-delay=".5s">
                     <li>
                         <a href="contact.html">
                             <img src="<?php echo front_css(); ?>img/visa-logo.png" alt="img">
                         </a>
                     </li>
                     <li>
                         <a href="contact.html">
                             <img src="<?php echo front_css(); ?>img/mastercard.png" alt="img">
                         </a>
                     </li>
                     <li>
                         <a href="contact.html">
                             <img src="<?php echo front_css(); ?>img/payoneer.png" alt="img">
                         </a>
                     </li>
                     <li>
                         <a href="contact.html">
                             <img src="<?php echo front_css(); ?>img/affirm.png" alt="img">
                         </a>
                     </li>
                 </ul>
             </div>
         </div>
     </div>
 </footer>
 <div class="aiz-mobile-bottom-nav d-lg-none fixed-bottom bg-white shadow-lg border-top rounded-top"
     style="box-shadow: 0px -1px 10px rgb(0 0 0 / 15%)!important;"
     id="footer-cart">
     <div class="row align-items-center g-2 pt-2">
         <div class="col text-center">
             <a href="<?php echo base_url(); ?>" class="text-reset d-block pb-1 pt-0">
                 <i class="fa-regular fa-home fs-4 active-footer-menu"></i>
                 <span class="d-block fs-7 active-footer-menu">Home</span>
             </a>
         </div>
         <div class="col text-center">
             <a href="javascript:void(0)" data-bs-toggle="collapse" data-bs-target="#navCatContent" aria-expanded="false" class="text-reset d-block pb-1 pt-0">
                 <i class="fa-regular fa-bars fs-4"></i>
                 <span class="d-block fs-7 ">Categories</span>
             </a>
         </div>
         <div class="col-auto text-center">
             <a href="<?php echo base_url(); ?>cart" class="text-reset d-block pb-1 pt-0">
                 <span class="d-flex align-items-center justify-content-center position-relative rounded-circle bg-primary text-white border border-white border-2 shadow-sm"
                     style="width: 50px; height: 50px; margin-top: -25px;">
                     <i class="fa-regular fa-shopping-bag fs-5"></i>
                 </span>
                 <span class="d-block mt-1 fs-7" id="cart_count_mobile">
                     Cart
                     <?php if ($cart):
                            $cartContents = $cart->contents();
                            $cartCount = count($cartContents);
                        else:
                            $cartCount = 0; // Fallback if the cart is not initialized
                        endif; ?>
                     (<span class="cart-count"><?php echo $cartCount; ?></span>)
                 </span>
             </a>
         </div>

         <div class="col text-center">
             <?php if (session()->get('logged_in')):
                    $all_wishlist = $order->get_wishlist_prd_count_by_user_id(user()->user_id); ?>
                 <a href="<?php echo base_url(); ?>wishlist" class="text-reset d-block pb-1 pt-0">
                     <span class="position-relative">
                         <i class="fa-regular fa-heart fs-4"></i>
                     </span>
                     <span class="d-block fs-7 ">Wishlist</span>
                 </a>
             <?php else: ?>
                 <a href="<?php echo base_url(); ?>login" class="text-reset d-block pb-1 pt-0">
                     <span class="position-relative">
                         <i class="fa-regular fa-heart fs-4"></i>
                     </span>
                     <span class="d-block fs-7 ">Wishlist</span>
                 </a>
             <?php endif; ?>
         </div>
         <div class="col text-center">
             <a href="#" class="text-reset d-block pb-1 pt-0">
                 <span class="d-block mx-auto">
                     <?php if (session()->get('logged_in') == true): ?>
                         <?php if (user()->user_image): ?>
                             <img src="<?php echo base_url(); ?><?php echo user()->user_image ?>" class="rounded-circle" width="27" alt="User Image">
                         <?php else: ?>
                             <img src="<?php echo base_url(); ?>front/profile-image.png" class="rounded-circle" width="27" alt="Default Image">
                         <?php endif; ?>
                     <?php else: ?>
                         <i class="fa-regular fa-user fs-4"></i>
                     <?php endif; ?>
                 </span>
                 <span class="d-block fs-7 ">Account</span>
             </a>
         </div>
     </div>
 </div>

 <div class="offcanvas offcanvas-end shadow-lg" tabindex="-1" id="cartOffcanvas" aria-labelledby="cartOffcanvasLabel">
     <!-- Header -->
     <div class="offcanvas-header bg-gradient text-white">
         <h5 class="offcanvas-title" id="cartOffcanvasLabel">🛒 Your Shopping Cart</h5>
         <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close">&#x2715;</button>
     </div>

     <!-- Body -->
     <div class="offcanvas-body">
         <!-- Items Section -->
         <ul class="list-group" id="cart_product_list">
             <?php
                $cart_ttl = 0;
                if ($cart->contents()):
                    foreach ($cart->contents() as $cart):
                        $cart_ttl += $cart['subtotal'];
                ?>
                     <li class="list-group-item d-flex align-items-center justify-content-between cart-item">
                         <div class="d-flex align-items-center justify-content-center me-3" style="width: 120px; height: 100px;">
                             <img src="<?php echo base_url(); ?><?php echo $cart['options']['image']; ?>"
                                 alt="<?php echo $cart['name']; ?>"
                                 class="img-fluid rounded shadow-sm"
                                 style="max-height: 100%; max-width: 100%; object-fit: cover;">
                         </div>
                         <div class="flex-grow-1">
                             <h6 class="mb-1 fw-bold product-name"><?php echo $cart['name']; ?></h6>
                             <div class="d-flex align-items-center">
                                 <span class="text-muted me-3">Price: &#x20B9;<?php echo $cart['price']; ?></span>
                                 <span class="text-muted me-3">Qty: <?php echo $cart['qty']; ?></span>
                                 <span class="text-muted fw-bold">Total: &#x20B9;<?php echo $cart['price'] * $cart['qty']; ?></span>
                             </div>
                         </div>
                         <div>
                             <button class="btn btn-danger btn-sm rounded-circle delete-btn" onclick="remove_cart('<?php echo $cart['rowid']; ?>')">
                                 <i class="fa fa-trash"></i>
                             </button>
                         </div>
                     </li>
                 <?php
                    endforeach;
                else: ?>
                 <li class="text-center d-flex justify-content-center align-items-center" style="height: 70vh;">
                     <div class="text-center">
                         <img src="<?php echo front_css() ?>oops_image.png" alt="No items in cart" class="img-fluid mx-auto d-block" style="max-width: 300px;">
                         <p class="mt-3 text-muted">Your cart is empty!</p>
                     </div>
                 </li>

             <?php endif; ?>
         </ul>
     </div>

     <div class="offcanvas-footer" id="cart_grand_total">
         <?php
            if ($cart_ttl):
            ?>
             <div class=" p-3 bg-light border-top">
                 <div class="pt-1 pb-3">
                     <h6 class="fw-bold text-end grand-total">Grand Total: <span class="text-success">&#x20B9;<?php echo $cart_ttl; ?></span></h6>
                 </div>
                 <div class="d-flex">
                     <a href="<?php echo base_url(); ?>cart" class="btn view-cart w-50 me-1 text-white">View Cart</a>
                     <a href="<?php echo base_url(); ?>checkout" class="btn btn-success checkout w-50 ms-1">Checkout</a>
                 </div>
             </div>
         <?php endif; ?>
     </div>

 </div>


 <script>
     var login = false;
     <?php if ($uri->getSegment(1) == 'login') : ?>
         login = true
     <?php endif; ?>
     var base_url = '<?php echo base_url(); ?>';
 </script>
 <!--<< All JS Plugins >>-->
 <!-- <script src="<?php //echo front_css(); 
                    ?>js/jquery-3.7.1.min.js"></script> -->
 <!--<< Viewport Js >>-->
 <script src="<?php echo front_css(); ?>js/viewport.jquery.js"></script>
 <!--<< Bootstrap Js >>-->
 <script src="<?php echo front_css(); ?>js/bootstrap.bundle.min.js"></script>
 <!--<< Nice Select Js >>-->
 <!-- <script src="<?php //echo front_css(); 
                    ?>js/jquery.nice-select.min.js"></script> -->
 <!--<< Waypoints Js >>-->
 <script src="<?php echo front_css(); ?>js/jquery.waypoints.js"></script>
 <!--<< Counterup Js >>-->
 <script src="<?php echo front_css(); ?>js/jquery.counterup.min.js"></script>
 <!--<< Swiper Slider Js >>-->
 <script src="<?php echo front_css(); ?>js/swiper-bundle.min.js"></script>
 <!--<< MeanMenu Js >>-->
 <script src="<?php echo front_css(); ?>js/jquery.meanmenu.min.js"></script>
 <!--<< Magnific Popup Js >>-->
 <script src="<?php echo front_css(); ?>js/jquery.magnific-popup.min.js"></script>
 <!--<< Wow Animation Js >>-->
 <script src="<?php echo front_css(); ?>js/wow.min.js"></script>
 <!-- Gsap -->
 <script src="<?php echo front_css(); ?>js/gsap.min.js"></script>
 <!--<< Main.js >>-->
 <script src="<?php echo front_css(); ?>js/main.js"></script>
 <script src="<?php echo front_css(); ?>js/custom-install.js"></script>
 <?php if ($uri->getSegment(1) == 'checkout') : ?>
     <script src="<?php echo front_css(); ?>js/location.js"></script>
 <?php endif; ?>
 <style>
    .cursor-follower
    {
        display: none;
    }
 </style>
 </body>

 </html>