<?php

use App\Models\HomeModel;
use App\Models\ProductModel;

$uri = service('uri');
$actual_link = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
if (isset($og_image)) {
    $fev_image = $og_image;
} else {
    $fev_image = $app_setting->app_fevicon;
}
$home = new HomeModel();
$product = new ProductModel();
$all_page = $home->get_all_active_page();
$cart = \Config\Services::cart();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- ========== Meta Tags ========== -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?></title>
    <meta name="description" content="<?php echo $description; ?>">
    <meta name="keywords" content="<?php echo $keyword; ?>">
    <meta name="author" content="<?php echo $app_setting->app_name; ?>">

    <meta property="og:title" content="<?php echo $title; ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:URL" content="<?php echo $actual_link; ?>" />
    <meta property="og:site_name" content="<?php echo $app_setting->app_name; ?>" />
    <meta property="og:image" content="<?php echo base_url(); ?><?php echo $fev_image; ?>" />
    <meta property="og:description" content="<?php echo $description; ?>" />
    <link rel="shortcut icon" href="<?php echo base_url(); ?><?php echo $app_setting->app_fevicon; ?>">
    <link rel="manifest" href="<?php echo base_url(); ?>manifest.json">

    <!--<< Bootstrap min.css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/bootstrap.min.css">
    <!--<< All Min Css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/all.min.css">
    <!--<< Animate.css >>-->
    <!-- <link rel="stylesheet" href="<?php echo front_css(); ?>css/animate.css"> -->
    <!--<< Magnific Popup.css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/magnific-popup.css">
    <!--<< MeanMenu.css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/meanmenu.css">
    <!--<< Swiper Bundle.css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/swiper-bundle.min.css">
    <!--<< Nice Select.css >>-->
    <!-- <link rel="stylesheet" href="<?php //echo front_css(); 
                                        ?>css/nice-select.css"> -->
    <!--<< Icomoon.css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/icomoon.css">
    <!--<< Main.css >>-->
    <link rel="stylesheet" href="<?php echo front_css(); ?>css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <?php //if (session()->get('error') || session()->get('success')): 
    ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.css" integrity="sha512-DIW4FkYTOxjCqRt7oS9BFO+nVOwDL4bzukDyDtMO7crjUZhwpyrWBFroq+IqRe6VnJkTpRAS6nhDvf0w+wHmxg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <?php //endif; 
    ?>
    <?php if ($uri->getSegment(1) == '') : ?>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js" integrity="sha512-bPs7Ae6pVvhOSiIcyUClR7/q2OAsRiovw4vAkX+zJbw3ShAeeqezq50RIIcIURq7Oa20rW2n2q+fyXBNcU9lrw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <?php endif; ?>
    <style>
        :root {
            --body: #fff;
            --black: #000;
            --white: #fff;
            --theme: <?php echo $app_setting->app_color_2; ?>;
            --theme2: <?php echo $app_setting->app_color_3; ?>;
            --header: <?php echo $app_setting->app_color_1; ?>;
            --text: #4F536C;
            --border: #D4DCFF;
            --border-2: #D4DCED;
            --border-3: #D0E1E7;
            --bg: #D0E1E7;
            --bg2: #F5F5F5;
            --box-shadow: 0px 4px 25px 0px rgba(0, 0, 0, 0.06);
        }
    </style>
</head>

<body>
    <div id="custom-install-banner" style="display: none; position: fixed; bottom: 0; left: 0; right: 0; background: #fff; padding: 15px; box-shadow: 0 -2px 5px rgba(0,0,0,0.2); z-index: 1000;">
        <p>Install our app for a better experience!</p>
        <button id="install-button" style="background: #007bff; color: #fff; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer;">
            Install
        </button>
        <button id="dismiss-button" style="background: #ccc; color: #000; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer;">
            Dismiss
        </button>
    </div>

    <script>
        /* if ("serviceWorker" in navigator) {
            navigator.serviceWorker
                .register("<?php //echo base_url(); 
                            ?>sw.js")
                .then((registration) => {
                    console.log("Service Worker registered with scope:", registration.scope);
                })
                .catch((error) => {
                    console.log("Service Worker registration failed:", error);
                });
        }*/
        var is_product_details_page = false;
    </script>
    <!-- Cursor follower -->
    <div class="cursor-follower"></div>

    <!-- Preloader start -->
    <!-- <div id="preloader" class="preloader">
        <div class="animation-preloader">
            <div class="spinner">
            </div>
            <div class="txt-loading">
                <span data-text-preloader="गा" class="letters-loading">
                    गा
                </span>
                <span data-text-preloader="था" class="letters-loading">
                    था
                </span>
                <span data-text-preloader="" class="letters-loading">

                </span>
                <span data-text-preloader="प्र" class="letters-loading">
                    प्र
                </span>
                <span data-text-preloader="का" class="letters-loading">
                    का
                </span>
                <span data-text-preloader="श" class="letters-loading">
                    श
                </span>
                <span data-text-preloader="न" class="letters-loading">
                    न
                </span>
            </div>
            <p class="text-center">Loading</p>
        </div>
        <div class="loader">
            <div class="row">
                <div class="col-3 loader-section section-left">
                    <div class="bg"></div>
                </div>
                <div class="col-3 loader-section section-left">
                    <div class="bg"></div>
                </div>
                <div class="col-3 loader-section section-right">
                    <div class="bg"></div>
                </div>
                <div class="col-3 loader-section section-right">
                    <div class="bg"></div>
                </div>
            </div>
        </div>
    </div> -->

    <!-- Back To Top start -->
    <button id="back-top" class="back-to-top">
        <i class="fa-solid fa-chevron-up"></i>
    </button>

    <!-- Offcanvas Area start  -->
    <div class="fix-area">
        <div class="offcanvas__info">
            <div class="offcanvas__wrapper">
                <div class="offcanvas__content">
                    <div class="offcanvas__top mb-5 d-flex justify-content-between align-items-center">
                        <div class="offcanvas__logo">
                            <a href="<?php echo base_url(); ?>">
                                <img src="<?php echo base_url($app_setting->app_sticky_logo); ?>" alt="<?php echo $app_setting->app_name; ?>">
                            </a>
                        </div>
                        <div class="offcanvas__close">
                            <button>
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>

                    <div class="mobile-menu fix mb-3"></div>
                    <div class="offcanvas__contact">
                        <h4>Contact Info</h4>
                        <ul>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon">
                                    <i class="fal fa-map-marker-alt"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="#"><?php echo $app_setting->app_address; ?></a>
                                </div>
                            </li>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="fal fa-envelope"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="mailto:<?php echo $app_setting->app_email; ?>"><span><?php echo $app_setting->app_email; ?></span></a>
                                </div>
                            </li>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="far fa-phone"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="tel:+91<?php echo $app_setting->app_mobile; ?>">+91<?php echo $app_setting->app_mobile; ?></a>
                                </div>
                            </li>
                        </ul>
                        <div class="header-button mt-4">
                            <a href="contact.html" class="theme-btn text-center">
                                Get A Quote <i class="fa-solid fa-arrow-right-long"></i>
                            </a>
                        </div>
                        <div class="social-icon d-flex align-items-center">
                            <a href="https://www.facebook.com/"><i class="fab fa-facebook-f"></i></a>
                            <a href="https://x.com/"><i class="fab fa-twitter"></i></a>
                            <a href="https://www.youtube.com/"><i class="fab fa-youtube"></i></a>
                            <a href="https://www.linkedin.com/"><i class="fab fa-linkedin-in"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="offcanvas__overlay"></div>

    <div class="header-top-1">
        <div class="container">
            <div class="header-top-wrapper">
                <ul class="contact-list">
                    <li>
                        <i class="fa-regular fa-phone"></i>
                        <a href="tel:+91<?php echo $app_setting->app_mobile; ?>">+91<?php echo $app_setting->app_mobile; ?></a>
                    </li>
                    <li>
                        <i class="far fa-envelope"></i>
                        <a href="mailto:<?php echo $app_setting->app_email; ?>"><?php echo $app_setting->app_email; ?></a>
                    </li>
                </ul>
                <ul class="list">
                    <li class="nav-item">
                        <?php if (session()->get('logged_in')): ?>
                            <!-- User Icon and Name -->
                            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa fa-user-circle me-2"></i> <!-- Font Awesome user icon -->
                                Hello, <?php echo user()->user_name; ?> <!-- Display the logged-in user's name -->
                            </a>

                            <!-- Dropdown Menu -->
                            <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="userDropdown">
                                <!-- Dashboard Option -->
                                <li>
                                    <a class="dropdown-item d-flex align-items-center text-dark" href="<?php echo base_url('my-account'); ?>">
                                        <i class="fas fa-tachometer-alt me-2 text-dark"></i> Dashboard
                                    </a>
                                </li>
                                <!-- Divider -->
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <!-- Logout Option -->
                                <li>
                                    <a class="dropdown-item d-flex align-items-center text-dark" href="<?php echo base_url('logout'); ?>">
                                        <i class="fas fa-sign-out-alt me-2 text-dark"></i> Logout
                                    </a>
                                </li>
                            </ul>
                        <?php else: ?>
                            <div class="d-flex align-items-center">
                                <i class="fa-light fa-sign-in me-2"></i>
                                <a href="<?php echo base_url('login'); ?>" class="nav-link">Login</a>
                            </div>
                        <?php endif; ?>
                    </li>
                    <?php if (!session()->get('logged_in')): ?>
                        <!-- <li class="become-a-author"><i class="fa-light fa-book"></i><a href="#">Become A Author</a></li> -->

                        <li class="nav-item dropdown become-a-author">
                            <a class="nav-link dropdown-toggle become-a-author" href="#" id="authorDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa-light fa-book"></i> Become A Author
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="authorDropdown">
                                <li><a class="dropdown-item text-dark" href="<?php echo base_url(); ?>register-as-author">Register As Author</a>
                                    <hr style="margin: 5px 0;">
                                </li>
                                <li><a class="dropdown-item text-dark" href="<?php echo base_url(); ?>print-cost-calculator">Print Cost Calculator</a>
                                    <hr style="margin: 5px 0;">
                                </li>
                                <li><a class="dropdown-item text-dark" href="<?php echo base_url(); ?>help-for-author">Help For Authors</a>
                                    <hr style="margin: 5px 0;">
                                </li>
                                <li><a class="dropdown-item text-dark" href="<?php echo base_url(); ?>print-your-book">Print Your Book</a>
                                    <hr style="margin: 5px 0;">
                                </li>
                                <li><a class="dropdown-item text-dark" href="<?php echo base_url(); ?>publish-your-book">Publish Your Book</a></li>
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
    <style>
        .header-1 .header-main::before {
            background: var(--header) url(<?php echo base_url($app_setting->app_sticky_logo); ?>) no-repeat center center;
            background-size: 250px;
        }

        @media (max-width: 1600px) {
            .header-1 .header-main::before {
                background: var(--header) url(<?php echo base_url($app_setting->app_sticky_logo); ?>) no-repeat center center;
                background-size: 180px !important;
                height: 168px;
            }

            .header-1.sticky-header .header-main::before {
                background: var(--header) url(<?php echo base_url($app_setting->app_sticky_logo); ?>) no-repeat center center;
                background-size: 180px !important;
                height: 120px;
            }
        }

        @media only screen and (max-width: 786px) {
            .header-1 .header-main::before {
                background: var(--header) url(<?php echo base_url($app_setting->app_sticky_logo); ?>) no-repeat center center;
                background-size: 150px !important;
            }
        }
    </style>

    <!-- Main Header Section start  -->
    <header class="header-1">
        <div class="mega-menu-wrapper">
            <div class="header-main">
                <!-- <div class="logo">
                    <a href="<?php echo base_url(); ?>" class="header-logo">
                        <img src="<?php echo base_url($app_setting->app_sticky_logo); ?>" alt="logo-img" style="height:70px">
                    </a>
                </div> -->
                <div class="container">
                    <div class="row">
                        <div class="col-6 col-md-11 col-lg-11 col-xl-11 col-xxl-11">
                            <div class="header-left">
                                <div class="mean__menu-wrapper">
                                    <div class="main-menu">
                                        <nav id="mobile-menu">
                                            <ul>
                                                <li>
                                                    <a href="<?php echo base_url(); ?>">
                                                        Home
                                                    </a>
                                                </li>
                                                <li class="has-dropdown">
                                                    <a href="#">
                                                        About Us
                                                        <i class="fas fa-angle-down"></i>
                                                    </a>
                                                    <ul class="submenu">
                                                        <li><a href="<?php echo base_url(); ?>general-information"> General Information</a></li>
                                                        <li><a href="<?php echo base_url(); ?>our-team">Our team</a></li>
                                                        <li>
                                                            <a href="<?php echo base_url(); ?>contact">Contact</a>
                                                        </li>
                                                    </ul>
                                                </li>
                                                <li>
                                                    <a href="#">
                                                        Category
                                                        <i class="fas fa-angle-down"></i>
                                                    </a>
                                                    <ul class="submenu">
                                                        <?php
                                                        $all_category = $product->get_all_category_and_sub_categopry_for_home_page();
                                                        foreach ($all_category as $category):
                                                            if ($category->sub_category):
                                                        ?>
                                                                <li class="has-dropdown">
                                                                    <a href="#">
                                                                        <?php echo $category->category_name ?>
                                                                        <i class="fas fa-angle-down"></i>
                                                                    </a>
                                                                    <ul class="submenu">
                                                                        <?php foreach ($category->sub_category as $sub_category) : ?>
                                                                            <li><a href="<?php echo base_url(); ?><?php echo $sub_category->category_slug; ?>"><?php echo $sub_category->category_name; ?></a></li>
                                                                        <?php endforeach; ?>
                                                                    </ul>
                                                                </li>
                                                            <?php else: ?>
                                                                <li><a href="<?php echo base_url(); ?><?php echo $category->category_slug; ?>"><?php echo $category->category_name; ?></a></li>
                                                            <?php endif; ?>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </li>
                                                <li><a href="<?php echo base_url(); ?>event"> Event</a></li>
                                                <li><a href="<?php echo base_url(); ?>media"> Media</a></li>
                                                <li><a href="<?php echo base_url(); ?>blog"> Blog</a></li>
                                                <li class="has-dropdown d-lg-none">
                                                    <a href="#">
                                                        Become An Author
                                                        <i class="fas fa-angle-down"></i>
                                                    </a>
                                                    <ul class="submenu">
                                                        <li><a href="<?php echo base_url(); ?>register-as-author">Register As Author</a></li>
                                                        <li><a href="<?php echo base_url(); ?>print-cost-calculator">Print Cost Calculator</a></li>
                                                        <li><a href="<?php echo base_url(); ?>help-for-author">Help For Authors</a></li>
                                                        <li><a href="<?php echo base_url(); ?>print-your-book">Print Your Book</a></li>
                                                        <li><a href="<?php echo base_url(); ?>publish-your-book">Publish Your Book</a></li>
                                                    </ul>
                                                </li>
                                                <li class="has-dropdown d-lg-none">
                                                    <a href="#">
                                                        Useful Link
                                                        <i class="fas fa-angle-down"></i>
                                                    </a>
                                                    <ul class="submenu">
                                                        <li><a href="<?php echo base_url(); ?>login"> Login</a></li>
                                                        <li><a href="<?php echo base_url(); ?>register"> Register</a></li>
                                                        <li><a href="<?php echo base_url(); ?>track-order"> Track Order</a></li>
                                                        <?php foreach ($all_page as $page):
                                                            if ($page->important == 'Userfull Link'): ?>
                                                                <li><a href="<?php echo base_url(); ?><?php echo $page->slug; ?>"> <?php echo $page->name; ?></a></li>
                                                        <?php endif;
                                                        endforeach; ?>

                                                    </ul>
                                                </li>
                                                <li class="has-dropdown d-lg-none">
                                                    <a href="#">
                                                        Policies
                                                        <i class="fas fa-angle-down"></i>
                                                    </a>
                                                    <ul class="submenu">
                                                        <?php foreach ($all_page as $page):
                                                            if ($page->important == 'Policies'): ?>
                                                                <li><a href="<?php echo base_url(); ?><?php echo $page->slug; ?>"><i class="fa-solid fa-chevrons-right"></i> <?php echo $page->name; ?></a></li>
                                                        <?php endif;
                                                        endforeach; ?>
                                                    </ul>
                                                </li>
                                                <li>
                                                    <a href="<?php echo base_url(); ?>magazine">Magazine</a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                            <div class="header-right">

                                <div class="menu-cart">
                                    <a href="<?php echo base_url(); ?>" class="cart-icon">
                                        <i class="fa-regular fa-heart"></i>
                                    </a>
                                    <a href="#" class="cart-icon cart-icon-desktop sidebar_cart_toggle" id="cart_count_desktop" data-bs-toggle="offcanvas" data-bs-target="#cartOffcanvas" aria-controls="cartOffcanvas">
                                        <?php if ($cart):
                                            $cartContents = $cart->contents();
                                            $cartCount = count($cartContents);
                                        else:
                                            $cartCount = 0; // Fallback if the cart is not initialized
                                        endif; ?>
                                        <style>
                                            .header-1 .header-right .menu-cart .cart-icon.cart-icon-desktop::before {
                                                content: "<?php echo $cartCount; ?>";
                                            }
                                        </style>
                                        <i class="fa-regular fa-cart-shopping"></i>
                                    </a>
                                    <div class="header-humbager ml-30 d-lg-none">
                                        <a class="sidebar__toggle" href="javascript:void(0)">
                                            <div class="bar-icon-2">
                                                <img src="<?php echo front_css(); ?>img/icon/icon-13.svg" alt="img">
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <script>
        <?php
        $errors =  session()->get('error');
        if (isset($errors)) { ?>
            iziToast.error({
                title: 'Error',
                message: '<?php echo $errors ?>',
                position: 'topRight',
                messageColor: '#000'
            });
        <?php }
        session()->remove('error');
        $success =  session()->get('success');
        if (isset($success)) { ?>
            iziToast.success({
                title: 'OK',
                message: '<?php echo $success ?>',
                position: 'topRight',
                messageColor: '#000'
            });
        <?php }
        session()->remove('success');
        ?>
    </script>
    <style>
        .submenu {
            max-height: 300px;
            overflow-y: auto;
            overflow-x: hidden;
            scrollbar-width: thin;
        }

        .header-1 .header-main .main-menu ul li .submenu li:hover>.submenu {
            position: initial;
        }
    </style>