<div class="registration-bg"></div>
<style>
    .registration-bg {
        height: 100vh;
        width: 100%;
        background: linear-gradient(-25deg, white 50%, transparent 50%), #E6EFF2;

        background-repeat: no-repeat, no-repeat;
        background-size: cover, cover;
        background-position: center, center;
    }
</style>

<!-- <section class="mb-5">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 d-flex justify-content-center">
                <div class="login-form-container">
                    <div class="header text-center">
                        <h2>Welcome!</h2>
                        <p>Unlock a World of Deals – Your Next Favorite Find Awaits!</p>
                    </div>
                    <div>
                        <?php echo
                        form_open(base_url() . 'login');
                        ?>
                        <div class="mb-3">
                            <label for="uname" class="form-label">Mobile <span class="text-center">*</span></label>
                            <input type="text" id="mobile" name="user_identifier" class="form-control inp"
                                placeholder="Enter your Mobile No."
                                pattern="[0-9]{10}"
                                title="Please enter a 10-digit mobile number."
                                required>
                        </div>
                        <div class="mb-3 position-relative eye-border">
                            <label for="psw" class="form-label">
                                Password <span class="text-danger">*</span>
                            </label>
                            <div class="input-group">
                                <input placeholder="Enter Your Password" type="password" class="form-control inp" id="psw" name="user_password" required>
                                <button type="button" class="btn btn-outline-secondary toggle-password" tabindex="-1">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary w-100" name="submit">Submit</button>
                        <?php echo
                        form_close();
                        ?>
                    </div>
                    <div class="text-center my-3">
                        <span class="text-muted">Or login with</span>
                    </div>
                    <div class="mb-3">
                        <button class="btn btn-outline-danger w-100">
                            <i class="fa-brands fa-google me-2"></i> Continue with Google
                        </button>
                    </div>
                    <div class="text-center">
                        <a href="#" class="text-decoration-none">Forgot your password?</a>
                    </div>
                    <hr>
                    <div class="text-ceneter">Are You New in <?php echo $app_setting->app_name; ?> ? <a href="<?php echo base_url(); ?>registration">Register Now</a></div>
                </div>
            </div>
        </div>
    </div>
</section> -->
<!-- OTP Modal -->
<div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="otpModalLabel">Enter OTP</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <p class="text-muted">Enter the 6-digit OTP sent to your mobile</p>

                <div id="otp-inputs" class="d-flex justify-content-center">
                    <input type="text" class="otp-field form-control text-center" maxlength="1">
                    <input type="text" class="otp-field form-control text-center" maxlength="1">
                    <input type="text" class="otp-field form-control text-center" maxlength="1">
                    <input type="text" class="otp-field form-control text-center" maxlength="1">
                    <input type="text" class="otp-field form-control text-center" maxlength="1">
                    <input type="text" class="otp-field form-control text-center" maxlength="1">
                </div>

                <small class="text-danger d-none" id="otpError">Invalid OTP. Try again.</small>

                <button id="verifyOtp" class="btn btn-success w-100 mt-3">Verify OTP</button>

                <!-- <p class="mt-2">
                    Didn't receive the OTP? <a href="#" id="resendOtp" class="text-primary">Resend OTP</a>
                </p> -->
            </div>
        </div>
    </div>
</div>

<!-- Login Section -->
<section class="mb-5">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 d-flex justify-content-center">
                <div class="login-form-container">
                    <div class="header text-center">
                        <h2>Welcome!</h2>
                        <p>Unlock a World of Deals – Your Next Favorite Find Awaits!</p>
                    </div>
                    <div>
                        <form id="otp-form">
                            <div class="mb-3">
                                <label for="mobile" class="form-label">Mobile <span class="text-danger">*</span></label>
                                <input type="text" id="mobile" name="user_identifier" class="form-control inp"
                                    placeholder="Enter your Mobile No."
                                    pattern="[0-9]{10}"
                                    title="Please enter a 10-digit mobile number."
                                    required>
                            </div>

                            <div id="recaptcha-container"></div>

                            <button type="button" class="btn btn-primary w-100" id="send-otp">Send OTP</button>
                        </form>
                    </div>
                    <div class="text-center my-3">
                        <span class="text-muted">Or login with</span>
                    </div>
                    <div class="mb-3">
                        <button class="btn btn-outline-danger w-100">
                            <i class="fa-brands fa-google me-2"></i> Continue with Google
                        </button>
                    </div>
                    <div class="text-center">
                        <a href="#" class="text-decoration-none">Forgot your password?</a>
                    </div>
                    <hr>
                    <div class="text-ceneter">Are You New in <?php echo $app_setting->app_name; ?> ? <a href="<?php echo base_url(); ?>registration">Register Now</a></div>
                </div>
            </div>
        </div>
    </div>
</section>


<script type="module">
    import {
        initializeApp
    } from "https://www.gstatic.com/firebasejs/11.3.0/firebase-app.js";
    import {
        getAuth,
        RecaptchaVerifier,
        signInWithPhoneNumber
    } from "https://www.gstatic.com/firebasejs/11.3.0/firebase-auth.js";

    // Firebase Configuration
    const firebaseConfig = {
        apiKey: "AIzaSyCcWrgEVjnwrh3J9HTNs2jTHiUE8Syilgs",
        authDomain: "thegatha-e1180.firebaseapp.com",
        projectId: "thegatha-e1180",
        storageBucket: "thegatha-e1180.appspot.com",
        messagingSenderId: "833289635303",
        appId: "1:833289635303:web:e194d0929d07faec6fe942"
    };

    // Initialize Firebase
    const app = initializeApp(firebaseConfig);
    const auth = getAuth(app);

    let confirmationResult;

    document.getElementById('send-otp').addEventListener('click', function() {
        let mobile = document.getElementById('mobile').value;
        let sendOtpButton = document.getElementById('send-otp');

        if (mobile.length !== 10) {
            iziToast.error({
                title: 'Error',
                message: 'Please enter a valid 10-digit mobile number.',
                position: 'topRight',
                messageColor: '#000'
            });
            return;
        }

        // Disable button and show spinner
        sendOtpButton.innerHTML = `<span class="spinner-border spinner-border-sm"></span> OTP Sending...`;
        sendOtpButton.disabled = true;

        window.recaptchaVerifier = new RecaptchaVerifier(auth, 'recaptcha-container', {
            'size': 'invisible'
        });

        let phoneNumber = "+91" + mobile;

        signInWithPhoneNumber(auth, phoneNumber, window.recaptchaVerifier)
            .then((result) => {
                confirmationResult = result;
                $('#otpModal').modal('show'); // Show the OTP modal
            }).catch((error) => {
                console.error(error);
                iziToast.error({
                    title: 'Error',
                    message: 'Error sending OTP. Try again later.',
                    position: 'topRight',
                    messageColor: '#000'
                });
                sendOtpButton.innerHTML = 'Send OTP';
                sendOtpButton.disabled = false;
            });
    });

    document.getElementById('verifyOtp').addEventListener('click', function() {
        let otp = '';
        document.querySelectorAll('.otp-field').forEach((input) => {
            otp += input.value;
        });

        if (otp.length !== 6 || isNaN(otp)) {
            document.getElementById('otpError').classList.remove('d-none');
            return;
        }

        let verifyOtp = document.getElementById('verifyOtp');
        // Disable button and show spinner
        verifyOtp.innerHTML = `<span class="spinner-border spinner-border-sm"></span> Verify OTP...`;
        verifyOtp.disabled = true;


        confirmationResult.confirm(otp).then((result) => {
            let user = result.user;
            fetch("<?php echo base_url(); ?>verify-otp", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify({
                        mobile: user.phoneNumber
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === "success") {
                        iziToast.success({
                            title: 'Wow!',
                            message: 'You are now Login.',
                            position: 'topRight',
                            messageColor: '#000'
                        });
                        $('#otpModal').modal('hide'); // Close the OTP modal
                        if(data.user_role != 'User')
                        {
                            window.location.href = "<?php echo base_url(); ?>admin/dashboard";
                        }
                        else
                        {
                            window.location.href = "<?php echo base_url(); ?>my-account";
                        }
                        
                    } else {
                        iziToast.error({
                            title: 'Oops!',
                            message: data.message,
                            position: 'topRight',
                            messageColor: '#000'
                        });
                        verifyOtp.innerHTML = 'Verify Otp';
                        verifyOtp.disabled = false;
                    }
                });
        }).catch((error) => {
            console.error(error);
            document.getElementById('otpError').classList.remove('d-none');
            verifyOtp.innerHTML = 'Verify Otp';
            verifyOtp.disabled = false;
        });
    });

    document.querySelectorAll('.otp-field').forEach((input, index, inputs) => {
        input.addEventListener('input', function() {
            if (this.value.length === 1 && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }
        });

        input.addEventListener('keydown', function(e) {
            if (e.key === "Backspace" && index > 0 && this.value === "") {
                inputs[index - 1].focus();
            }
        });
    });

    document.getElementById('resendOtp').addEventListener('click', function(e) {
        e.preventDefault();
        alert("A new OTP has been sent to your mobile.");
        iziToast.success({
            title: 'Wow!',
            message: 'A new OTP has been sent to your mobile.',
            position: 'topRight',
            messageColor: '#000'
        });
    });
</script>


<style>
    .otp-field {
        width: 45px;
        height: 45px;
        font-size: 20px;
        text-align: center;
        border: 2px solid #007bff;
        border-radius: 5px;
        outline: none;
        margin: 0 5px;
    }

    .otp-field:focus {
        border-color: #0056b3;
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
    }
</style>

<div class="padding-bottom-100"></div>