<!-- Fancybox CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />

<!-- Fancybox JS -->
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.umd.js"></script>

<div class="breadcrumb-wrapper">

    <div class="container">
        <div class="page-heading">
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="<?php echo base_url(); ?>">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="container mt-3">
      <div class="row">
          <div class="col-sm-12">
              <?php echo json_decode($data->pp_content)[0]; ?>
          </div>
      </div>
  </div>
<section class="Error-section section-padding fix">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12">
                <div class="calculator-container">
                    <p>Enter book details and hit <strong>CALCULATE COST</strong> to find an estimated price.</p>
                    <form id="printCalculatorForm">
                        <!-- Number of Pages -->
                        <div class="mb-3">
                            <label for="numPages" class="form-label">Number of Pages</label>
                            <input
                                type="number"
                                class="form-control"
                                id="numPages"
                                placeholder="Enter No. Of Pages"
                                min="1"
                                required />
                        </div>

                        <!-- Interior -->
                        <div class="mb-3">
                            <label for="interior" class="form-label">Interior</label>
                            <select class="form-select" id="interior">
                                <option value="bw" selected>Black & White</option>
                                <option value="color">Color</option>
                            </select>
                        </div>

                        <!-- Binding Type -->
                        <div class="mb-3">
                            <label for="binding" class="form-label">Binding Type</label>
                            <select class="form-select" id="binding">
                                <option value="paperback" selected>Paperback</option>
                                <option value="hardcover">Hardcover</option>
                            </select>
                        </div>

                        <!-- Book Size -->
                        <div class="mb-3">
                            <label for="size" class="form-label">Book Size</label>
                            <select class="form-select" id="size">
                                <option value="5x8" selected>5" x 8"</option>
                                <option value="6x9">6" x 9"</option>
                                <option value="8x10">8" x 10"</option>
                            </select>
                        </div>

                        <!-- Paper Type -->
                        <div class="mb-3">
                            <label for="paper" class="form-label">Paper Type</label>
                            <select class="form-select" id="paper">
                                <option value="natural" selected>Natural Shade</option>
                                <option value="white">White</option>
                                <option value="cream">Cream</option>
                            </select>
                        </div>

                        <!-- Calculate Cost Button -->
                        <button
                            type="button"
                            class="theme-btn"
                            onclick="calculateCost()">
                            Calculate Cost
                        </button>
                    </form>

                    <!-- Display the result here -->
                    <div id="result" class="result"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="container mb-5">
      <div class="row">
          <div class="col-sm-12">
              <?php echo json_decode($data->pp_content)[1]; ?>
          </div>
      </div>
  </div>
<script>
    function calculateCost() {
        // 1. Retrieve input values
        const numPages = parseInt(document.getElementById("numPages").value) || 0;
        const interior = document.getElementById("interior").value;
        const binding = document.getElementById("binding").value;
        const size = document.getElementById("size").value;
        const paper = document.getElementById("paper").value;

        // 2. Initialize a base cost (in Rupees)
        let baseCost = 0;

        // 3. Sample cost formula in INR (adjust to your actual costs)

        // Cost based on interior (per page)
        if (interior === "bw") {
            // e.g., ₹0.50 per page for black & white
            baseCost += numPages * 0.5;
        } else if (interior === "color") {
            // e.g., ₹2 per page for color
            baseCost += numPages * 2;
        }

        // Cost based on binding
        if (binding === "paperback") {
            // e.g., ₹50 for paperback binding
            baseCost += 50;
        } else if (binding === "hardcover") {
            // e.g., ₹120 for hardcover binding
            baseCost += 120;
        }

        // Cost based on size
        if (size === "5x8") {
            // e.g., + ₹30
            baseCost += 30;
        } else if (size === "6x9") {
            // e.g., + ₹40
            baseCost += 40;
        } else if (size === "8x10") {
            // e.g., + ₹50
            baseCost += 50;
        }

        // Cost based on paper
        if (paper === "natural") {
            // e.g., + ₹20
            baseCost += 20;
        } else if (paper === "white") {
            // e.g., + ₹25
            baseCost += 25;
        } else if (paper === "cream") {
            // e.g., + ₹30
            baseCost += 30;
        }

        // 4. Format the final cost in INR using Intl.NumberFormat
        //    This will handle Indian numbering format (e.g., 1,00,000)
        const finalCost = new Intl.NumberFormat("en-IN", {
            style: "currency",
            currency: "INR",
        }).format(baseCost);

        // 5. Display the result
        document.getElementById("result").textContent =
            "Estimated Cost: " + finalCost;
    }
</script>

<style>
    /* Optional: Some spacing and styling */
    .calculator-container {
        max-width: 600px;
        margin: 10px auto;
        background: #fff;
        padding: 20px;
        border-radius: 5px;
        box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
    }

    .calculator-title {
        text-align: center;
        margin-bottom: 20px;
    }

    .result {
        margin-top: 20px;
        font-weight: bold;
    }
</style>