<?php
$cart = \Config\Services::cart();
$cart_contents = $cart->contents();
$item_id = $product->prd_id; // The ID you are looking for

$found_item = null;

foreach ($cart_contents as $item) {
    if ($item['id'] == $item_id) {
        $found_item = $item;
        break; // Stop loop once we find the item
    }
}

if ($found_item) {
    $prdQnty = $found_item['qty'];  // Print found item details
} else {
    $prdQnty =1;
}

?>
<div class="breadcrumb-wrapper">
    <div class="container">
        <div class="page-heading">
            <div class="page-header">
                <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                    <li>
                        <a href="<?php echo base_url(); ?>">
                            Home
                        </a>
                    </li>
                    <li>
                        <i class="fa-solid fa-chevron-right"></i>
                    </li>
                    <li>
                        <?php echo $product->prd_name; ?>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<section class="shop-details-section fix section-padding">
    <div class="container">
        <div class="shop-details-wrapper">
            <div class="row g-4">
                <div class="col-lg-5">
                    <div class="shop-details-image">
                        <div class="tab-content">
                            <div id="thumb1" class="tab-pane fade show active">
                                <div class="shop-details-thumb">
                                    <img class="img thumb-main-image" src="<?php echo base_url($product->prd_default_image) ?>" alt="<?php echo $product->prd_name; ?>">
                                </div>
                            </div>
                            <?php if ($prd_extra_image):
                                $i = 2;
                                foreach ($prd_extra_image as $key => $extra_image): ?>
                                    <div id="thumb<?php echo $i; ?>" class="tab-pane fade">
                                        <div class="shop-details-thumb">
                                            <img class="img thumb-main-image" src="<?php echo base_url($extra_image->prd_e_image); ?>" alt="<?php echo $product->prd_name; ?>">
                                        </div>
                                    </div>
                            <?php $i++;
                                endforeach;
                            endif; ?>
                        </div>
                        <ul class="nav">
                            <li class="nav-item">
                                <a href="#thumb1" data-bs-toggle="tab" class="nav-link active">
                                    <img class="img thumb-image" src="<?php echo base_url($product->prd_default_image) ?>" alt="<?php echo $product->prd_name; ?>">
                                </a>
                            </li>
                            <?php if ($prd_extra_image):
                                $i = 2;
                                foreach ($prd_extra_image as $key => $extra_image): ?>
                                    <li class="nav-item">
                                        <a href="#thumb<?php echo $i; ?>" data-bs-toggle="tab" class="nav-link">
                                            <img class="img thumb-image" src="<?php echo base_url($extra_image->prd_e_image); ?>" alt="<?php echo $product->prd_name; ?>">
                                        </a>
                                    </li>
                            <?php $i++;
                                endforeach;
                            endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="shop-details-content">
                        <div class="title-wrapper">
                            <h4><?php echo $product->prd_name; ?></h4>
                            <!-- <h5>Stock availability.</h5> -->
                        </div>
                        <?php
                        $filledStarsTopPrd = (int)$product->rating;
                        $topEmptyStars = 5 - $filledStarsTopPrd;
                        ?>

                        <?php
                        echo '<div class="star">';
                        for ($i = 0; $i < $filledStarsTopPrd; $i++) {
                            echo '<i class="fa-solid fa-star"></i>';
                        }
                        for ($i = 0; $i < $topEmptyStars; $i++) {
                            echo '<i class="fa-regular fa-star"></i>';
                        }
                        echo '<span>(' . $product->rating_user . ' Customer Reviews)</span>';
                        echo '</div>';
                        ?>
                        <?php echo $product->prd_details; ?>
                        <div class="price-list">
                            <?php if ($product->prd_v_offer == 1): ?>
                                <div class="d-flex align-items-center">
                                    <h3>&#8377;<?php echo number_format($product->prd_v_offer_price); ?> </h3>
                                    <del class="">&#8377;<?php echo number_format($product->prd_v_sell_price); ?></del>
                                    <span class="badge bg-success"> <?php echo $product->discount; ?>% OFF</span>
                                </div>
                            <?php else: ?>
                                <h3>&#8377;<?php echo number_format($product->prd_v_sell_price); ?></h3>
                            <?php endif; ?>
                        </div>
                        <div class="cart-wrapper">
                            <div class="quantity-basket">
                                <p class="qty">
                                    <button onclick="var result = document.getElementById('qty2'); var sst = result.value;return false;" class="qtyminus" aria-hidden="true">−</button>
                                    <input type="number" name="qty" id="qty2" min="1" max="100" step="1" value="<?php echo $prdQnty; ?>">
                                    <button onclick="var result = document.getElementById('qty2'); var sst = result.value; return false;" class="qtyplus" aria-hidden="true">+</button>
                                </p>
                            </div>
                            <!-- <button type="button" class="theme-btn style-2" data-bs-toggle="modal" data-bs-target="#readMoreModal">
                                Read A little
                            </button> -->
                            <!-- <div class="modal fade" id="readMoreModal" tabindex="-1" aria-labelledby="readMoreModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body" style="background-image: url(<?php echo front_css(); ?>img/popupBg.png);">
                                            <div class="close-btn">
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>
                                            <div class="readMoreBox">
                                                <div class="content">
                                                    <h3 id="readMoreModalLabel">The Role Of Book</h3>
                                                    <p>
                                                        Educating the Public <br>
                                                        Political books play a crucial role in educating the public about political theories, historical events, policies, and the workings of governments. They provide readers with insights into complex political concepts and the historical context behind current events, helping to foster a more informed citizenry. <br><br>

                                                        Shaping Public Opinion <br>
                                                        Authors of political books often aim to influence public opinion by presenting arguments and perspectives on various issues. These books can sway readers' views, either reinforcing their existing beliefs or challenging them to consider alternative viewpoints. This influence can extend to political debates and discussions in the public sphere. <br><br>

                                                        Documenting History <br>
                                                        Political books serve as valuable records of historical events and political movements. They document the thoughts, actions, and decisions of political leaders and activists, providing future generations with a detailed account of significant periods and events. This historical documentation is essential for understanding the evolution of political systems and ideologies.

                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> -->
                            <a href="javascript:void(0)" onclick="add_to_cart()" class="theme-btn" id="addToCartBtn"><i
                                    class="fa-solid fa-basket-shopping"></i> Add To Cart</a>
                            <div class="icon-box">
                                <a onclick="add_wishlist('<?php echo $product->prd_id ?>')" href="javascript:void(0)" class="icon">
                                    <i class="far fa-heart"></i>
                                </a>
                            </div>
                        </div>
                        <div class="cart-wrapper" style="line-height: .5;">
                            <div class="row justify-content-center">
                                <div class="col-md-12">
                                    <form class="d-flex" id="pincodeForm">
                                        <input
                                            type="text"
                                            class="form-control me-2"
                                            placeholder="Enter Indian Pin Code"
                                            id="pin_code"
                                            aria-label="Search" required value="<?php echo session()->get('zip') ?>">
                                        <button
                                            class="btn btn-primary"
                                            id="pinCodeSubmitBtn"
                                            type="submit" style="background-color: var(--theme);border-color:var(--theme);">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </form>

                                </div>

                            </div>
                            <span id="result_prd_page"></span>
                        </div>
                        <?php if ($product->prd_ttl_page || $product->prd_publish_year != '0000' || $product->prd_format || $product->prd_language): ?>
                            <div class="category-box">
                                <div class="category-list">
                                    <ul class="d-inline-flex">
                                        <?php if ($product->prd_format): ?>
                                            <li>
                                                <span>Format:</span> <?php echo $product->prd_format; ?>
                                            </li>
                                        <?php endif;
                                        if ($product->prd_publish_year != '0000'): ?>
                                            <li>
                                                <span>Publish Years:</span> <?php echo $product->prd_publish_year; ?>
                                            </li>
                                        <?php endif;
                                        if ($product->prd_ttl_page): ?>
                                            <li>
                                                <span>Total page:</span> <?php echo $product->prd_ttl_page; ?>
                                            </li>
                                        <?php endif;
                                        if ($product->prd_language): ?>
                                            <li>
                                                <span>Language:</span> <?php echo $product->prd_language; ?>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>
                        <!-- <div class="box-check">
                            <div class="check-list">
                                <ul>
                                    <li>
                                        <i class="fa-solid fa-check"></i>
                                        Free shipping orders from $150
                                    </li>
                                    <li>
                                        <i class="fa-solid fa-check"></i>
                                        30 days exchange & return
                                    </li>
                                </ul>
                                <ul>
                                    <li>
                                        <i class="fa-solid fa-check"></i>
                                        Mamaya Flash Discount: Starting at 30% Off
                                    </li>
                                    <li>
                                        <i class="fa-solid fa-check"></i>
                                        Safe & Secure online shopping
                                    </li>
                                </ul>
                            </div>
                        </div> -->
                        <?php if ($product->prd_amazone_link || $product->prd_flipkart_link): ?>
                            <div class="social-icon">
                                <h6>Also Available On:</h6>
                                <?php if ($product->prd_amazone_link): ?>
                                    <a class="ms-3" target="_blank" href="<?php echo $product->prd_amazone_link; ?>"><img src="<?php echo front_css(); ?>img/amazon.png" alt="amazon"></a>
                                <?php endif;
                                if ($product->prd_flipkart_link): ?>
                                    <a class="ms-3" target="_blank" href="<?php echo $product->prd_flipkart_link; ?>"><img src="<?php echo front_css(); ?>img/flipkart.png" alt="flipkart"></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="single-tab section-padding pb-0">
                <ul class="nav mb-5" role="tablist">
                    <?php if ($product->prd_description): ?>
                        <li class="nav-item" role="presentation">
                            <a href="#description" data-bs-toggle="tab" class="nav-link ps-0 <?php echo $product->prd_description ? 'active' : ''; ?>"
                                aria-selected="<?php echo $product->prd_description ? 'true' : 'false'; ?>" role="tab">
                                <h6>Description</h6>
                            </a>
                        </li>
                    <?php endif;
                    if ($product->prd_specifications): ?>
                        <li class="nav-item" role="presentation">
                            <a href="#additional" data-bs-toggle="tab" class="nav-link <?php echo !$product->prd_description && $product->prd_specifications ? 'active' : ''; ?>"
                                aria-selected="<?php echo !$product->prd_description && $product->prd_specifications ? 'true' : 'false'; ?>" role="tab">
                                <h6>Specification</h6>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item" role="presentation">
                        <a href="#review" data-bs-toggle="tab" class="nav-link <?php echo !$product->prd_description && !$product->prd_specifications ? 'active' : ''; ?>"
                            aria-selected="<?php echo !$product->prd_description && !$product->prd_specifications ? 'true' : 'false'; ?>" role="tab">
                            <h6>Reviews (0)</h6>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <?php if ($product->prd_description): ?>
                        <div id="description" class="tab-pane fade show active" role="tabpanel">
                            <div class="description-items">
                                <?php echo $product->prd_description; ?>
                            </div>
                        </div>
                    <?php endif;
                    if ($product->prd_specifications): ?>
                        <div id="additional" class="tab-pane fade <?php echo !$product->prd_description ? 'show active' : ''; ?>" role="tabpanel">
                            <?php echo $product->prd_specifications; ?>
                        </div>
                    <?php endif; ?>
                    <div id="review" class="tab-pane fade <?php echo !$product->prd_description && !$product->prd_specifications ? 'show active' : ''; ?>" role="tabpanel">
                        <div class="review-items">

                            <div class="review-wrap-area d-flex gap-4">
                                <div class="review-thumb">
                                    <img src="<?php echo front_css(); ?>img/shop-details/review.png" alt="img">
                                </div>
                                <div class="review-content">
                                    <div
                                        class="head-area d-flex flex-wrap gap-2 align-items-center justify-content-between">
                                        <div class="cont">
                                            <h5><a href="news-details.html">Leslie Alexander</a></h5>
                                            <span>February 10, 2024 at 2:37 pm</span>
                                        </div>
                                        <div class="star">
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-solid fa-star"></i>
                                            <i class="fa-regular fa-star"></i>
                                        </div>
                                    </div>
                                    <p class="mt-30 mb-4">
                                        Neque porro est qui dolorem ipsum quia quaed inventor veritatis et quasi
                                        architecto var sed efficitur turpis gilla sed sit amet finibus eros. Lorem
                                        Ipsum is <br> simply dummy
                                    </p>
                                </div>
                            </div>
                            <?php if (session()->get('logged_in')): ?>
                                <div class="review-title mt-5 py-15 mb-30">
                                    <h4>Your Rating*</h4>
                                    <div class="rate-now d-flex align-items-center">
                                        <p>Your Rating*</p>
                                        <div class="star" id="ratingStars">
                                            <i class="fa-light fa-star" data-value="1"></i>
                                            <i class="fa-light fa-star" data-value="2"></i>
                                            <i class="fa-light fa-star" data-value="3"></i>
                                            <i class="fa-light fa-star" data-value="4"></i>
                                            <i class="fa-light fa-star" data-value="5"></i>
                                        </div>
                                    </div>
                                    <input id="product_rating" name="rate" type="hidden" />
                                    <input type="hidden" name="product_id" id="product_id" value="<?php echo $product->prd_id ?>">
                                    <input type="hidden" name="reviewer_id" id="reviewer_id" value="<?php echo user()->user_id ?>">
                                </div>
                                <div class="review-form">
                                    <form action="#" id="contact-form" method="POST">
                                        <div class="row g-4">
                                            <div class="col-lg-12 wow fadeInUp animated" data-wow-delay=".8">
                                                <div class="form-clt">
                                                    <span>Message*</span>
                                                    <textarea name="comments" id="message"
                                                        placeholder="Write Message" required></textarea>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 wow fadeInUp animated" data-wow-delay=".9">
                                                <div class="form-check d-flex gap-2 from-customradio">
                                                    <input type="checkbox" class="form-check-input"
                                                        name="flexRadioDefault" id="flexRadioDefault12" value="1" required>
                                                    <label class="form-check-label" for="flexRadioDefault12">
                                                        i accept your terms & conditions
                                                    </label>
                                                </div>
                                                <button type="submit" class="theme-btn">
                                                    Submit now
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Top Ratting Book Section Start -->
<section class="top-ratting-book-section fix section-padding pt-0">
    <div class="container">
        <div class="section-title text-center">
            <h2 class="mb-3 wow fadeInUp" data-wow-delay=".3s">Related Products</h2>
        </div>
        <div class="swiper book-slider">
            <div class="swiper-wrapper">
                <?php foreach ($all_related_prd as $related_prd):
                    $filledStarsTopPrd = (int)$related_prd->rating;
                    $topEmptyStars = 5 - $filledStarsTopPrd;
                ?>
                    <div class="swiper-slide">
                        <div class="shop-box-items style-2">
                            <div class="book-thumb center">
                                <a href="<?php echo base_url($related_prd->prd_slug); ?>"><img src="<?php echo base_url($related_prd->prd_default_image); ?>" alt="<?php echo $related_prd->prd_name; ?>"></a>
                                <ul class="post-box">
                                    <?php if ($related_prd->prd_v_offer == 1): ?>
                                        <li>
                                            <?php echo $related_prd->discount; ?>% OFF
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="shop-icon d-grid justify-content-center align-items-center">
                                    <li>
                                        <a href="#"><i class="far fa-heart"></i></a>
                                    </li>

                                </ul>
                            </div>
                            <div class="shop-content">
                                <h3><a href="<?php echo base_url($related_prd->prd_slug); ?>"><?php echo mb_strimwidth($related_prd->prd_name, 0, 30, "..."); ?></a></h3>
                                <ul class="price-list">
                                    <?php if ($related_prd->prd_v_offer == 1): ?>
                                        <li>&#8377;<?php echo number_format($related_prd->prd_v_offer_price); ?></li>
                                        <li>
                                            <del>&#8377;<?php echo number_format($related_prd->prd_v_sell_price); ?></del>
                                        </li>
                                    <?php else: ?>
                                        <li>&#8377;<?php echo number_format($related_prd->prd_v_sell_price); ?></li>
                                    <?php endif; ?>
                                </ul>
                                <ul class="author-post">
                                    <li class="authot-list">
                                        <span class="thumb">
                                            <img src="<?php echo front_css(); ?>img/testimonial/client-1.png" alt="img">
                                        </span>
                                        <span class="content">Wilson</span>
                                    </li>
                                    <?php
                                    echo '<li class="star">';
                                    for ($i = 0; $i < $filledStarsTopPrd; $i++) {
                                        echo '<i class="fa-solid fa-star"></i>';
                                    }
                                    for ($i = 0; $i < $topEmptyStars; $i++) {
                                        echo '<i class="fa-regular fa-star"></i>';
                                    }
                                    echo '</li>';
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

</section>
<input type="hidden" id="prd_id" value="<?php echo $product->prd_id ?>">
<input type="hidden" id="prd_weight" value="<?php echo $product->prd_weight ?>">
<?php
if ($product->prd_v_offer == 1) {
    $price = $product->prd_v_offer_price;
} else {
    $price = $product->prd_v_sell_price;
}
?>
<script>
    var is_product_details_page = true;
    var prd_id = <?php echo $product->prd_id ?>;
    var product_price_with_out_tax = <?php echo $price; ?>;
    var prd_slug = '<?php echo $product->prd_slug; ?>';
    var prd_name = '<?php echo $product->prd_name; ?>';
    var prd_image = '<?php echo $product->prd_default_image; ?>';

    
</script>