  <!-- Breadcumb Section Start -->
   <?php use App\Models\OrderModel;?>
  <div class="breadcrumb-wrapper">

      <div class="container">
          <div class="page-heading">
              <h1>Track Your Order</h1>
              <div class="page-header">
                  <ul class="breadcrumb-items wow fadeInUp" data-wow-delay=".3s">
                      <li>
                          <a href="<?php echo base_url(); ?>">
                              Home
                          </a>
                      </li>
                      <li>
                          <i class="fa-solid fa-chevron-right"></i>
                      </li>
                      <li>
                      Track Order
                      </li>
                  </ul>
              </div>
          </div>
      </div>
  </div>
  <?php if(!$content): ?>
  <div class="container d-flex justify-content-center align-items-center mt-5 mb-5" style="min-height: 80vh;">
      <div class="card shadow-lg p-4" style="max-width: 400px; width: 100%;">
          <div class="card-body">
              <h2 class="text-center mb-4">Track Your Order</h2>
              <?php echo
                form_open(base_url().'track-order');
                ?>
                <div class="mb-3">
                  <label for="name" class="form-label">Order Tracking ID <span class="text-danger">*</span></label>
                  <input type="text" id="name" name="track_id" class="form-control" placeholder="Enter Your Order Tracking ID" required>
              </div>
              <div class="mb-3">
                  <button type="submit" class="btn btn-custom w-100" name="submit">Track Now</button>
              </div>
             <?php echo 
             form_close();
             ?>
          </div>
      </div>
  </div>
  <?php endif; ?>
  <?php if($content): 
        $order = new OrderModel();
        $order_0 = $order->check_order_status_order_id($content->invoice_id, 0);
        $order_1 = $order->check_order_status_order_id($content->invoice_id, 1);
        $order_2 = $order->check_order_status_order_id($content->invoice_id, 2);
        $order_3 = $order->check_order_status_order_id($content->invoice_id, 3);
        $order_4 = $order->check_order_status_order_id($content->invoice_id, 4);
        $order_5 = $order->check_order_status_order_id($content->invoice_id, 5);
        $order_6 = $order->check_order_status_order_id($content->invoice_id, 6);
        $order_status = $order->check_last_order_status($content->invoice_id);
        $order_details_data = $order->get_all_order_details_by_order_id($content->invoice_id);
    ?>
        <div class="container mt-5">
            <article class="card">
                <header class="card-header"> My Orders / Tracking </header>
                <div class="card-body">
                    <article class="card">
                        <div class="card-body row">
                            <div class="col"> <strong>Order ID #:</strong> <br> <?php echo $content->invoice_id; ?> </div>
                            <div class="col"> <strong>Status:</strong> <br>
                                <?php 
                                if($order_status->order_status == '0'):?>
                                    Order Process
                                <?php elseif($order_status->order_status == '1'):?>
                                    Order Accepted
                                <?php elseif($order_status->order_status == '2'):?>
                                    Order Reject
                                <?php elseif($order_status->order_status == '3'):?>
                                    Order Preparing
                                <?php elseif($order_status->order_status == '4'):?>
                                    On The Way
                                <?php elseif($order_status->order_status == '5'):?>
                                    Order Delivered
                                <?php elseif($order_status->order_status == '6'):?>
                                    Order Placed
                                <?php endif;?>
                            </div>
                            <div class="col"> <strong>Tracking #:</strong> <br> <?php echo $tracking_id; ?> </div>
                        </div>
                    </article>
                    <div class="track">
                        
                        <div class="step <?php if($order_1){echo 'active';}?>"> <span class="icon"> <i class="fa fa-check"></i> </span> <span class="text">Order confirmed</span> </div>

                        <div class="step <?php if($order_3){echo 'active';}?>"> <span class="icon"> <i class="fa fa-spinner"></i> </span> <span class="text"> Order Preparing</span> </div>

                        <div class="step <?php if($order_4){echo 'active';}?>"> <span class="icon"> <i class="fa fa-truck"></i> </span> <span class="text"> On the way </span> </div>

                        <div class="step <?php if($order_5){echo 'active';}?>"> <span class="icon"> <i class="fa fa-home"></i> </span> <span class="text">Delivered</span> </div>

                    </div>
                    <hr>
                    <ul class="row mt-4">
                        <?php foreach ($order_details_data as $details_data):?>
                            <li class="col-md-4">
                                <figure class="itemside mb-3">
                                    <div class="aside"><img src="<?php echo base_url(); ?><?php echo $details_data->prd_default_image; ?>" class="img-sm border"></div>
                                    <figcaption class="info align-self-center">
                                        <p class="title"><?php echo $details_data->prd_name; ?></p> <span class="text-muted">₹<?php echo $details_data->order_price; ?> </span>
                                    </figcaption>
                                </figure>
                            </li>
                        <?php endforeach;?>
                    </ul>
                    <hr>
                    <a href="<?php echo base_url() ?>" class="btn btn-warning" data-abc="true"> <i class="fa fa-chevron-left"></i> Back to Home</a>
                </div>
            </article>
        </div>
    <?php endif;?>