let deferredPrompt;

window.addEventListener("beforeinstallprompt", (event) => {
    // Prevent the default browser install prompt
    event.preventDefault();
    deferredPrompt = event;

    // Show the custom install banner
    document.getElementById("custom-install-banner").style.display = "block";
});

const installButton = document.getElementById("install-button");
const dismissButton = document.getElementById("dismiss-button");

installButton.addEventListener("click", async () => {
    if (deferredPrompt) {
        // Show the browser's install prompt
        deferredPrompt.prompt();

        // Wait for the user's response
        const { outcome } = await deferredPrompt.userChoice;

        if (outcome === "accepted") {
            console.log("User accepted the install prompt");
        } else {
            console.log("User dismissed the install prompt");
        }

        // Clear the deferredPrompt to avoid reuse
        deferredPrompt = null;
    }

    // Hide the custom banner
    document.getElementById("custom-install-banner").style.display = "none";
});

dismissButton.addEventListener("click", () => {
    // Hide the custom banner
    document.getElementById("custom-install-banner").style.display = "none";
});
