/*-----------------------------------------------------------------

Template Name: Bookle - Book Store WooCommerce Html Template 
Author:  Gramentheme
Author URI: https://themeforest.net/user/gramentheme/portfolio
Version: 1.0.0
Description: Bookle - Book Store WooCommerce Html Template  
------------------------------------------------------------------*/
/*=================================
   Index Here
==================================*/
/*
01. Mobile Menu 
02. Sidebar Toggle 
03. Body Overlay
04. Video Popup
05. Counterup
06. Wow Animation
07. Nice Select
8.  Book Slider
09. Testimonial Slider
10. Team Slider
11. Range Slider
12. Quantity
13. Back to top btn
14. Category-click
15. Gsap Animation  
*/
/*=================================
   Index End
==================================*/

(function ($) {
    "use strict";

    $(document).ready(function () {

        // slider
        if ($('.owl-carousel').length > 0) {
            $(".owl-carousel").owlCarousel({
                items: 1,
                loop: !0,
                nav: !1,
                autoplay: 1,
                autoplayTimeout: 5000, // 3000 milliseconds (3 seconds)
                animateOut: "fadeOut",
                animateIn: "fadeIn"
            });
        }
        // 01.Mobile Menu  
        $('#mobile-menu').meanmenu({
            meanMenuContainer: '.mobile-menu',
            meanScreenWidth: "1199",
            meanExpand: ['<i class="far fa-plus"></i>'],
        });

        // 02.Sidebar Toggle 
        $(".offcanvas__close,.offcanvas__overlay").on("click", function () {
            $(".offcanvas__info").removeClass("info-open");
            $(".offcanvas__overlay").removeClass("overlay-open");
        });
        $(".sidebar__toggle").on("click", function () {
            $(".offcanvas__info").addClass("info-open");
            $(".offcanvas__overlay").addClass("overlay-open");
        });
        $(".sidebar_cart_toggle").on("click", function () {
            $(".offcanvas__info.cart").addClass("info-open");
            $(".offcanvas__overlay.cart").addClass("overlay-open");
        });

        // 03.Body Overlay 
        $(".body-overlay").on("click", function () {
            $(".offcanvas__area").removeClass("offcanvas-opened");
            $(".df-search-area").removeClass("opened");;
            $(".body-overlay").removeClass("opened");
        });


        $(window).on('scroll', function () {
            const mainHeaderHeight = $('.header-main').outerHeight();

            if ($(window).scrollTop() > mainHeaderHeight) {
                // $('.sticky-header').css('transform', 'translateY(0)');
                $('.header-top-1').hide();
                $('.header-1').addClass('sticky-header');
            } else {
                // $('.sticky-header').css('transform', 'translateY(-180%)');
                $('.header-top-1').show();
                $('.header-1').removeClass('sticky-header');
            }
        });

        // 04.Video Popup 
        $(".img-popup").magnificPopup({
            type: "image",
            gallery: {
                enabled: true,
            },
        });

        $('.video-popup').magnificPopup({
            type: 'iframe',
            callbacks: {
            }
        });

        // 05. Counterup 
        $(".count").counterUp({
            delay: 15,
            time: 4000,
        });

        // 06.Wow Animation 
        new WOW().init();

        // 07.Nice Select 
        // $('select').niceSelect();

        //  08.Book Slider 
        if ($('.hero-book-slider').length > 0) {
            const heroBookSlider = new Swiper(".hero-book-slider", {
                spaceBetween: 30,
                speed: 2000,
                loop: true,

                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
            });
        }

        if ($('.book-slider').length > 0) {
            const bookSlider = new Swiper(".book-slider", {
                spaceBetween: 15,
                speed: 2000,
                loop: true,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                breakpoints: {
                    1499: {
                        slidesPerView: 6,
                    },
                    1399: {
                        slidesPerView: 5,
                    },
                    1199: {
                        slidesPerView: 5,
                    },
                    991: {
                        slidesPerView: 3,
                    },
                    767: {
                        slidesPerView: 2,
                    },
                    575: {
                        slidesPerView: 2,
                    },
                    0: {
                        slidesPerView: 2,
                    },
                },
            });
        }

        if ($('.featured-books-slider').length > 0) {
            const featuredBookSlider = new Swiper(".featured-books-slider", {
                spaceBetween: 30,
                speed: 2000,
                loop: true,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                centeredSlides: true,
                breakpoints: {
                    1499: {
                        slidesPerView: 2,
                    },
                    1399: {
                        slidesPerView: 2,
                    },
                    1199: {
                        slidesPerView: 1,
                    },
                    991: {
                        slidesPerView: 1,
                    },
                    767: {
                        slidesPerView: 1,
                    },
                    575: {
                        slidesPerView: 1,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
            });
        }

        if ($('.book-catagories-slider').length > 0) {
            const bookCatagoriesSlider = new Swiper(".book-catagories-slider", {
                spaceBetween: 30,
                speed: 2000,
                loop: true,
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    1399: {
                        slidesPerView: 5,
                    },
                    1199: {
                        slidesPerView: 4,
                    },
                    991: {
                        slidesPerView: 3,
                    },
                    767: {
                        slidesPerView: 2,
                    },
                    575: {
                        slidesPerView: 1,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
            });
        }

        //  09.Testimonial Slider  
        if ($('.testimonial-slider').length > 0) {
            const testimonialSlider = new Swiper(".testimonial-slider", {
                centeredSlides: true,
                spaceBetween: 30,
                speed: 2000,
                loop: true,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                breakpoints: {
                    1399: {
                        slidesPerView: 3,
                    },
                    1199: {
                        slidesPerView: 2,
                        centeredSlides: false,
                    },
                    991: {
                        slidesPerView: 2,
                    },
                    575: {
                        slidesPerView: 1,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
            });
        }

        //  10.Team Slider  
        if ($('.team-slider').length > 0) {
            const teamSlider = new Swiper(".team-slider", {
                spaceBetween: 30,
                speed: 2500,
                loop: true,
                autoplay: {
                    delay: 2500,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    1399: {
                        slidesPerView: 6,
                    },
                    1199: {
                        slidesPerView: 4,
                    },
                    991: {
                        slidesPerView: 3,
                    },
                    767: {
                        slidesPerView: 2,
                    },
                    575: {
                        slidesPerView: 1,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
            });
        }

        // 11.Range sliger
        function getVals() {
            let parent = this.parentNode;
            let slides = parent.getElementsByTagName("input");
            let slide1 = parseFloat(slides[0].value);
            let slide2 = parseFloat(slides[1].value);
            if (slide1 > slide2) {
                let tmp = slide2;
                slide2 = slide1;
                slide1 = tmp;
            }

            let displayElement = parent.getElementsByClassName("rangeValues")[0];
            displayElement.innerHTML = "$" + slide1 + " - $" + slide2;
        }

        window.onload = function () {
            let sliderSections = document.getElementsByClassName("range-slider");
            for (let x = 0; x < sliderSections.length; x++) {
                let sliders = sliderSections[x].getElementsByTagName("input");
                for (let y = 0; y < sliders.length; y++) {
                    if (sliders[y].type === "range") {
                        sliders[y].oninput = getVals;
                        sliders[y].oninput();
                    }
                }
            }
        }

        progressBar: () => {
            const pline = document.querySelectorAll(".progressbar.line");
            const pcircle = document.querySelectorAll(".progressbar.semi-circle");
            pline.forEach(e => {
                const line = new ProgressBar.Line(e, {
                    strokeWidth: 6,
                    trailWidth: 6,
                    duration: 3000,
                    easing: 'easeInOut',
                    text: {
                        style: {
                            color: 'inherit',
                            position: 'absolute',
                            right: '0',
                            top: '-30px',
                            padding: 0,
                            margin: 0,
                            transform: null
                        },
                        autoStyleContainer: false
                    },
                    step: (state, line) => {
                        line.setText(Math.round(line.value() * 100) + ' %');
                    }
                });
                let value = e.getAttribute('data-value') / 100;
                new Waypoint({
                    element: e,
                    handler: function () {
                        line.animate(value);
                    },
                    offset: 'bottom-in-view',
                })
            });
            pcircle.forEach(e => {
                const circle = new ProgressBar.SemiCircle(e, {
                    strokeWidth: 6,
                    trailWidth: 6,
                    duration: 2000,
                    easing: 'easeInOut',
                    step: (state, circle) => {
                        circle.setText(Math.round(circle.value() * 100));
                    }
                });
                let value = e.getAttribute('data-value') / 100;
                new Waypoint({
                    element: e,
                    handler: function () {
                        circle.animate(value);
                    },
                    offset: 'bottom-in-view',
                })
            });
        }

        const rangeInput = document.querySelectorAll(".range-input input"),
            priceInput = document.querySelectorAll(".price-input input"),
            range = document.querySelector(".slider .progress");
        let priceGap = 1000;

        priceInput.forEach((input) => {
            input.addEventListener("input", (e) => {
                let minPrice = parseInt(priceInput[0].value),
                    maxPrice = parseInt(priceInput[1].value);

                if (maxPrice - minPrice >= priceGap && maxPrice <= rangeInput[1].max) {
                    if (e.target.className === "input-min") {
                        rangeInput[0].value = minPrice;
                        range.style.left = (minPrice / rangeInput[0].max) * 100 + "%";
                    } else {
                        rangeInput[1].value = maxPrice;
                        range.style.right = 100 - (maxPrice / rangeInput[1].max) * 100 + "%";
                    }
                }
            });
        });

        rangeInput.forEach((input) => {
            input.addEventListener("input", (e) => {
                let minVal = parseInt(rangeInput[0].value),
                    maxVal = parseInt(rangeInput[1].value);

                if (maxVal - minVal < priceGap) {
                    if (e.target.className === "range-min") {
                        rangeInput[0].value = maxVal - priceGap;
                    } else {
                        rangeInput[1].value = minVal + priceGap;
                    }
                } else {
                    priceInput[0].value = minVal;
                    priceInput[1].value = maxVal;
                    range.style.left = (minVal / rangeInput[0].max) * 100 + "%";
                    range.style.right = 100 - (maxVal / rangeInput[1].max) * 100 + "%";
                }
            });
        });

        //12. Quantity 
        const inputs = document.querySelectorAll('#qty, #qty2, #qty3');
        const btnminus = document.querySelectorAll('.qtyminus');
        const btnplus = document.querySelectorAll('.qtyplus');

        if (inputs.length > 0 && btnminus.length > 0 && btnplus.length > 0) {

            inputs.forEach(function (input, index) {
                const min = Number(input.getAttribute('min'));
                const max = Number(input.getAttribute('max'));
                const step = Number(input.getAttribute('step'));

                function qtyminus(e) {
                    const current = Number(input.value);
                    const newval = (current - step);
                    if (newval < min) {
                        newval = min;
                    } else if (newval > max) {
                        newval = max;
                    }
                    input.value = Number(newval);
                    e.preventDefault();
                }

                function qtyplus(e) {
                    const current = Number(input.value);
                    const newval = (current + step);
                    if (newval > max) newval = max;
                    input.value = Number(newval);
                    e.preventDefault();
                }

                btnminus[index].addEventListener('click', qtyminus);
                btnplus[index].addEventListener('click', qtyplus);
            });
        }

        // 13.Back to top btn    
        $(window).scroll(function () {
            if ($(this).scrollTop() > 20) {
                $("#back-top").addClass("show");
            } else {
                $("#back-top").removeClass("show");
            }
        });
        $("#back-top").click(function () {
            $("html, body").animate({ scrollTop: 0 }, 800);
            return false;
        });

        // 14.Category-click
        $(".bd-category__click").click(function () {
            $(this).siblings(".category__items, .category__items-2, .category__items-3, .category__items-4").slideToggle();
            $(this).toggleClass("items-open");
        });

        //  15.Gsap Animation 
        // if ($('.cursor-follower').length > 0) {
        //     var follower = $(".cursor-follower");

        //     var posX = 0,
        //         posY = 0;

        //     var mouseX = 0,
        //         mouseY = 0;

        //     TweenMax.to({}, 0.016, {
        //         repeat: -1,
        //         onRepeat: function () {
        //             posX += (mouseX - posX) / 9;
        //             posY += (mouseY - posY) / 9;

        //             TweenMax.set(follower, {
        //                 css: {
        //                     left: posX - 12,
        //                     top: posY - 12
        //                 }
        //             });
        //         }
        //     });

        //     $(document).on("mousemove", function (e) {
        //         mouseX = e.clientX;
        //         mouseY = e.clientY;
        //     });
        // }
        if (is_product_details_page) {
            check_city_pin_code_with_details();
        }

    }); // End Document Ready Function



    function loader() {
        $(window).on('load', function () {
            // Animate loader off screen
            $(".preloader").addClass('loaded');
            $(".preloader").delay(600).fadeOut();
        });
    }

    loader();
    if (is_product_details_page) {

        document.getElementById('pincodeForm').addEventListener('submit', function (e) {
            e.preventDefault();
            check_city_pin_code_with_details();
        });
        // Listen for input in the pin code field
        document.getElementById('pin_code').addEventListener('input', function (e) {
            e.preventDefault();
            var pinCode = document.getElementById('pin_code').value;

            // If the pin code is exactly 6 digits, automatically submit the form
            if (pinCode.length === 6 && !isNaN(pinCode)) {
                check_city_pin_code_with_details();
            }
        });

        document.addEventListener('DOMContentLoaded', function () {
            const stars = document.querySelectorAll('#ratingStars .fa-star');
            let selectedRating = 0;

            // Hover effect to highlight stars
            stars.forEach(star => {
                star.addEventListener('mouseover', function () {
                    const ratingValue = parseInt(this.getAttribute('data-value'));
                    highlightStars(ratingValue);
                });

                star.addEventListener('mouseout', function () {
                    highlightStars(selectedRating); // Revert to selected rating on mouseout
                });

                // Click event to select rating
                star.addEventListener('click', function () {
                    selectedRating = parseInt(this.getAttribute('data-value'));
                    highlightStars(selectedRating);
                    $('#product_rating').val(selectedRating);
                });
            });

            // Function to highlight stars up to a given value
            function highlightStars(rating) {
                stars.forEach(star => {
                    const value = parseInt(star.getAttribute('data-value'));
                    if (value <= rating) {
                        star.classList.add('fas'); // Solid star
                        star.classList.remove('fa-light'); // Outline star
                    } else {
                        star.classList.add('fa-light'); // Outline star
                        star.classList.remove('fas'); // Solid star
                    }
                });
            }
        });
    }

})(jQuery); // End jQuery

// check delivery address
function check_city_pin_code_with_details(ids = null) {
    var pin_code = $('#pin_code').val();
    if (!pin_code) {
        return false;
    }
    if (pin_code) {
        var id = pin_code;
        var prd_id = $('#prd_id').val();;
        var prd_weight = $('#prd_weight').val();;
        $.ajax({
            beforeSend: function () {
                const $submitBtn = $('#pinCodeSubmitBtn');
                $submitBtn.html('<i class="fas fa-spinner fa-spin"></i>').prop('disabled', true);

            },
            url: base_url + "get_delivery_details_by_pin_code",
            method: "POST",
            dataType: "json",
            data: {
                id: id, prd_id: prd_id, prd_weight: prd_weight
            },
            success: function (data) {
                if (data.type === "error") {
                    $('#result_prd_page').html(data.result);
                }
                else {
                    $('#result_prd_page').html(data.result);
                }
                const $submitBtn = $('#pinCodeSubmitBtn');
                $submitBtn.html('<i class="fas fa-search"></i>').prop('disabled', false);
            },
            error: function (xhr, textStatus) {
                // console.log(xhr.responseText);
                const $submitBtn = $('#pinCodeSubmitBtn');
                $submitBtn.html('<i class="fas fa-search"></i>').prop('disabled', false);
            }
        });
    } else {
        const $submitBtn = $('#pinCodeSubmitBtn');
        $submitBtn.html('<i class="fas fa-search"></i>').prop('disabled', false);
    }
}

// add to cart
function add_to_cart() {
    var pin_code = $('#pin_code').val();
    if (!pin_code) {
        iziToast.warning({
            title: 'Oops!',
            message: 'Please Enter Your Delivery Pin Code.',
            position: 'topRight',
            messageColor: '#000'
        });
        $('#pin_code').css('border-color', 'red');
    } else {
        var qty = $('#qty2').val();
        var prd_price = product_price_with_out_tax;
        $.ajax({
            beforeSend: function () {
                const $submitBtn = $('#addToCartBtn');
                $submitBtn.html('<i class="fas fa-spinner fa-spin"></i>').prop('disabled', true);
            },
            type: "POST",
            url: base_url + "add_to_cart",
            data: {
                prd_id: prd_id,
                qty: qty,
                prd_price: prd_price,
                prd_slug: prd_slug,
                prd_name: prd_name,
                prd_image: prd_image
            },
            success: function (data) {
                console.log(data);
                const $submitBtn = $('#addToCartBtn');
                $submitBtn.html('<i class="fa-solid fa-basket-shopping"></i> Add To Cart').prop('disabled', false);
                iziToast.success({
                    title: 'OK',
                    message: 'Product Successfully Added in your Cart',
                    position: 'topRight',
                    messageColor: '#000'
                });
                $("#cart_count_desktop").load(window.location.href + " #cart_count_desktop");
                $("#cart_count_mobile").load(window.location.href + " #cart_count_mobile");
                $("#cart_product_list").load(window.location.href + " #cart_product_list");
                $("#cart_grand_total").load(window.location.href + " #cart_grand_total");


            },
            error: function (xhr) {
                console.log(xhr.responseText)
                const $submitBtn = $('#addToCartBtn');
                $submitBtn.html('<i class="fa-solid fa-basket-shopping"></i> Add To Cart').prop('disabled', false);
                iziToast.error({
                    title: 'Oops!',
                    message: 'Product Added Failed.',
                    position: 'topRight',
                    messageColor: '#000'
                });
            }
        });
    }
}

// Delete product from cart
function remove_cart(cart_id) {
    // Show a confirmation dialog with "Yes" and "No" options using iziToast
    iziToast.show({
        title: 'Are you sure?',
        message: 'Do you want to delete this product from your cart?',
        position: 'topRight',
        backgroundColor: '#333',  // Dark background color
        theme: 'dark',
        buttons: [
            [
                '<button>Yes</button>',
                function (instance, toast) {
                    $.ajax({
                        beforeSend: function () {
                            $(".preloader-ajax").show();
                            $(".preloader-ajax-bg").show();
                        },
                        type: "POST",
                        url: base_url + "remove_cart",
                        data: { cart_id: cart_id },
                        success: function (data) {
                            // Reload cart sections after product deletion
                            $("#cart_count_desktop").load(window.location.href + " #cart_count_desktop");
                            $("#cart_count_mobile").load(window.location.href + " #cart_count_mobile");
                            $("#cart_product_list").load(window.location.href + " #cart_product_list");
                            $("#cart_grand_total").load(window.location.href + " #cart_grand_total");
                            $(".preloader-ajax").hide();
                            $(".preloader-ajax-bg").hide();
                            instance.hide({ transitionOut: 'fadeOut' }, toast, 'button');
                            // Show success message
                            iziToast.success({
                                title: 'Success',
                                message: 'Product successfully deleted from your cart!',
                                position: 'topRight',
                            });

                        },
                        error: function (xhr, textStatus) {
                            console.log(xhr.responseText);
                            $(".preloader-ajax").hide();
                            $(".preloader-ajax-bg").hide();
                        }
                    });
                }
            ],
            [
                '<button>No</button>',
                function (instance, toast) {
                    // Close the iziToast dialog if No is clicked
                    instance.hide({ transitionOut: 'fadeOut' }, toast, 'button');
                }
            ]
        ]
    });
}
if (login) {
    document.querySelector('.toggle-password').addEventListener('click', function () {
        const passwordInput = document.getElementById('psw');
        const icon = this.querySelector('i');
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    });
}


$("#mobile").on("input", function () {
    let mobile = $('#mobile').val().trim();
    if (mobile.length === 10 && /^[0-9]{10}$/.test(mobile)) {
        $.ajax({
            type: "POST",
            url: base_url + 'check_mobile_avaliblity',
            data: { mobile: mobile },
            beforeSend: function () {
                $(".loader").show();
            },
            success: function (response) {
                if (response == 1) {
                    $("#mobile_error").text("Mobile No. Already Exists");
                    $('#submit_button').attr('disabled', true);
                    $('#mobile').addClass('is-invalid');
                    console.log("hello")
                } else {
                    $('#submit_button').attr('disabled', false);
                    $("#mobile_error").text("");
                    $('#mobile').removeClass('is-invalid');
                    $('#mobile').addClass('is-valid');
                }
            },
            error: function (xhr) {
                $(".loader").hide();
                console.log(xhr.responseText);
            }
        });
    }
    else {
        $('#submit_button').attr('disabled', true);
        $('#mobile').removeClass('is-invalid');
        $('#mobile').removeClass('is-valid');
        $("#mobile_error").text("");
    }
});

$("#email").on("input", function () {
    let email = $('#email').val().trim();
    if (/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
        $.ajax({
            type: "POST",
            url: base_url + 'check_email_avaliblity',
            data: { email: email },
            beforeSend: function () {
                $(".loader").show();
            },
            success: function (response) {
                if (response == 1) {
                    $("#email_error").text("Email ID. Already Exists");
                    $('#submit_button').attr('disabled', true);
                    $('#email').addClass('is-invalid');
                    console.log("hello")
                } else {
                    $('#submit_button').attr('disabled', false);
                    $("#email_error").text("");
                    $('#email').removeClass('is-invalid');
                    $('#email').addClass('is-valid');
                }
            },
            error: function (xhr) {
                $(".loader").hide();
                console.log(xhr.responseText);
            }
        });
    }
    else {
        $('#submit_button').attr('disabled', true);
        $('#email').removeClass('is-invalid');
        $('#email').removeClass('is-valid');
        $("#email_error").text("");
    }
});