const CACHE_NAME = "pwa-cache-v1";
const urlsToCache = [
    "/",
    "/front/css/bootstrap.min.css",
    "/front/css/all.min.css",
    "/front/css/animate.css",
    "/front/css/magnific-popup.css",
    "/front/css/meanmenu.css",
    "/front/css/swiper-bundle.min.css",
    "/front/css/nice-select.css",
    "/front/css/icomoon.css",
    "/front/css/main.css",
    "/front/js/jquery-3.7.1.min.js",
    "/front/js/viewport.jquery.js",
    "/front/js/bootstrap.bundle.min.js",
    "/front/js/jquery.nice-select.min.js",
    "/front/js/jquery.waypoints.js",
    "/front/js/jquery.counterup.min.js",
    "/front/js/swiper-bundle.min.js",
    "/front/js/jquery.meanmenu.min.js",
    "/front/js/jquery.magnific-popup.min.js",
    "/front/js/wow.min.js",
    "/front/js/gsap.min.js",
    "/front/js/main.js",
    "/manifest.json",
];

self.addEventListener("install", (event) => {
    event.waitUntil(
        caches.open(CACHE_NAME).then((cache) => {
            return Promise.all(
                urlsToCache.map((url) =>
                    fetch(url)
                        .then((response) => {
                            if (!response.ok) {
                                throw new Error(`Failed to fetch ${url}: ${response.statusText}`);
                            }
                            return cache.put(url, response);
                        })
                        .catch((error) => {
                            console.error("Caching failed for:", url, error);
                        })
                )
            );
        })
    );
});


self.addEventListener("fetch", (event) => {
    event.respondWith(
        caches.match(event.request).then((response) => {
            return response || fetch(event.request);
        })
    );
});

self.addEventListener("activate", (event) => {
    const cacheWhitelist = [CACHE_NAME];
    event.waitUntil(
        caches.keys().then((cacheNames) =>
            Promise.all(
                cacheNames.map((cacheName) => {
                    if (!cacheWhitelist.includes(cacheName)) {
                        return caches.delete(cacheName);
                    }
                })
            )
        )
    );
});
